/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.ir.GroupDesign;

public class GroupContent
extends AbstractContent
implements IGroupContent {
    Boolean headerRepeat;
    String groupId;
    transient int groupLevel = -1;
    protected static final short FIELD_HEADER_REPEAT = 1500;

    GroupContent(IGroupContent group) {
        super(group);
        this.headerRepeat = group.isHeaderRepeat();
        this.groupId = group.getGroupID();
    }

    @Override
    public int getContentType() {
        return 15;
    }

    GroupContent(IReportContent report) {
        super(report);
    }

    @Override
    public IBandContent getHeader() {
        return this.getBand(3);
    }

    @Override
    public IBandContent getFooter() {
        return this.getBand(4);
    }

    protected IBandContent getBand(int type) {
        if (this.children == null) {
            return null;
        }
        for (Object child : this.children) {
            IBandContent band;
            if (!(child instanceof IBandContent) || (band = (IBandContent)child).getBandType() != type) continue;
            return band;
        }
        return null;
    }

    @Override
    public String getGroupID() {
        return this.groupId;
    }

    @Override
    public void setGroupID(String groupId) {
        this.groupId = groupId;
    }

    @Override
    public boolean isHeaderRepeat() {
        if (this.headerRepeat != null) {
            return this.headerRepeat;
        }
        if (this.generateBy instanceof GroupDesign) {
            GroupDesign design = (GroupDesign)this.generateBy;
            return design.isHeaderRepeat();
        }
        return false;
    }

    @Override
    public int getGroupLevel() {
        if (this.groupLevel == -1) {
            if (this.generateBy instanceof GroupDesign) {
                GroupDesign design = (GroupDesign)this.generateBy;
                this.groupLevel = design.getGroupLevel();
            } else if (this.parent instanceof GroupContent) {
                this.groupLevel = ((GroupContent)this.parent).getGroupLevel();
            } else {
                return 0;
            }
        }
        return this.groupLevel;
    }

    @Override
    public void setHeaderRepeat(boolean repeat) {
        this.headerRepeat = repeat;
    }

    @Override
    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitGroup(this, value);
    }

    @Override
    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.headerRepeat != null) {
            IOUtil.writeShort(out, (short)1500);
            IOUtil.writeBool(out, this.headerRepeat);
        }
    }

    @Override
    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 1500: {
                this.headerRepeat = IOUtil.readBool(in);
                break;
            }
            default: {
                super.readField(version, filedId, in, loader);
            }
        }
    }

    @Override
    public boolean needSave() {
        if (this.headerRepeat != null) {
            return true;
        }
        return super.needSave();
    }

    @Override
    protected IContent cloneContent() {
        return new GroupContent(this);
    }
}

