/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ContentUtil;
import org.eclipse.birt.report.item.crosstab.core.re.executor.EdgeGroup;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;
import org.eclipse.birt.report.item.crosstab.core.re.executor.IColumnWalker;
import org.eclipse.birt.report.model.api.DimensionHandle;

public class TableColumnGenerator
implements ICrosstabConstants {
    private static Logger logger = Logger.getLogger(TableColumnGenerator.class.getName());
    private IColumnWalker walker;
    private CrosstabReportItemHandle crosstabItem;
    private EdgeCursor columnCursor;
    private List<DimensionCursor> groupCursors;
    private List<EdgeGroup> columnGroups;
    private int[] pageBreakBeforeInts;
    private int[] pageBreakAfterInts;
    private boolean[] hasTotalBefore;
    private boolean[] hasTotalAfter;
    private int[] firstTotalMeasureIndex;
    private int[] lastTotalMeasureIndex;
    private int[] columnLevelPageBreakIntervals;
    private long[] lastColumnLevelState;
    private long[] checkedColumnLevelState;
    private final int forcedColumnLevelPageBreakInterval;
    private int lastMeasureIndex;
    private int firstGrandTotalMeasureIndex;
    private int notifyNextPageBreak;
    private String rowDimension;
    private String rowLevel;
    private boolean repeatRowHeader;

    TableColumnGenerator(CrosstabReportItemHandle item, IColumnWalker walker, IBaseResultSet resultSet, EdgeCursor columnCursor, List<EdgeGroup> columnGroups) throws OLAPException {
        DimensionViewHandle dv;
        int rdCount;
        this.crosstabItem = item;
        this.walker = walker;
        this.repeatRowHeader = this.crosstabItem.isRepeatRowHeader();
        this.columnLevelPageBreakIntervals = GroupUtil.getLevelPageBreakIntervals(this.crosstabItem, columnGroups, 1);
        this.forcedColumnLevelPageBreakInterval = this.crosstabItem.getColumnPageBreakInterval();
        this.columnCursor = columnCursor;
        this.columnGroups = columnGroups;
        if (columnCursor != null) {
            this.groupCursors = columnCursor.getDimensionCursor();
        }
        if (columnGroups.size() > 0) {
            List mvs;
            this.pageBreakBeforeInts = new int[columnGroups.size()];
            this.pageBreakAfterInts = new int[columnGroups.size()];
            this.hasTotalBefore = new boolean[columnGroups.size()];
            this.hasTotalAfter = new boolean[columnGroups.size()];
            Arrays.fill(this.hasTotalBefore, false);
            Arrays.fill(this.hasTotalAfter, false);
            this.firstTotalMeasureIndex = new int[columnGroups.size()];
            this.lastTotalMeasureIndex = new int[columnGroups.size()];
            Arrays.fill(this.firstTotalMeasureIndex, -1);
            Arrays.fill(this.lastTotalMeasureIndex, -1);
            int totalMeasureCount = this.crosstabItem.getMeasureCount();
            this.lastMeasureIndex = totalMeasureCount - 1;
            this.firstGrandTotalMeasureIndex = -1;
            boolean allowTotal = totalMeasureCount > 0;
            int i = 0;
            while (i < columnGroups.size()) {
                EdgeGroup eg = columnGroups.get(i);
                LevelViewHandle lv = this.crosstabItem.getDimension(1, eg.dimensionIndex).getLevel(eg.levelIndex);
                String pageBreak = lv.getPageBreakBefore();
                this.pageBreakBeforeInts[i] = "always".equals(pageBreak) ? 1 : ("always-excluding-first".equals(pageBreak) ? 2 : 0);
                pageBreak = lv.getPageBreakAfter();
                int n = "always".equals(pageBreak) ? 1 : (this.pageBreakAfterInts[i] = "always-excluding-last".equals(pageBreak) ? 2 : 0);
                if (allowTotal && i != columnGroups.size() - 1 && lv.getAggregationHeader() != null) {
                    if ("before".equals(lv.getAggregationHeaderLocation())) {
                        this.hasTotalBefore[i] = true;
                    } else if ("after".equals(lv.getAggregationHeaderLocation())) {
                        this.hasTotalAfter[i] = true;
                    }
                    List mvs2 = lv.getAggregationMeasures();
                    if (mvs2.size() > 0) {
                        this.firstTotalMeasureIndex[i] = ((MeasureViewHandle)mvs2.get(0)).getIndex();
                        this.lastTotalMeasureIndex[i] = ((MeasureViewHandle)mvs2.get(mvs2.size() - 1)).getIndex();
                    }
                }
                ++i;
            }
            if (allowTotal && this.crosstabItem.getGrandTotal(1) != null && (mvs = this.crosstabItem.getAggregationMeasures(1)).size() > 0) {
                this.firstGrandTotalMeasureIndex = ((MeasureViewHandle)mvs.get(0)).getIndex();
            }
        }
        if ((rdCount = this.crosstabItem.getDimensionCount(0)) > 0 && (dv = this.crosstabItem.getDimension(0, rdCount - 1)).getLevelCount() > 0) {
            LevelViewHandle lv = dv.getLevel(dv.getLevelCount() - 1);
            this.rowDimension = dv.getCubeDimensionName();
            this.rowLevel = lv.getCubeLevelName();
        }
    }

    void generateColumns(IReportContent report, ITableContent table) throws OLAPException {
        while (this.walker.hasNext()) {
            ColumnEvent ce = this.walker.next();
            this.addColumn(ce, report, table);
            logger.log(Level.INFO, ce.toString());
        }
        this.handlePageBreak(table);
    }

    private String getDisplay(CrosstabCellHandle cell) {
        Object value = cell.getProperty("display");
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private void addColumn(ColumnEvent event, IReportContent report, ITableContent table) {
        String display;
        Column col = new Column(report);
        CrosstabCellHandle cell = null;
        block1 : switch (event.type) {
            case 1: {
                col.setColumnHeaderState(true);
                col.setRepeated(this.repeatRowHeader);
                if (event.dimensionIndex == -1 && event.levelIndex == -1) {
                    cell = this.crosstabItem.getHeader();
                    break;
                }
                cell = this.crosstabItem.getDimension(0, event.dimensionIndex).getLevel(event.levelIndex).getCell();
                break;
            }
            case 5: {
                col.setColumnHeaderState(true);
                col.setRepeated(this.repeatRowHeader);
                int totalMeasureCount = this.crosstabItem.getMeasureCount();
                int i = 0;
                while (i < totalMeasureCount) {
                    MeasureViewHandle mv = this.crosstabItem.getMeasure(i);
                    if (mv.getHeader() != null) {
                        cell = mv.getHeader();
                        break block1;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                if (this.crosstabItem.getMeasureCount() > 0) {
                    int mx = event.measureIndex >= 0 ? event.measureIndex : 0;
                    cell = this.crosstabItem.getMeasure(mx).getCell();
                    break;
                }
                DimensionViewHandle dv = this.crosstabItem.getDimension(1, this.crosstabItem.getDimensionCount(1) - 1);
                cell = dv.getLevel(dv.getLevelCount() - 1).getCell();
                break;
            }
            case 3: {
                if (this.crosstabItem.getMeasureCount() > 0) {
                    int mx = event.measureIndex >= 0 ? event.measureIndex : 0;
                    DimensionViewHandle dv = this.crosstabItem.getDimension(1, event.dimensionIndex);
                    LevelViewHandle lv = dv.getLevel(event.levelIndex);
                    cell = this.crosstabItem.getMeasure(mx).getAggregationCell(this.rowDimension, this.rowLevel, dv.getCubeDimensionName(), lv.getCubeLevelName());
                    break;
                }
                DimensionViewHandle dv = this.crosstabItem.getDimension(1, event.dimensionIndex);
                cell = dv.getLevel(event.levelIndex).getAggregationHeader();
                break;
            }
            case 4: {
                if (this.crosstabItem.getMeasureCount() > 0) {
                    int mx = event.measureIndex >= 0 ? event.measureIndex : 0;
                    cell = this.crosstabItem.getMeasure(mx).getAggregationCell(this.rowDimension, this.rowLevel, null, null);
                    break;
                }
                cell = this.crosstabItem.getGrandTotal(1);
                break;
            }
            case 6: {
                int mx = event.measureIndex >= 0 ? event.measureIndex : 0;
                cell = this.crosstabItem.getMeasure(mx).getCell();
            }
        }
        try {
            DimensionType width;
            DimensionHandle handle = this.crosstabItem.getColumnWidth(cell);
            if (handle != null && (width = ContentUtil.createDimension(handle)) != null) {
                col.setWidth(width);
            }
        }
        catch (CrosstabException e) {
            logger.log(Level.SEVERE, Messages.getString("TableColumnGenerator.error.process.column.width"), e);
        }
        if ("none".equals(display = this.getDisplay(cell))) {
            col.getStyle().setDisplay("none");
        }
        table.addColumn(col);
    }

    private void handlePageBreak(ITableContent table) throws OLAPException {
        if (this.columnCursor == null || this.columnGroups.size() == 0) {
            return;
        }
        this.walker.reload();
        int i = 0;
        int[] checkPoint = new int[]{-1};
        this.notifyNextPageBreak = -1;
        while (this.walker.hasNext()) {
            ColumnEvent ce = this.walker.next();
            if (ce.type == 2 || ce.type == 3 || ce.type == 4) {
                IColumn col = table.getColumn(i);
                this.handleColumnPageBreak(ce, col);
                if (this.forcedColumnLevelPageBreakInterval > 0) {
                    this.handleForcedColumnPageBreak(checkPoint, i, col);
                }
            }
            ++i;
        }
    }

    private void handleForcedColumnPageBreak(int[] checkPoint, int position, IColumn col) {
        if (checkPoint[0] == -1) {
            checkPoint[0] = position;
        } else if (position - checkPoint[0] >= this.forcedColumnLevelPageBreakInterval) {
            col.getStyle().setProperty(30, IStyle.ALWAYS_VALUE);
            checkPoint[0] = position;
        }
    }

    private void handleColumnPageBreak(ColumnEvent event, IColumn col) throws OLAPException {
        this.columnCursor.setPosition(event.dataPosition);
        if (event.type == 3) {
            int currentGroupIndex = GroupUtil.getGroupIndex(this.columnGroups, event.dimensionIndex, event.levelIndex);
            if (event.isLocationBefore) {
                if (event.measureIndex == -1 || event.measureIndex == this.firstTotalMeasureIndex[currentGroupIndex]) {
                    boolean isFirst = this.groupCursors.get(currentGroupIndex).isFirst();
                    if (this.pageBreakBeforeInts[currentGroupIndex] == 1 || this.pageBreakBeforeInts[currentGroupIndex] == 2 && !isFirst) {
                        col.getStyle().setProperty(30, IStyle.ALWAYS_VALUE);
                    }
                    if (this.notifyNextPageBreak != -1) {
                        this.notifyNextPageBreak = -1;
                        col.getStyle().setProperty(30, IStyle.ALWAYS_VALUE);
                    }
                }
            } else if (event.measureIndex == -1 || event.measureIndex == this.lastTotalMeasureIndex[currentGroupIndex]) {
                boolean isLast;
                if (this.pageBreakAfterInts[currentGroupIndex] == 1) {
                    col.getStyle().setProperty(67, IStyle.ALWAYS_VALUE);
                } else if (this.pageBreakAfterInts[currentGroupIndex] == 2 && !(isLast = this.groupCursors.get(currentGroupIndex).isLast())) {
                    this.notifyNextPageBreak = currentGroupIndex;
                }
            }
            if (this.columnLevelPageBreakIntervals != null) {
                this.processLevelPageBreakIntervals(col);
            }
        } else if (event.type == 2) {
            int i;
            if (event.measureIndex == -1 || event.measureIndex == 0) {
                int startBound;
                int startingGrouplevel = GroupUtil.getStartingGroupLevel(this.columnCursor, this.groupCursors);
                i = startBound = startingGrouplevel == 0 ? 0 : startingGrouplevel - 1;
                while (i < this.pageBreakBeforeInts.length) {
                    if (!this.hasTotalBefore[i]) {
                        boolean isFirst;
                        if (this.pageBreakBeforeInts[i] == 1) {
                            col.getStyle().setProperty(30, IStyle.ALWAYS_VALUE);
                            break;
                        }
                        if (this.pageBreakBeforeInts[i] == 2 && !(isFirst = this.groupCursors.get(i).isFirst())) {
                            col.getStyle().setProperty(30, IStyle.ALWAYS_VALUE);
                            break;
                        }
                    }
                    ++i;
                }
                if (this.notifyNextPageBreak != -1 && startingGrouplevel <= this.notifyNextPageBreak + 1) {
                    this.notifyNextPageBreak = -1;
                    col.getStyle().setProperty(30, IStyle.ALWAYS_VALUE);
                }
            }
            if (event.measureIndex == -1 || event.measureIndex == this.lastMeasureIndex) {
                int endBound;
                int endingGroupLevel = GroupUtil.getEndingGroupLevel(this.columnCursor, this.groupCursors);
                i = endBound = endingGroupLevel == 0 ? 0 : endingGroupLevel - 1;
                while (i < this.pageBreakAfterInts.length) {
                    if (!this.hasTotalAfter[i]) {
                        boolean isLast;
                        if (this.pageBreakAfterInts[i] == 1) {
                            col.getStyle().setProperty(67, IStyle.ALWAYS_VALUE);
                        } else if (this.pageBreakAfterInts[i] == 2 && !(isLast = this.groupCursors.get(i).isLast())) {
                            this.notifyNextPageBreak = i;
                        }
                    }
                    ++i;
                }
            }
            if (this.columnLevelPageBreakIntervals != null) {
                this.processLevelPageBreakIntervals(col);
            }
        } else if (event.type == 4 && (event.measureIndex == -1 || event.measureIndex == this.firstGrandTotalMeasureIndex) && this.notifyNextPageBreak != -1) {
            this.notifyNextPageBreak = -1;
            col.getStyle().setProperty(30, IStyle.ALWAYS_VALUE);
        }
    }

    private void processLevelPageBreakIntervals(IColumn col) throws OLAPException {
        if (this.lastColumnLevelState == null) {
            this.lastColumnLevelState = GroupUtil.getLevelCursorState(this.columnCursor);
            this.checkedColumnLevelState = GroupUtil.getLevelCursorState(this.columnCursor);
            return;
        }
        long[] currentColumnLevelState = GroupUtil.getLevelCursorState(this.columnCursor);
        int i = 0;
        while (i < this.columnLevelPageBreakIntervals.length) {
            long currentPos = currentColumnLevelState[i];
            long lastPos = this.lastColumnLevelState[i];
            if (currentPos != lastPos) {
                long lastCheckedPos;
                if (this.columnLevelPageBreakIntervals[i] > 0 && currentPos - (lastCheckedPos = this.checkedColumnLevelState[i]) >= (long)this.columnLevelPageBreakIntervals[i]) {
                    col.getStyle().setProperty(30, IStyle.ALWAYS_VALUE);
                    System.arraycopy(currentColumnLevelState, 0, this.checkedColumnLevelState, 0, currentColumnLevelState.length);
                }
                int j = i + 1;
                while (j < this.columnLevelPageBreakIntervals.length) {
                    this.checkedColumnLevelState[j] = 0L;
                    ++j;
                }
            }
            ++i;
        }
        this.lastColumnLevelState = currentColumnLevelState;
    }
}

