/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.transaction.TransactionControl;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.NewInvocationNode;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.vti.DeferModification;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.Restriction;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;

class FromVTI
extends FromTable
implements VTIEnvironment {
    JBitSet correlationMap;
    JBitSet dependencyMap;
    MethodCallNode methodCall;
    TableName exposedName;
    SubqueryList subqueryList;
    boolean implementsVTICosting;
    boolean optimized;
    boolean materializable;
    boolean isTarget;
    boolean isDerbyStyleTableFunction;
    boolean isRestrictedTableFunction;
    ResultSet rs;
    private final FormatableHashtable compileTimeConstants = new FormatableHashtable();
    protected int numVTICols;
    private PredicateList restrictionList;
    double estimatedCost = 100000.0;
    double estimatedRowCount = 10000.0;
    boolean supportsMultipleInstantiations = true;
    boolean vtiCosted;
    protected boolean version2;
    private boolean implementsPushable;
    private PreparedStatement ps;
    private JavaValueNode[] methodParms;
    private boolean controlsDeferral;
    private int resultSetType = 1003;
    private String[] projectedColumnNames;
    private Restriction vtiRestriction;
    private ArrayList<FromList> outerFromLists = new ArrayList();
    private HashMap<Integer, FromTable> argSources = new HashMap();

    FromVTI(MethodCallNode invocation, String correlationName, ResultColumnList derivedRCL, Properties tableProperties, ContextManager cm) throws StandardException {
        super(correlationName, tableProperties, cm);
        this.constructorMinion(invocation, derivedRCL, this.makeTableName(null, correlationName));
    }

    FromVTI(MethodCallNode invocation, String correlationName, ResultColumnList derivedRCL, Properties tableProperties, TableName exposedTableName, ContextManager cm) {
        super(correlationName, tableProperties, cm);
        this.constructorMinion(invocation, derivedRCL, exposedTableName);
    }

    private void constructorMinion(MethodCallNode invocation, ResultColumnList derivedRCL, TableName exposedTableName) {
        this.methodCall = invocation;
        this.setResultColumns(derivedRCL);
        this.subqueryList = new SubqueryList(this.getContextManager());
        this.exposedName = exposedTableName;
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        this.setCostEstimate(this.getCostEstimate(optimizer));
        if (this.implementsVTICosting && !this.vtiCosted) {
            try {
                VTICosting vtic = this.getVTICosting();
                this.estimatedCost = vtic.getEstimatedCostPerInstantiation(this);
                this.estimatedRowCount = vtic.getEstimatedRowCount(this);
                this.supportsMultipleInstantiations = vtic.supportsMultipleInstantiations(this);
                if (this.ps != null) {
                    this.ps.close();
                    this.ps = null;
                }
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
            }
            catch (SQLException sqle) {
                throw StandardException.unexpectedUserException(sqle);
            }
            this.vtiCosted = true;
        }
        this.getCostEstimate().setCost(this.estimatedCost, this.estimatedRowCount, this.estimatedRowCount);
        if (this.getCurrentAccessPath().getJoinStrategy().multiplyBaseCostByOuterRows()) {
            this.getCostEstimate().multiply(outerCost.rowCount(), this.getCostEstimate());
        }
        if (!this.optimized) {
            this.subqueryList.optimize(optimizer.getDataDictionary(), this.getCostEstimate().rowCount());
            this.subqueryList.modifyAccessPaths();
        }
        this.optimized = true;
        return this.getCostEstimate();
    }

    @Override
    public boolean legalJoinOrder(JBitSet assignedTableMap) {
        JBitSet tempBitSet = assignedTableMap;
        tempBitSet.or(this.correlationMap);
        return tempBitSet.contains(this.dependencyMap);
    }

    @Override
    public boolean isMaterializable() {
        return this.materializable;
    }

    @Override
    public boolean supportsMultipleInstantiations() {
        return this.supportsMultipleInstantiations;
    }

    public boolean isDerbyStyleTableFunction() {
        return this.isDerbyStyleTableFunction;
    }

    @Override
    void adjustForSortElimination() {
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        if (this.rs != null) {
            try {
                this.rs.close();
                this.rs = null;
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
        }
        return super.modifyAccessPath(outerTables);
    }

    public void addOuterFromList(FromList fromList) {
        this.outerFromLists.add(fromList);
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        if (!this.implementsPushable) {
            return false;
        }
        if (!optimizablePredicate.getReferencedMap().hasSingleBitSet()) {
            return false;
        }
        if (this.restrictionList == null) {
            this.restrictionList = new PredicateList(this.getContextManager());
        }
        this.restrictionList.addPredicate((Predicate)optimizablePredicate);
        return true;
    }

    @Override
    public String toString() {
        return "materializable: " + this.materializable + "\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.methodCall != null) {
            this.printLabel(depth, "methodCall: ");
            this.methodCall.treePrint(depth + 1);
        }
        if (this.exposedName != null) {
            this.printLabel(depth, "exposedName: ");
            this.exposedName.treePrint(depth + 1);
        }
        if (this.subqueryList != null) {
            this.printLabel(depth, "subqueryList: ");
            this.subqueryList.treePrint(depth + 1);
        }
    }

    boolean isConstructor() {
        return this.methodCall instanceof NewInvocationNode;
    }

    final MethodCallNode getMethodCall() {
        return this.methodCall;
    }

    @Override
    String getExposedName() {
        return this.correlationName;
    }

    public TableName getExposedTableName() {
        return this.exposedName;
    }

    void setTarget() {
        this.isTarget = true;
        this.version2 = true;
    }

    @Override
    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    String getVTIName() {
        return this.methodCall.getJavaClassName();
    }

    @Override
    ResultSetNode bindVTITables(FromList fromListParam) throws StandardException {
        UUID triggerTableId;
        ResultColumnList derivedRCL = this.getResultColumns();
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        ArrayList<AggregateNode> aggregates = new ArrayList<AggregateNode>();
        this.methodCall.bindExpression(fromListParam, this.subqueryList, aggregates);
        this.methodParms = this.methodCall.getMethodParms();
        RoutineAliasInfo routineInfo = this.methodCall.getRoutineInfo();
        if (routineInfo != null && routineInfo.getReturnType().isRowMultiSet() && routineInfo.getParameterStyle() == 1) {
            this.isDerbyStyleTableFunction = true;
        }
        if (this.isDerbyStyleTableFunction) {
            Method boundMethod = (Method)this.methodCall.getResolvedMethod();
            this.isRestrictedTableFunction = RestrictedVTI.class.isAssignableFrom(boundMethod.getReturnType());
        }
        if (this.isConstructor()) {
            NewInvocationNode constructor = (NewInvocationNode)this.methodCall;
            if (!constructor.assignableTo("java.sql.PreparedStatement")) {
                if (this.version2) {
                    throw StandardException.newException("42X08", this.getVTIName(), "java.sql.PreparedStatement");
                }
                if (!constructor.assignableTo("java.sql.ResultSet")) {
                    throw StandardException.newException("42X08", this.getVTIName(), "java.sql.ResultSet");
                }
            } else {
                this.version2 = true;
            }
            if (this.version2) {
                this.implementsPushable = constructor.assignableTo("org.apache.derby.vti.IQualifyable");
            }
            this.implementsVTICosting = constructor.assignableTo("org.apache.derby.vti.VTICosting");
        }
        if (this.isDerbyStyleTableFunction) {
            this.implementsVTICosting = this.implementsDerbyStyleVTICosting(this.methodCall.getJavaClassName());
        }
        if (this.isConstructor() && (triggerTableId = this.getSpecialTriggerVTITableName(lcc, this.methodCall.getJavaClassName())) != null) {
            TableDescriptor td = this.getDataDictionary().getTableDescriptor(triggerTableId);
            this.setResultColumns(this.genResultColList(td));
            this.vtiCosted = true;
            this.estimatedCost = 50.0;
            this.estimatedRowCount = 5.0;
            this.supportsMultipleInstantiations = true;
        } else {
            this.setResultColumns(new ResultColumnList(this.getContextManager()));
            if (this.isDerbyStyleTableFunction) {
                this.createResultColumnsForTableFunction(routineInfo.getReturnType());
            } else {
                ResultSetMetaData rsmd = this.getResultSetMetaData();
                if (rsmd == null) {
                    throw StandardException.newException("42X43", this.getVTIName());
                }
                try {
                    this.numVTICols = rsmd.getColumnCount();
                }
                catch (SQLException sqle) {
                    this.numVTICols = 0;
                }
                this.getResultColumns().createListFromResultSetMetaData(rsmd, this.exposedName, this.getVTIName());
            }
        }
        this.numVTICols = this.getResultColumns().size();
        if (derivedRCL != null) {
            this.getResultColumns().propagateDCLInfo(derivedRCL, this.correlationName);
        }
        return this;
    }

    ResultSetMetaData getResultSetMetaData() throws StandardException {
        ResultSetMetaData rsmd;
        block10: {
            rsmd = null;
            try {
                if (this.version2) {
                    this.ps = (PreparedStatement)this.getNewInstance();
                    if (this.ps.getResultSetConcurrency() != 1008) {
                        throw StandardException.newException("42Z90", this.getVTIName());
                    }
                    rsmd = this.ps.getMetaData();
                    this.controlsDeferral = this.ps instanceof DeferModification;
                    try {
                        this.resultSetType = this.ps.getResultSetType();
                    }
                    catch (SQLException sQLException) {
                    }
                    catch (AbstractMethodError abstractMethodError) {
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    if (!this.implementsVTICosting) {
                        this.ps.close();
                        this.ps = null;
                    }
                    break block10;
                }
                this.rs = (ResultSet)this.getNewInstance();
                rsmd = this.rs.getMetaData();
                if (!this.implementsVTICosting) {
                    this.rs.close();
                    this.rs = null;
                }
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
        }
        return rsmd;
    }

    private Object getNewInstance() throws StandardException {
        Object[] paramObjects;
        NewInvocationNode constructor = (NewInvocationNode)this.methodCall;
        Class<?>[] paramTypeClasses = constructor.getMethodParameterClasses();
        if (paramTypeClasses != null) {
            paramObjects = new Object[paramTypeClasses.length];
            for (int index = 0; index < paramTypeClasses.length; ++index) {
                Class<?> paramClass = paramTypeClasses[index];
                paramObjects[index] = this.methodParms[index].getConstantValueAsObject();
                if (paramObjects[index] != null && paramClass.isPrimitive()) {
                    if (paramClass.equals(Short.TYPE)) {
                        paramObjects[index] = ((Integer)paramObjects[index]).shortValue();
                    } else if (paramClass.equals(Byte.TYPE)) {
                        paramObjects[index] = ((Integer)paramObjects[index]).byteValue();
                    }
                }
                if (paramObjects[index] != null || !paramClass.isPrimitive()) continue;
                if (paramClass.equals(Integer.TYPE)) {
                    paramObjects[index] = 0;
                    continue;
                }
                if (paramClass.equals(Short.TYPE)) {
                    paramObjects[index] = (short)0;
                    continue;
                }
                if (paramClass.equals(Byte.TYPE)) {
                    paramObjects[index] = (byte)0;
                    continue;
                }
                if (paramClass.equals(Long.TYPE)) {
                    paramObjects[index] = 0L;
                    continue;
                }
                if (paramClass.equals(Float.TYPE)) {
                    paramObjects[index] = Float.valueOf(0.0f);
                    continue;
                }
                if (paramClass.equals(Double.TYPE)) {
                    paramObjects[index] = 0.0;
                    continue;
                }
                if (paramClass.equals(Boolean.TYPE)) {
                    paramObjects[index] = Boolean.FALSE;
                    continue;
                }
                if (!paramClass.equals(Character.TYPE)) continue;
                paramObjects[index] = Character.valueOf('\u0000');
            }
        } else {
            paramTypeClasses = new Class[]{};
            paramObjects = new Object[]{};
        }
        try {
            ClassInspector classInspector = this.getClassFactory().getClassInspector();
            String javaClassName = this.methodCall.getJavaClassName();
            Constructor<?> constr = classInspector.getClass(javaClassName).getConstructor(paramTypeClasses);
            return constr.newInstance(paramObjects);
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
    }

    public DeferModification getDeferralControl() throws StandardException {
        if (!this.controlsDeferral) {
            return null;
        }
        try {
            return (DeferModification)this.getNewInstance();
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    void bindExpressions(FromList fromListParam) throws StandardException {
        this.materializable = this.methodCall.areParametersQueryInvariant();
        ArrayList aggregates = null;
        for (ColumnReference ref : this.getNodesFromParameters(ColumnReference.class)) {
            boolean illegalReference;
            boolean bl = illegalReference = !ref.getCorrelated();
            if (ref.getCorrelated()) {
                for (int i = 0; i < this.outerFromLists.size(); ++i) {
                    FromTable fromTable = this.columnInFromList(this.outerFromLists.get(i), ref);
                    if (fromTable == null) continue;
                    illegalReference = true;
                    break;
                }
            } else {
                FromTable fromTable = this.columnInFromList(fromListParam, ref);
                if (fromTable != null && !this.isDerbyStyleTableFunction && !(fromTable instanceof FromVTI)) break;
            }
            if (illegalReference) {
                throw StandardException.newException("42ZB7", ref.getSQLColumnName());
            }
            if (ref.getTableNumber() != -1) continue;
            if (aggregates == null) {
                aggregates = new ArrayList();
            }
            ref.bindExpression(fromListParam, this.subqueryList, (List)aggregates);
        }
    }

    private FromTable columnInFromList(FromList fromList, ColumnReference ref) throws StandardException {
        int referencedTableNumber = ref.getTableNumber();
        for (int i = 0; i < fromList.size(); ++i) {
            FromTable fromTable = (FromTable)fromList.elementAt(i);
            if (referencedTableNumber != fromTable.getTableNumber()) continue;
            this.argSources.put(fromTable.getTableNumber(), fromTable);
            return fromTable;
        }
        return null;
    }

    <T extends Visitable> List<T> getNodesFromParameters(Class<T> nodeClass) throws StandardException {
        CollectNodesVisitor<T> getCRs = new CollectNodesVisitor<T>(nodeClass);
        this.methodCall.accept(getCRs);
        return getCRs.getList();
    }

    @Override
    ResultColumnList getAllResultColumns(TableName allTableName) throws StandardException {
        TableName toCompare = allTableName != null ? this.makeTableName(allTableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName);
        if (allTableName != null && !allTableName.equals(toCompare)) {
            return null;
        }
        ContextManager cm = this.getContextManager();
        ResultColumnList rcList = new ResultColumnList(cm);
        for (ResultColumn rc : this.getResultColumns()) {
            if (rc.isGenerated()) continue;
            ResultColumn newRc = new ResultColumn(rc.getName(), (ValueNode)new ColumnReference(rc.getName(), this.exposedName, cm), cm);
            rcList.addResultColumn(newRc);
        }
        return rcList;
    }

    @Override
    ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        if (this.getResultColumns() == null) {
            return null;
        }
        ResultColumn resultColumn = null;
        TableName columnsTableName = columnReference.getQualifiedTableName();
        if ((columnsTableName == null || columnsTableName.equals(this.exposedName)) && (resultColumn = this.getResultColumns().getResultColumn(columnReference.getColumnName())) != null) {
            columnReference.setTableNumber(this.tableNumber);
            columnReference.setColumnNumber(resultColumn.getColumnPosition());
        }
        return resultColumn;
    }

    @Override
    ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.methodCall.preprocess(numTables, new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()), new SubqueryList(this.getContextManager()), new PredicateList(this.getContextManager()));
        this.setReferencedTableMap(new JBitSet(numTables));
        this.getReferencedTableMap().set(this.tableNumber);
        this.dependencyMap = new JBitSet(numTables);
        this.methodCall.categorize(this.dependencyMap, false);
        this.dependencyMap.clear(this.tableNumber);
        this.correlationMap = new JBitSet(numTables);
        this.methodCall.getCorrelationTables(this.correlationMap);
        return this.genProjectRestrict(numTables);
    }

    @Override
    protected ResultSetNode genProjectRestrict(int numTables) throws StandardException {
        ResultColumnList prRCList = this.getResultColumns();
        this.setResultColumns(this.getResultColumns().copyListAndObjects());
        prRCList.genVirtualColumnNodes(this, this.getResultColumns(), false);
        prRCList.doProjection();
        return new ProjectRestrictNode(this, prRCList, null, null, null, null, this.tableProperties, this.getContextManager());
    }

    @Override
    boolean performMaterialization(JBitSet outerTables) throws StandardException {
        return outerTables.getFirstSetBit() != -1 && !outerTables.hasSingleBitSet() && !this.getTrulyTheBestAccessPath().getJoinStrategy().doesMaterialization() && this.isMaterializable() && !this.supportsMultipleInstantiations;
    }

    void computeProjectionAndRestriction(PredicateList parentPredicates) throws StandardException {
        if (!this.isRestrictedTableFunction) {
            return;
        }
        this.computeRestriction(parentPredicates, this.computeProjection());
    }

    private HashMap<String, String> computeProjection() throws StandardException {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        ResultColumnList allVTIColumns = this.getResultColumns();
        int totalColumnCount = allVTIColumns.size();
        this.projectedColumnNames = new String[totalColumnCount];
        for (int i = 0; i < totalColumnCount; ++i) {
            String baseName;
            ResultColumn column = allVTIColumns.getResultColumn(i + 1);
            String exposedNam = column.getName();
            if (!column.isReferenced()) continue;
            this.projectedColumnNames[i] = baseName = column.getBaseColumnNode().getColumnName();
            nameMap.put(exposedNam, baseName);
        }
        return nameMap;
    }

    private void computeRestriction(PredicateList parentPredicates, HashMap<String, String> columnNameMap) throws StandardException {
        if (parentPredicates == null) {
            return;
        }
        for (Predicate pp : parentPredicates) {
            if (!this.canBePushedDown(pp)) continue;
            Restriction newRestriction = this.makeRestriction(pp.getAndNode(), columnNameMap);
            if (newRestriction == null) {
                this.vtiRestriction = null;
                return;
            }
            if (this.vtiRestriction == null) {
                this.vtiRestriction = newRestriction;
                continue;
            }
            this.vtiRestriction = new Restriction.AND(this.vtiRestriction, newRestriction);
        }
    }

    private boolean canBePushedDown(Predicate predicate) throws StandardException {
        JBitSet referencedSet = predicate.getReferencedSet();
        return predicate.isQualifier() && referencedSet != null && referencedSet.hasSingleBitSet() && referencedSet.get(this.getTableNumber());
    }

    private Restriction makeRestriction(ValueNode clause, HashMap<String, String> columnNameMap) throws StandardException {
        if (clause instanceof AndNode) {
            AndNode andOperator = (AndNode)clause;
            if (andOperator.getRightOperand().isBooleanTrue()) {
                return this.makeRestriction(andOperator.getLeftOperand(), columnNameMap);
            }
            Restriction leftRestriction = this.makeRestriction(andOperator.getLeftOperand(), columnNameMap);
            Restriction rightRestriction = this.makeRestriction(andOperator.getRightOperand(), columnNameMap);
            if (leftRestriction == null || rightRestriction == null) {
                return null;
            }
            return new Restriction.AND(leftRestriction, rightRestriction);
        }
        if (clause instanceof OrNode) {
            OrNode orOperator = (OrNode)clause;
            if (orOperator.getRightOperand().isBooleanFalse()) {
                return this.makeRestriction(orOperator.getLeftOperand(), columnNameMap);
            }
            Restriction leftRestriction = this.makeRestriction(orOperator.getLeftOperand(), columnNameMap);
            Restriction rightRestriction = this.makeRestriction(orOperator.getRightOperand(), columnNameMap);
            if (leftRestriction == null || rightRestriction == null) {
                return null;
            }
            return new Restriction.OR(leftRestriction, rightRestriction);
        }
        if (clause instanceof BinaryRelationalOperatorNode) {
            return this.makeLeafRestriction((BinaryRelationalOperatorNode)clause, columnNameMap);
        }
        if (clause instanceof IsNullNode) {
            return this.makeIsNullRestriction((IsNullNode)clause, columnNameMap);
        }
        return this.iAmConfused(clause);
    }

    private Restriction makeLeafRestriction(BinaryRelationalOperatorNode clause, HashMap<String, String> columnNameMap) throws StandardException {
        ValueNode rawValue;
        ColumnReference rawColumn;
        int rawOperator = clause.getOperator();
        if (clause.getLeftOperand() instanceof ColumnReference) {
            rawColumn = (ColumnReference)clause.getLeftOperand();
            rawValue = clause.getRightOperand();
        } else if (clause.getRightOperand() instanceof ColumnReference) {
            rawColumn = (ColumnReference)clause.getRightOperand();
            rawValue = clause.getLeftOperand();
            rawOperator = this.flipOperator(rawOperator);
        } else {
            return this.iAmConfused(clause);
        }
        int comparisonOperator = this.mapOperator(rawOperator);
        if (comparisonOperator < 0) {
            return this.iAmConfused(clause);
        }
        String columnName = columnNameMap.get(rawColumn.getColumnName());
        Object constantOperand = this.squeezeConstantValue(rawValue);
        if (columnName == null || constantOperand == null) {
            return this.iAmConfused(clause);
        }
        return new Restriction.ColumnQualifier(columnName, comparisonOperator, constantOperand);
    }

    private Restriction makeIsNullRestriction(IsNullNode clause, HashMap<String, String> columnNameMap) throws StandardException {
        ColumnReference rawColumn = (ColumnReference)clause.getOperand();
        int comparisonOperator = this.mapOperator(clause.getOperator());
        if (comparisonOperator < 0) {
            return this.iAmConfused(clause);
        }
        if (comparisonOperator != 5 && comparisonOperator != 6) {
            return this.iAmConfused(clause);
        }
        String columnName = columnNameMap.get(rawColumn.getColumnName());
        if (columnName == null) {
            return this.iAmConfused(clause);
        }
        return new Restriction.ColumnQualifier(columnName, comparisonOperator, null);
    }

    private Restriction iAmConfused(ValueNode clause) throws StandardException {
        return null;
    }

    private int flipOperator(int rawOperator) throws StandardException {
        switch (rawOperator) {
            case 1: {
                return 1;
            }
            case 4: {
                return 6;
            }
            case 3: {
                return 5;
            }
            case 6: {
                return 4;
            }
            case 5: {
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        SanityManager.THROWASSERT("Unrecognized relational operator: " + rawOperator);
        return -1;
    }

    private int mapOperator(int rawOperator) throws StandardException {
        switch (rawOperator) {
            case 1: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 6: {
                return 2;
            }
            case 5: {
                return 0;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 6;
            }
            case 2: {
                return 7;
            }
        }
        SanityManager.THROWASSERT("Unrecognized relational operator: " + rawOperator);
        return -1;
    }

    private Object squeezeConstantValue(ValueNode valueNode) throws StandardException {
        if (valueNode instanceof ParameterNode) {
            return new int[]{((ParameterNode)valueNode).getParameterNumber()};
        }
        if (valueNode instanceof ConstantNode) {
            return ((ConstantNode)valueNode).getValue().getObject();
        }
        return this.iAmConfused(valueNode);
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.isRestrictedTableFunction && this.projectedColumnNames == null) {
            this.computeProjection();
        }
        RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
        this.methodCall.accept(rcrv);
        this.remapBaseTableColumns();
        this.assignResultSetNumber();
        acb.pushGetResultSetFactoryExpression(mb);
        int nargs = this.getScanArguments(acb, mb);
        mb.callMethod((short)185, null, "getVTIResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", nargs);
    }

    private void remapBaseTableColumns() throws StandardException {
        for (ColumnReference ref : this.getNodesFromParameters(ColumnReference.class)) {
            ResultColumn newRC;
            ResultColumnList rcl;
            FromTable fromTable = this.argSources.get(ref.getTableNumber());
            if (fromTable == null || (rcl = fromTable.getResultColumns()) == null || (newRC = rcl.getResultColumn(ref.getColumnName())) == null) continue;
            ref.setSource(newRC);
        }
    }

    private int getScanArguments(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        int rclSize = this.getResultColumns().size();
        FormatableBitSet referencedCols = new FormatableBitSet(rclSize);
        int erdNumber = -1;
        int numSet = 0;
        this.setCostEstimate(this.getFinalCostEstimate());
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)this.getResultColumns().elementAt(index);
            if (!rc.isReferenced()) continue;
            referencedCols.set(index);
            ++numSet;
        }
        if (numSet != this.numVTICols) {
            erdNumber = acb.addItem(referencedCols);
        }
        SanityManager.ASSERT(this.compileTimeConstants != null, "compileTimeConstants is null");
        int ctcNumber = acb.addItem(this.compileTimeConstants);
        acb.pushThisAsActivation(mb);
        mb.push(acb.addItem(this.getResultColumns().buildRowTemplate()));
        boolean reuseablePs = this.version2 && this.getNodesFromParameters(ParameterNode.class).isEmpty() && this.getNodesFromParameters(ColumnReference.class).isEmpty();
        mb.push(this.getResultSetNumber());
        this.generateConstructor(acb, mb, reuseablePs);
        mb.push(this.methodCall.getJavaClassName());
        if (this.restrictionList != null) {
            this.restrictionList.generateQualifiers(acb, mb, this, true);
        } else {
            mb.pushNull("org.apache.derby.iapi.store.access.Qualifier[][]");
        }
        mb.push(erdNumber);
        mb.push(this.version2);
        mb.push(reuseablePs);
        mb.push(ctcNumber);
        mb.push(this.isTarget);
        mb.push(this.getCompilerContext().getScanIsolationLevel());
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.push(this.isDerbyStyleTableFunction);
        int rtNum = -1;
        if (this.isDerbyStyleTableFunction) {
            rtNum = acb.addItem(this.methodCall.getRoutineInfo().getReturnType());
        }
        mb.push(rtNum);
        mb.push(this.storeObjectInPS(acb, this.projectedColumnNames));
        mb.push(this.storeObjectInPS(acb, this.vtiRestriction));
        TableName fullName = this.methodCall.getFullName();
        mb.push(fullName == null ? "" : fullName.getSchemaName());
        mb.push(fullName == null ? "" : fullName.getTableName());
        return 20;
    }

    private int storeObjectInPS(ActivationClassBuilder acb, Object obj) throws StandardException {
        if (obj == null) {
            return -1;
        }
        return acb.addItem(obj);
    }

    private void generateConstructor(ActivationClassBuilder acb, MethodBuilder mb, boolean reuseablePs) throws StandardException {
        LocalField psHolder;
        String vtiType = this.version2 ? "java.sql.PreparedStatement" : "java.sql.ResultSet";
        MethodBuilder userExprFun = acb.newGeneratedFun(vtiType, 1);
        userExprFun.addThrownException("java.lang.Exception");
        LocalField localField = psHolder = reuseablePs ? acb.newFieldDeclaration(2, "java.sql.PreparedStatement") : null;
        if (reuseablePs) {
            userExprFun.getField(psHolder);
            userExprFun.conditionalIfNull();
        }
        this.methodCall.generateExpression(acb, userExprFun);
        userExprFun.upCast(vtiType);
        if (reuseablePs) {
            userExprFun.putField(psHolder);
            userExprFun.startElseCode();
            userExprFun.getField(psHolder);
            userExprFun.completeConditional();
        }
        userExprFun.methodReturn();
        userExprFun.complete();
        acb.pushMethodReference(mb, userExprFun);
        if (reuseablePs) {
            MethodBuilder closeActivationMethod = acb.getCloseActivationMethod();
            closeActivationMethod.getField(psHolder);
            closeActivationMethod.conditionalIfNull();
            closeActivationMethod.push(0);
            closeActivationMethod.startElseCode();
            closeActivationMethod.getField(psHolder);
            closeActivationMethod.callMethod((short)185, "java.sql.Statement", "close", "void", 0);
            closeActivationMethod.push(0);
            closeActivationMethod.completeConditional();
            closeActivationMethod.endStatement();
        }
    }

    @Override
    boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return !baseTable && name.equals(this.methodCall.getJavaClassName());
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.methodCall != null) {
            this.methodCall = (MethodCallNode)this.methodCall.accept(v);
        }
        if (this.exposedName != null) {
            this.exposedName = (TableName)this.exposedName.accept(v);
        }
    }

    private UUID getSpecialTriggerVTITableName(LanguageConnectionContext lcc, String className) throws StandardException {
        if (className.equals("org.apache.derby.catalog.TriggerNewTransitionRows") || className.equals("org.apache.derby.catalog.TriggerOldTransitionRows")) {
            if (lcc.getTriggerTable() != null) {
                return lcc.getTriggerTable().getUUID();
            }
            if (lcc.getTriggerExecutionContext() != null) {
                return lcc.getTriggerExecutionContext().getTargetTableId();
            }
            throw StandardException.newException("42Y45", className);
        }
        return null;
    }

    private ResultColumnList genResultColList(TableDescriptor td) throws StandardException {
        ResultColumnList rcList = new ResultColumnList(this.getContextManager());
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor colDesc = cdl.elementAt(index);
            BaseColumnNode valueNode = new BaseColumnNode(colDesc.getColumnName(), this.exposedName, colDesc.getType(), this.getContextManager());
            ResultColumn resultColumn = new ResultColumn(colDesc, (ValueNode)valueNode, this.getContextManager());
            rcList.addResultColumn(resultColumn);
        }
        return rcList;
    }

    @Override
    boolean needsSpecialRCLBinding() {
        return true;
    }

    boolean isUpdatableCursor() throws StandardException {
        return true;
    }

    @Override
    public final boolean isCompileTime() {
        return true;
    }

    @Override
    public String getOriginalSQL() {
        return this.getCompilerContext().getParser().getSQLtext();
    }

    @Override
    public final int getStatementIsolationLevel() {
        return TransactionControl.jdbcIsolationLevel(this.getCompilerContext().getScanIsolationLevel());
    }

    @Override
    public void setSharedState(String key, Serializable value) {
        if (key == null) {
            return;
        }
        this.compileTimeConstants.put(key, value);
    }

    @Override
    public Object getSharedState(String key) {
        if (key == null) {
            return null;
        }
        return this.compileTimeConstants.get(key);
    }

    private void createResultColumnsForTableFunction(TypeDescriptor td) throws StandardException {
        String[] columnNames = td.getRowColumnNames();
        TypeDescriptor[] types = td.getRowTypes();
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            DataTypeDescriptor dtd = DataTypeDescriptor.getType(types[i]);
            ResultColumn rc = this.getResultColumns().addColumn(this.exposedName, columnName, dtd);
            ColumnDescriptor coldesc = new ColumnDescriptor(columnName, i + 1, dtd, (DataValueDescriptor)null, (DefaultInfo)null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            rc.setColumnDescriptor(null, coldesc);
        }
    }

    private boolean implementsDerbyStyleVTICosting(String className) throws StandardException {
        Constructor<?> constructor = null;
        Class<?> vtiClass = this.lookupClass(className);
        Class<?> vtiCostingClass = this.lookupClass(VTICosting.class.getName());
        try {
            if (!vtiCostingClass.isAssignableFrom(vtiClass)) {
                return false;
            }
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
        try {
            constructor = vtiClass.getConstructor(new Class[0]);
        }
        catch (Throwable t) {
            throw StandardException.newException("42ZB5", t, className);
        }
        if (Modifier.isPublic(constructor.getModifiers())) {
            return true;
        }
        throw StandardException.newException("42ZB5", className);
    }

    private VTICosting getVTICosting() throws StandardException {
        if (!this.isDerbyStyleTableFunction) {
            return this.version2 ? (VTICosting)((Object)this.ps) : (VTICosting)((Object)this.rs);
        }
        String className = this.methodCall.getJavaClassName();
        Class<?> vtiClass = this.lookupClass(className);
        try {
            Constructor<?> constructor = vtiClass.getConstructor(new Class[0]);
            VTICosting result = (VTICosting)constructor.newInstance(null);
            return result;
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
    }

    private Class<?> lookupClass(String className) throws StandardException {
        try {
            return this.getClassFactory().getClassInspector().getClass(className);
        }
        catch (ClassNotFoundException t) {
            throw StandardException.unexpectedUserException(t);
        }
    }
}

