/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.wpml.DiagonalLineInfo;
import org.eclipse.birt.report.engine.emitter.wpml.EmitterContext;
import org.eclipse.birt.report.engine.emitter.wpml.EmitterServices;
import org.eclipse.birt.report.engine.emitter.wpml.HyperlinkInfo;
import org.eclipse.birt.report.engine.emitter.wpml.IWordWriter;
import org.eclipse.birt.report.engine.emitter.wpml.SpanInfo;
import org.eclipse.birt.report.engine.emitter.wpml.WordUtil;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.layout.emitter.Image;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManagerFactory;
import org.eclipse.birt.report.engine.layout.pdf.font.FontSplitter;
import org.eclipse.birt.report.engine.layout.pdf.text.BidiSplitter;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;
import org.eclipse.birt.report.engine.layout.pdf.text.LineBreakChunk;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;
import org.eclipse.birt.report.engine.util.FlashFile;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public abstract class AbstractEmitterImpl {
    public static final int NORMAL = -1;
    private static Set<Integer> nonInherityStyles = new HashSet<Integer>();
    private static final HashMap<String, String> genericFontMapping;
    private static Logger logger;
    protected OutputStream out = null;
    protected ContentEmitterVisitor contentVisitor;
    protected IWordWriter wordWriter = null;
    protected EmitterContext context = null;
    protected IPageContent previousPage = null;
    protected IReportContent reportContent;
    protected Stack<IStyle> styles = new Stack();
    private int pageWidth = 0;
    private int pageHeight = 0;
    protected int contentWidth = 0;
    private int headerHeight = 0;
    private int footerHeight = 0;
    private int topMargin = 0;
    private int bottomMargin = 0;
    private int leftMargin = 0;
    private int rightMargin = 0;
    private int pageTopBorderWidth = 0;
    private int pageBottomBorderWidth = 0;
    private int pageLeftBorderWidth = 0;
    private int pageRightBorderWidth = 0;
    private String orientation = "portrait";
    private HashSet<String> bookmarks = new HashSet();
    private boolean rowFilledFlag = false;
    private ArrayList<InstanceID> groupIdList = new ArrayList();
    private int tocLevel = 1;
    private List<TocInfo> tableTocs = new ArrayList<TocInfo>();
    private IReportRunnable reportRunnable;
    private IHTMLActionHandler actionHandler;
    private IReportContext reportContext;
    private String messageFlashObjectNotSupported;
    private String messageReportItemNotSupported;
    private String layoutPreference = null;
    private boolean fixedLayout;
    private ULocale locale = null;
    protected int reportDpi;
    protected boolean combineMarginPadding = false;
    protected boolean wrappedTableForMarginPadding = false;
    protected boolean wrappedTableHeaderFooter = false;
    protected boolean addEmptyParagraphToForAllCells = false;
    protected boolean addEmptyParagraphToListCell = false;
    private int wordVersion = 2010;
    protected static final String EMPTY_FOOTER = " ";
    private static final String URL_PROTOCOL_TYPE_DATA = "data:";
    private static final String URL_PROTOCOL_TYPE_FILE = "file:";
    private static final String URL_PROTOCOL_URL_ENCODED_SPACE = "%20";
    private Set<String> set = new HashSet<String>();

    static {
        nonInherityStyles.add(5);
        nonInherityStyles.add(21);
        nonInherityStyles.add(10);
        nonInherityStyles.add(23);
        nonInherityStyles.add(45);
        nonInherityStyles.add(35);
        nonInherityStyles.add(57);
        nonInherityStyles.add(65);
        nonInherityStyles.add(59);
        nonInherityStyles.add(4);
        nonInherityStyles.add(20);
        nonInherityStyles.add(9);
        nonInherityStyles.add(8);
        nonInherityStyles.add(7);
        nonInherityStyles.add(22);
        nonInherityStyles.add(11);
        nonInherityStyles.add(15);
        nonInherityStyles.add(14);
        nonInherityStyles.add(25);
        nonInherityStyles.add(18);
        genericFontMapping = new HashMap();
        genericFontMapping.put("sans-serif", "Arial");
        genericFontMapping.put("serif", "Times New Roman");
        genericFontMapping.put("monospace", "Courier New");
        genericFontMapping.put("cursive", "Comic Sans MS");
        genericFontMapping.put("fantasy", "Blackadder ITC");
        logger = Logger.getLogger(AbstractEmitterImpl.class.getName());
    }

    public void initialize(IEmitterServices service) throws EngineException {
        if (service != null) {
            this.out = EmitterUtil.getOuputStream((IEmitterServices)service, (String)("report." + this.getOutputFormat()));
            this.reportRunnable = service.getReportRunnable();
            this.actionHandler = (IHTMLActionHandler)service.getOption("actionHandler");
            this.reportContext = service.getReportContext();
            if (this.reportContext != null) {
                this.locale = ULocale.forLocale((Locale)this.reportContext.getLocale());
            }
            if (this.locale == null) {
                this.locale = ULocale.getDefault();
            }
            EngineResourceHandle resourceHandle = new EngineResourceHandle(this.locale);
            this.messageFlashObjectNotSupported = resourceHandle.getMessage("Error.FlashObjectNotSupported");
            this.messageReportItemNotSupported = resourceHandle.getMessage("Error.ReportItemNotSupported");
            IRenderOption renderOption = service.getRenderOption();
            if (renderOption != null) {
                HTMLRenderOption htmlOption = new HTMLRenderOption(renderOption);
                this.layoutPreference = htmlOption.getLayoutPreference();
            }
        }
        this.context = new EmitterContext();
    }

    public void start(IReportContent report) {
        Object dpi = report.getReportContext().getRenderOption().getOption("RenderDpi");
        int renderDpi = 0;
        if (dpi instanceof Integer) {
            renderDpi = (Integer)dpi;
        }
        this.reportDpi = PropertyUtil.getRenderDpi((IReportContent)report, (int)renderDpi);
        this.reportContent = report;
        if (this.layoutPreference == null) {
            ReportDesignHandle designHandle = report.getDesign().getReportDesign();
            if (designHandle != null) {
                String reportLayoutPreference = designHandle.getLayoutPreference();
                if ("fixed layout".equals(reportLayoutPreference)) {
                    this.layoutPreference = "fixed";
                } else if ("auto layout".equals(reportLayoutPreference)) {
                    this.layoutPreference = "auto";
                }
            }
            this.fixedLayout = "fixed".equals(this.layoutPreference);
        }
        if (EmitterServices.booleanOption(null, report, "WordEmitter.WrappedTableForMarginPadding", false)) {
            this.wrappedTableForMarginPadding = true;
        }
        if (!this.wrappedTableForMarginPadding && EmitterServices.booleanOption(null, report, "WordEmitter.CombineMarginPadding", true)) {
            this.combineMarginPadding = true;
        }
        if (EmitterServices.booleanOption(null, report, "WordEmitter.WrappedTableHeaderFooter", false)) {
            this.wrappedTableHeaderFooter = true;
            this.wordWriter.setWrappedTableHeaderFooter(this.wrappedTableHeaderFooter);
        }
        if (this.wrappedTableForMarginPadding || EmitterServices.booleanOption(null, report, "WordEmitter.AddEmptyParagraphForAllCells", false)) {
            this.addEmptyParagraphToForAllCells = true;
        }
        if (EmitterServices.booleanOption(null, report, "WordEmitter.AddEmptyParagraphForListCell", false)) {
            this.addEmptyParagraphToListCell = true;
        }
    }

    public void startPage(IPageContent page) throws IOException, BirtException {
        if (this.previousPage != null) {
            this.outputPrePageProperties();
            this.previousPage = page;
            this.context.resetWidth();
        } else {
            this.previousPage = page;
            boolean isRtl = false;
            String creator = null;
            String title = null;
            String comments = null;
            String subject = null;
            if (this.reportContent != null) {
                ReportDesignHandle designHandle = this.reportContent.getDesign().getReportDesign();
                creator = designHandle.getAuthor();
                title = this.reportContent.getTitle();
                comments = designHandle.getComments();
                subject = designHandle.getSubject();
                IContent rootContent = this.reportContent.getRoot();
                isRtl = rootContent != null && rootContent.isRTL();
            }
            this.wordWriter.start(isRtl, creator, title, comments, subject);
            this.wordWriter.setDocumentLanguage(this.locale.toLanguageTag());
            this.drawDocumentBackground();
        }
        this.computePageProperties(page);
        this.context.addWidth(this.contentWidth);
        this.wordWriter.startPage();
    }

    private void outputPrePageProperties() throws IOException, BirtException {
        this.adjustInline();
        this.writeSectionInP();
        this.wordWriter.endPage();
    }

    public void end(IReportContent report) throws IOException, BirtException {
        if (this.previousPage != null) {
            this.adjustInline();
            this.writeSectionInBody();
            this.wordWriter.endPage();
            this.wordWriter.end();
        }
    }

    public void endContainer(IContainerContent container) {
    }

    public void startContainer(IContainerContent container) {
    }

    public abstract void endTable(ITableContent var1);

    public abstract void startForeign(IForeignContent var1) throws BirtException;

    protected abstract void writeContent(int var1, String var2, IContent var3);

    public abstract String getOutputFormat();

    public void computePageProperties(IPageContent page) {
        this.pageWidth = WordUtil.convertTo(page.getPageWidth(), 11906, this.reportDpi);
        this.pageWidth = Math.min(this.pageWidth, 31680);
        this.pageHeight = WordUtil.convertTo(page.getPageHeight(), 16838, this.reportDpi);
        this.pageHeight = Math.min(this.pageHeight, 31680);
        this.footerHeight = WordUtil.convertTo(page.getFooterHeight(), 0, this.reportDpi);
        this.headerHeight = WordUtil.convertTo(page.getHeaderHeight(), 0, this.reportDpi);
        this.topMargin = WordUtil.convertTo(page.getMarginTop(), 0, this.reportDpi);
        this.bottomMargin = WordUtil.convertTo(page.getMarginBottom(), 0, this.reportDpi);
        this.leftMargin = WordUtil.convertTo(page.getMarginLeft(), 0, this.reportDpi);
        this.rightMargin = WordUtil.convertTo(page.getMarginRight(), 0, this.reportDpi);
        this.pageTopBorderWidth = WordUtil.parseBorderSize(PropertyUtil.getDimensionValue((CSSValue)page.getComputedStyle().getProperty(35)));
        this.pageBottomBorderWidth = WordUtil.parseBorderSize(PropertyUtil.getDimensionValue((CSSValue)page.getComputedStyle().getProperty(10)));
        this.pageLeftBorderWidth = WordUtil.parseBorderSize(PropertyUtil.getDimensionValue((CSSValue)page.getComputedStyle().getProperty(59)));
        this.pageRightBorderWidth = WordUtil.parseBorderSize(PropertyUtil.getDimensionValue((CSSValue)page.getComputedStyle().getProperty(9)));
        this.contentWidth = this.pageWidth - this.leftMargin - this.rightMargin - this.pageLeftBorderWidth - this.pageRightBorderWidth;
        this.orientation = page.getOrientation();
    }

    public void startAutoText(IAutoTextContent autoText) {
        this.writeContent(autoText.getType(), autoText.getText(), (IContent)autoText);
    }

    public void startData(IDataContent data) {
        this.writeContent(-1, data.getText(), (IContent)data);
    }

    public void startLabel(ILabelContent label) {
        String txt = label.getText() == null ? label.getLabelText() : label.getText();
        txt = txt == null ? "" : txt;
        this.writeContent(-1, txt, (IContent)label);
    }

    public void startText(ITextContent text) {
        this.writeContent(-1, text.getText(), (IContent)text);
    }

    public void startList(IListContent list) {
        this.adjustInline();
        this.styles.push(list.getComputedStyle());
        this.writeBookmark((IContent)list);
        Object listToc = list.getTOC();
        if (listToc != null && !this.hasTocOutputed((IContent)list)) {
            this.tableTocs.add(new TocInfo(listToc.toString(), this.tocLevel));
        }
        this.increaseTOCLevel((IContent)list);
        if (this.context.isAfterTable()) {
            this.wordWriter.insertHiddenParagraph();
            this.context.setIsAfterTable(false);
        }
        int width = WordUtil.convertTo(list.getWidth(), this.context.getCurrentWidth(), this.reportDpi);
        width = Math.min(width, this.context.getCurrentWidth());
        this.wordWriter.startTable(list.getComputedStyle(), width);
        this.context.startCell();
        this.wordWriter.startTableRow(-1.0);
        IStyle style = this.computeStyle(list.getComputedStyle());
        this.wordWriter.startTableCell(this.context.getCurrentWidth(), style, null, null);
        this.writeTableToc();
    }

    public void startListBand(IListBandContent listBand) {
    }

    public void startListGroup(IListGroupContent group) {
        this.setGroupToc((IGroupContent)group);
    }

    public void startRow(IRowContent row) {
        if (!this.isHidden((IContent)row)) {
            this.writeBookmark((IContent)row);
            this.rowFilledFlag = false;
            boolean isHeader = false;
            this.styles.push(row.getComputedStyle());
            if (row.getBand() != null && row.getBand().getBandType() == 1) {
                isHeader = true;
            }
            double height = WordUtil.convertTo(row.getHeight(), this.reportDpi);
            this.wordWriter.startTableRow(height, isHeader, row.getTable().isHeaderRepeat(), this.fixedLayout);
            this.context.newRow();
        }
    }

    public void startContent(IContent content) {
    }

    public void startGroup(IGroupContent group) {
        this.setGroupToc(group);
    }

    public void startCell(ICellContent cell) {
        this.rowFilledFlag = true;
        this.context.startCell();
        this.writeBookmark((IContent)cell);
        int columnId = cell.getColumn();
        List<SpanInfo> spans = this.context.getSpans(columnId);
        if (spans != null) {
            int i = 0;
            while (i < spans.size()) {
                this.wordWriter.writeSpanCell(spans.get(i));
                ++i;
            }
        }
        int columnSpan = cell.getColSpan();
        int rowSpan = cell.getRowSpan();
        int cellWidth = this.context.getCellWidth(columnId, columnSpan);
        IStyle cellStyle = this.computeStyle(cell.getComputedStyle());
        Boolean[] inheritedStyleFromRow = this.inheritCellStyle(cell);
        if (rowSpan > 1) {
            this.context.addSpan(columnId, columnSpan, cellWidth, rowSpan, cellStyle);
        }
        SpanInfo info = null;
        if (columnSpan > 1 || rowSpan > 1) {
            info = new SpanInfo(columnId, columnSpan, cellWidth, true, cellStyle);
        }
        DiagonalLineInfo diagonalLineInfo = this.createDiagonalLineInfo(cell, WordUtil.twipToPt(cellWidth));
        this.wordWriter.startTableCell(cellWidth, cellStyle, info, diagonalLineInfo);
        this.context.addWidth(this.getCellWidth(cellWidth, cellStyle));
        this.writeTableToc();
        this.resetInheritedStyle(cellStyle, inheritedStyleFromRow);
    }

    private void resetInheritedStyle(IStyle cellStyle, Boolean[] inheritedStyleFromRow) {
        if (inheritedStyleFromRow[0].booleanValue()) {
            cellStyle.setBorderTopStyle(null);
            cellStyle.setBorderTopColor(null);
            cellStyle.setBorderTopWidth(null);
        }
        if (inheritedStyleFromRow[1].booleanValue()) {
            cellStyle.setBorderBottomStyle(null);
            cellStyle.setBorderBottomColor(null);
            cellStyle.setBorderBottomWidth(null);
        }
        if (inheritedStyleFromRow[2].booleanValue()) {
            cellStyle.setBorderLeftStyle(null);
            cellStyle.setBorderLeftColor(null);
            cellStyle.setBorderLeftWidth(null);
        }
        if (inheritedStyleFromRow[3].booleanValue()) {
            cellStyle.setBorderRightStyle(null);
            cellStyle.setBorderRightColor(null);
            cellStyle.setBorderRightWidth(null);
        }
    }

    private Boolean[] inheritCellStyle(ICellContent cell) {
        Boolean[] inheritedStyleFromRow = new Boolean[]{false, false, false, false};
        IRowContent row = (IRowContent)cell.getParent();
        IStyle rowStyle = row.getComputedStyle();
        IStyle cellStyle = this.computeStyle(cell.getComputedStyle());
        if ("none".equals(cellStyle.getBorderTopStyle())) {
            cellStyle.setBorderTopStyle(rowStyle.getBorderTopStyle());
            cellStyle.setBorderTopWidth(rowStyle.getBorderTopWidth());
            cellStyle.setBorderTopColor(rowStyle.getBorderTopColor());
            inheritedStyleFromRow[0] = true;
        }
        if ("none".equals(cellStyle.getBorderBottomStyle())) {
            cellStyle.setBorderBottomStyle(rowStyle.getBorderBottomStyle());
            cellStyle.setBorderBottomWidth(rowStyle.getBorderBottomWidth());
            cellStyle.setBorderBottomColor(rowStyle.getBorderBottomColor());
            inheritedStyleFromRow[1] = true;
        }
        if (cell.getColumn() == 0 && "none".equals(cellStyle.getBorderLeftStyle())) {
            cellStyle.setBorderLeftStyle(rowStyle.getBorderLeftStyle());
            cellStyle.setBorderLeftWidth(rowStyle.getBorderLeftWidth());
            cellStyle.setBorderLeftColor(rowStyle.getBorderLeftColor());
            inheritedStyleFromRow[2] = true;
        }
        if (cell.isLastChild() && "none".equals(cellStyle.getBorderRightStyle())) {
            cellStyle.setBorderRightStyle(rowStyle.getBorderRightStyle());
            cellStyle.setBorderRightWidth(rowStyle.getBorderRightWidth());
            cellStyle.setBorderRightColor(rowStyle.getBorderRightColor());
            inheritedStyleFromRow[3] = true;
        }
        return inheritedStyleFromRow;
    }

    private DiagonalLineInfo createDiagonalLineInfo(ICellContent cell, double cellWidth) {
        int cellHeight = WordUtil.convertTo(this.getCellHeight(cell), 0, this.reportDpi) / 20;
        boolean diagonalSourceType = false;
        boolean antidiagonalSourceType = false;
        if (cell.getDiagonalNumber() > 0 && cell.getDiagonalStyle() != null && !"none".equalsIgnoreCase(cell.getDiagonalStyle())) {
            diagonalSourceType = true;
        }
        if (cell.getAntidiagonalNumber() > 0 && cell.getAntidiagonalStyle() != null && !"none".equalsIgnoreCase(cell.getAntidiagonalStyle())) {
            antidiagonalSourceType = true;
        }
        if (!diagonalSourceType && !antidiagonalSourceType) {
            return null;
        }
        DiagonalLineInfo diagonalLineInfo = new DiagonalLineInfo();
        int cellDiagonalNumber = 0;
        DimensionType cellDiagonalWidth = null;
        String cellDiagonalStyle = null;
        String cellDiagonalColor = null;
        if (diagonalSourceType) {
            cellDiagonalNumber = cell.getDiagonalNumber();
            cellDiagonalStyle = cell.getDiagonalStyle();
            cellDiagonalWidth = cell.getDiagonalWidth();
            cellDiagonalColor = cell.getDiagonalColor() != null ? cell.getDiagonalColor() : WordUtil.parseColor(cell.getDiagonalColor());
            diagonalLineInfo.setDiagonalColor(cellDiagonalColor);
        }
        int cellAntidiagonalNumber = 0;
        DimensionType cellAntidiagonalWidth = null;
        String cellAntidiagonalStyle = null;
        String cellAntidiagonalColor = null;
        if (antidiagonalSourceType) {
            cellAntidiagonalNumber = cell.getAntidiagonalNumber();
            cellAntidiagonalStyle = cell.getAntidiagonalStyle();
            cellAntidiagonalWidth = cell.getAntidiagonalWidth();
            cellAntidiagonalColor = cell.getAntidiagonalColor() != null ? cell.getAntidiagonalColor() : WordUtil.parseColor(cell.getAntidiagonalColor());
            diagonalLineInfo.setAntidiagonalColor(cellAntidiagonalColor);
        }
        int diagonalWidth = PropertyUtil.getDimensionValue((IContent)cell, (DimensionType)cellDiagonalWidth, (int)((int)cellWidth)) / 1000;
        diagonalLineInfo.setDiagonalLine(cellDiagonalNumber, cellDiagonalStyle, diagonalWidth);
        int antidiagonalWidth = PropertyUtil.getDimensionValue((IContent)cell, (DimensionType)cellAntidiagonalWidth, (int)((int)cellWidth)) / 1000;
        diagonalLineInfo.setAntidiagonalLine(cellAntidiagonalNumber, cellAntidiagonalStyle, antidiagonalWidth);
        diagonalLineInfo.setCoordinateSize(cellWidth, cellHeight);
        return diagonalLineInfo;
    }

    private void drawDiagonalLine(ICellContent cell, double cellWidth) {
        if (cellWidth == 0.0) {
            return;
        }
        int cellHeight = WordUtil.convertTo(this.getCellHeight(cell), 0, this.reportDpi) / 20;
        if (cellHeight == 0) {
            return;
        }
        DimensionType cellDiagonalWidth = cell.getDiagonalWidth();
        DiagonalLineInfo diagonalLineInfo = new DiagonalLineInfo();
        int diagonalWidth = PropertyUtil.getDimensionValue((IContent)cell, (DimensionType)cellDiagonalWidth, (int)((int)cellWidth)) / 1000;
        diagonalLineInfo.setDiagonalLine(cell.getDiagonalNumber(), cell.getDiagonalStyle(), diagonalWidth);
        diagonalLineInfo.setAntidiagonalLine(0, null, 0);
        diagonalLineInfo.setCoordinateSize(cellWidth, cellHeight);
        String lineColor = null;
        lineColor = cell.getDiagonalColor() != null ? WordUtil.parseColor(cell.getDiagonalColor()) : WordUtil.parseColor(cell.getComputedStyle().getColor());
        diagonalLineInfo.setColor(lineColor);
        this.wordWriter.drawDiagonalLine(diagonalLineInfo);
    }

    protected DimensionType getCellHeight(ICellContent cell) {
        IElement parent = cell.getParent();
        while (!(parent instanceof IRowContent)) {
            parent = parent.getParent();
        }
        return ((IRowContent)parent).getHeight();
    }

    public void startTable(ITableContent table) {
        this.adjustInline();
        this.styles.push(table.getComputedStyle());
        this.writeBookmark((IContent)table);
        Object tableToc = table.getTOC();
        if (tableToc != null && !this.hasTocOutputed((IContent)table)) {
            this.tableTocs.add(new TocInfo(tableToc.toString(), this.tocLevel));
        }
        this.increaseTOCLevel((IContent)table);
        String caption = table.getCaption();
        if (caption != null) {
            this.wordWriter.writeCaption(caption);
        }
        if (this.context.isAfterTable()) {
            this.wordWriter.insertHiddenParagraph();
            this.context.setIsAfterTable(false);
        }
        int width = WordUtil.convertTo(table.getWidth(), this.context.getCurrentWidth(), this.reportDpi);
        int[] cols = this.computeTblColumnWidths(table, width);
        this.wordWriter.startTable(table.getComputedStyle(), this.getTableWidth(cols));
        this.wordWriter.writeColumn(cols);
        this.context.addTable(cols, table.getComputedStyle());
    }

    private int getTableWidth(int[] cols) {
        int tableWidth = 0;
        int i = 0;
        while (i < cols.length) {
            tableWidth += cols[i];
            ++i;
        }
        return tableWidth;
    }

    public void startTableBand(ITableBandContent band) {
    }

    public void startTableGroup(ITableGroupContent group) {
        this.setGroupToc((IGroupContent)group);
    }

    private void setGroupToc(IGroupContent group) {
        if (group != null) {
            InstanceID groupId = group.getInstanceID();
            if (!this.groupIdList.contains(groupId)) {
                this.groupIdList.add(groupId);
                Object groupToc = group.getTOC();
                if (groupToc != null && !this.hasTocOutputed((IContent)group)) {
                    this.tableTocs.add(new TocInfo(groupToc.toString(), this.tocLevel));
                }
            }
            this.increaseTOCLevel((IContent)group);
        }
    }

    private void writeTableToc() {
        if (!this.tableTocs.isEmpty()) {
            for (TocInfo toc : this.tableTocs) {
                if ("".equals(toc.tocValue)) continue;
                this.wordWriter.writeTOC(toc.tocValue, toc.tocLevel);
            }
            this.tableTocs.clear();
        }
    }

    public void endCell(ICellContent cell) {
        this.adjustInline();
        this.context.removeWidth();
        if (this.addEmptyParagraphToForAllCells) {
            this.wordWriter.endTableCell(this.context.needEmptyP());
        } else {
            boolean needEmptyPara;
            boolean bl = needEmptyPara = !cell.hasChildren();
            if (needEmptyPara) {
                needEmptyPara = this.context.needEmptyP();
            }
            this.wordWriter.endTableCell(needEmptyPara, true);
        }
        this.context.endCell();
    }

    public void endContent(IContent content) {
    }

    public void endGroup(IGroupContent group) {
        this.decreaseTOCLevel((IContent)group);
    }

    public void endList(IListContent list) {
        this.adjustInline();
        boolean needEmptyP = this.addEmptyParagraphToListCell;
        if (needEmptyP) {
            needEmptyP = this.context.needEmptyP();
        }
        this.wordWriter.endTableCell(needEmptyP);
        this.context.endCell();
        this.wordWriter.endTableRow();
        if (!this.styles.isEmpty()) {
            this.styles.pop();
        }
        this.context.addContainer(true);
        this.wordWriter.endTable();
        this.context.setIsAfterTable(true);
        this.decreaseTOCLevel((IContent)list);
    }

    public void endListBand(IListBandContent listBand) {
    }

    public void endListGroup(IListGroupContent group) {
        this.decreaseTOCLevel((IContent)group);
    }

    public void endRow(IRowContent row) {
        if (!this.isHidden((IContent)row)) {
            int col;
            List<SpanInfo> spans;
            if (!this.styles.isEmpty()) {
                this.styles.pop();
            }
            if ((spans = this.context.getSpans(col = this.context.getCurrentTableColmns().length - 1)) != null) {
                int spanSize = spans.size();
                if (spanSize > 0) {
                    this.rowFilledFlag = true;
                }
                int i = 0;
                while (i < spanSize) {
                    this.wordWriter.writeSpanCell(spans.get(i));
                    ++i;
                }
            }
            if (!this.rowFilledFlag) {
                this.wordWriter.writeEmptyCell();
                this.rowFilledFlag = true;
            }
            this.wordWriter.endTableRow();
        }
    }

    public void endTableBand(ITableBandContent band) {
    }

    public void endTableGroup(ITableGroupContent group) {
        this.decreaseTOCLevel((IContent)group);
    }

    public void endPage(IPageContent page) {
    }

    public void startImage(IImageContent image) {
        IStyle style = image.getComputedStyle();
        InlineFlag inlineFlag = this.getInlineFlag(style);
        String uri = this.verifyURI(image.getURI());
        String mimeType = image.getMIMEType();
        String extension = image.getExtension();
        String altText = image.getAltText();
        int referenceWidth = (int)(WordUtil.twipToPt(this.context.getCurrentWidth()) * (double)this.reportDpi / 72.0);
        int referenceHeight = 0;
        double width = WordUtil.convertImageSize(image.getWidth(), referenceWidth, this.reportDpi);
        double height = WordUtil.convertImageSize(image.getHeight(), referenceHeight, this.reportDpi);
        this.context.addContainer(false);
        if (FlashFile.isFlash((String)mimeType, (String)uri, (String)extension)) {
            if (altText == null) {
                altText = this.messageFlashObjectNotSupported;
            }
            this.wordWriter.drawImage(null, height, width, null, style, inlineFlag, altText, uri);
            return;
        }
        try {
            float scale;
            int imageFileHeightDpi;
            Image imageInfo = EmitterUtil.parseImage((IImageContent)image, (int)image.getImageSource(), (String)uri, (String)mimeType, (String)extension);
            byte[] data = imageInfo.getData();
            if (data == null || data.length == 0) {
                if (imageInfo.getFormat() < 0 && altText == null) {
                    altText = this.messageReportItemNotSupported;
                }
                this.wordWriter.drawImage(null, 0.0, 0.0, null, style, inlineFlag, altText, uri);
                return;
            }
            int imageFileWidthDpi = imageInfo.getPhysicalWidthDpi() == -1 ? 0 : imageInfo.getPhysicalWidthDpi();
            int n = imageFileHeightDpi = imageInfo.getPhysicalHeightDpi() == -1 ? 0 : imageInfo.getPhysicalHeightDpi();
            if (image.getHeight() == null && image.getWidth() == null) {
                height = WordUtil.convertImageSize(image.getHeight(), imageInfo.getHeight(), PropertyUtil.getImageDpi((IImageContent)image, (int)imageFileHeightDpi, (int)0));
                width = WordUtil.convertImageSize(image.getWidth(), imageInfo.getWidth(), PropertyUtil.getImageDpi((IImageContent)image, (int)imageFileWidthDpi, (int)0));
            } else if (image.getWidth() == null) {
                scale = (float)imageInfo.getHeight() / (float)imageInfo.getWidth();
                width = height / (double)scale;
            } else if (image.getHeight() == null) {
                scale = (float)imageInfo.getHeight() / (float)imageInfo.getWidth();
                height = width * (double)scale;
            }
            if (image.getWidth() != null && "%".equalsIgnoreCase(image.getWidth().getUnits())) {
                referenceWidth = imageInfo.getWidth();
                width = WordUtil.convertImageSize(image.getWidth(), referenceWidth, PropertyUtil.getImageDpi((IImageContent)image, (int)imageFileWidthDpi, (int)0));
            }
            if (image.getHeight() != null && "%".equalsIgnoreCase(image.getHeight().getUnits())) {
                referenceHeight = imageInfo.getHeight();
                height = WordUtil.convertImageSize(image.getHeight(), referenceHeight, PropertyUtil.getImageDpi((IImageContent)image, (int)imageFileHeightDpi, (int)0));
            }
            if (image.getWidth() == null && width == 0.0 && height > 0.0) {
                width = height;
            }
            if (width > 0.0 && image.getHeight() == null && height == 0.0) {
                height = width;
            }
            this.writeBookmark((IContent)image);
            this.writeToc((IContent)image);
            HyperlinkInfo hyper = this.getHyperlink((IContent)image);
            this.wordWriter.drawImage(data, height, width, hyper, style, inlineFlag, altText, uri);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
            this.wordWriter.drawImage(null, height, width, null, style, inlineFlag, altText, uri);
        }
    }

    protected void endTable() {
        this.context.addContainer(true);
        if (!this.styles.isEmpty()) {
            this.styles.pop();
        }
        this.wordWriter.endTable();
        this.context.setIsAfterTable(true);
        this.context.removeTable();
    }

    protected void increaseTOCLevel(IContent content) {
        if (content != null && content.getTOC() != null) {
            ++this.tocLevel;
        }
    }

    protected void decreaseTOCLevel(IContent content) {
        if (content != null && content.getTOC() != null) {
            --this.tocLevel;
        }
    }

    protected void adjustInline() {
        if (!this.context.isFirstInline()) {
            this.wordWriter.endParagraph();
            this.context.endInline();
        }
    }

    protected void writeSectionInP() throws IOException, BirtException {
        this.wordWriter.startSectionInParagraph();
        this.writeHeaderFooter();
        this.wordWriter.writePageProperties(this.pageHeight, this.pageWidth, this.headerHeight, this.footerHeight, this.topMargin + this.pageTopBorderWidth / 8 * 20, this.bottomMargin + this.pageBottomBorderWidth / 8 * 20, this.leftMargin + this.pageLeftBorderWidth / 8 * 20, this.rightMargin + this.pageRightBorderWidth / 8 * 20, this.orientation);
        this.wordWriter.writePageBorders(this.previousPage.getComputedStyle(), this.topMargin, this.bottomMargin, this.leftMargin, this.rightMargin);
        this.wordWriter.endSectionInParagraph();
    }

    protected void writeSectionInBody() throws IOException, BirtException {
        this.wordWriter.startSection();
        this.writeHeaderFooter();
        this.wordWriter.writePageProperties(this.pageHeight, this.pageWidth, this.headerHeight, this.footerHeight, this.topMargin + this.pageTopBorderWidth / 8 * 20, this.bottomMargin + this.pageBottomBorderWidth / 8 * 20, this.leftMargin + this.pageLeftBorderWidth / 8 * 20, this.rightMargin + this.pageRightBorderWidth / 8 * 20, this.orientation);
        this.wordWriter.writePageBorders(this.previousPage.getComputedStyle(), this.topMargin, this.bottomMargin, this.leftMargin, this.rightMargin);
        this.wordWriter.endSection();
    }

    protected void writeToc(IContent content) {
        this.writeToc(content, false);
    }

    protected void writeToc(IContent content, boolean middleInline) {
        Object tocObj;
        if (content != null && (tocObj = content.getTOC()) != null) {
            String toc = tocObj.toString();
            String rgbcolor = content.getStyle().getBackgroundColor();
            String color = EmitterUtil.parseColor((String)rgbcolor);
            if (!"".equals(toc = toc.trim())) {
                this.wordWriter.writeTOC(toc, color, this.tocLevel, middleInline);
            }
        }
    }

    private InlineFlag getInlineFlag(IStyle style) {
        InlineFlag inlineFlag = InlineFlag.BLOCK;
        if ("inline".equalsIgnoreCase(style.getDisplay())) {
            if (this.context.isFirstInline()) {
                this.context.startInline();
                inlineFlag = InlineFlag.FIRST_INLINE;
            } else {
                inlineFlag = InlineFlag.MIDDLE_INLINE;
            }
        } else {
            this.adjustInline();
        }
        return inlineFlag;
    }

    private boolean hasTocOutputed(IContent content) {
        String bookmark = content.getBookmark();
        if (this.set.contains(bookmark)) {
            return true;
        }
        this.set.add(bookmark);
        return false;
    }

    protected void writeBookmark(IContent content) {
        String bookmark = content.getBookmark();
        if (bookmark == null || bookmark.startsWith("_TOC") || this.bookmarks.contains(bookmark)) {
            return;
        }
        bookmark = bookmark.replace(' ', '_');
        this.wordWriter.writeBookmark(bookmark);
        this.bookmarks.add(bookmark);
    }

    protected HyperlinkInfo getHyperlink(IContent content) {
        HyperlinkInfo hyperlink = null;
        IHyperlinkAction linkAction = content.getHyperlinkAction();
        if (linkAction != null) {
            String tooltip = linkAction.getTooltip();
            String bookmark = linkAction.getBookmark();
            switch (linkAction.getType()) {
                case 2: {
                    bookmark = bookmark.replace(' ', '_');
                    hyperlink = new HyperlinkInfo(0, bookmark, tooltip);
                    break;
                }
                case 1: 
                case 3: {
                    String url = EmitterUtil.getHyperlinkUrl((IHyperlinkAction)linkAction, (IReportRunnable)this.reportRunnable, (IHTMLActionHandler)this.actionHandler, (IReportContext)this.reportContext);
                    hyperlink = new HyperlinkInfo(1, url, tooltip);
                }
            }
        }
        if (hyperlink != null) {
            String color = WordUtil.parseColor(content.getStyle().getColor());
            hyperlink.setColor(color);
            if (content.getComputedStyle().getProperty(40) != null) {
                hyperlink.setHasHyperlinkDecoration(content.getComputedStyle().getProperty(40).getCssText().equals("normal"));
            }
        }
        return hyperlink;
    }

    protected void writeText(int type, String txt, IContent content, InlineFlag inlineFlag, IStyle computedStyle, IStyle inlineStyle, String textAlign) {
        HyperlinkInfo hyper = this.getHyperlink(content);
        int paragraphWidth = (int)WordUtil.twipToPt(this.context.getCurrentWidth());
        boolean rtl = content.isDirectionRTL();
        if (content instanceof TextContent) {
            TextFlag textFlag = TextFlag.START;
            String fontFamily = null;
            if ("".equals(txt) || txt == null || WordUtil.isField(content)) {
                this.wordWriter.writeContent(type, txt, computedStyle, inlineStyle, this.getFontFamily(computedStyle), hyper, inlineFlag, textFlag, paragraphWidth, rtl, textAlign);
            } else {
                int level = rtl ? 1 : 0;
                BidiSplitter bidiSplitter = new BidiSplitter(new Chunk(txt, 0, level, level));
                if (bidiSplitter.hasMore()) {
                    do {
                        Chunk ch = bidiSplitter.getNext();
                        level = ch.getRunLevel();
                        FontSplitter fontSplitter = this.getFontSplitter(content, ch.getText());
                        while (fontSplitter.hasMore()) {
                            ch = fontSplitter.getNext();
                            this.wordWriter.writeContent(type, ch.getText(), computedStyle, inlineStyle, this.getFontFamily(computedStyle), hyper, inlineFlag, textFlag, paragraphWidth, (level & 1) != 0 || !rtl && level > 0, textAlign);
                            TextFlag textFlag2 = textFlag = fontSplitter.hasMore() || bidiSplitter.hasMore() ? TextFlag.MIDDLE : TextFlag.END;
                        }
                    } while (bidiSplitter.hasMore());
                } else {
                    FontSplitter fontSplitter = this.getFontSplitter(content, ((TextContent)content).getText());
                    while (fontSplitter.hasMore()) {
                        Chunk ch = fontSplitter.getNext();
                        int offset = ch.getOffset();
                        int length = ch.getLength();
                        fontFamily = this.getFontFamily(computedStyle);
                        String string = null;
                        string = ch instanceof LineBreakChunk ? ch.getText() : txt.substring(offset, offset + length);
                        this.wordWriter.writeContent(type, string, computedStyle, inlineStyle, fontFamily, hyper, inlineFlag, textFlag, paragraphWidth, rtl, textAlign);
                        TextFlag textFlag3 = textFlag = fontSplitter.hasMore() ? TextFlag.MIDDLE : TextFlag.END;
                    }
                }
            }
            if (inlineFlag == InlineFlag.BLOCK) {
                this.wordWriter.writeContent(type, null, computedStyle, inlineStyle, fontFamily, hyper, inlineFlag, TextFlag.END, paragraphWidth, rtl, textAlign);
            }
        } else {
            this.wordWriter.writeContent(type, txt, computedStyle, inlineStyle, this.getFontFamily(computedStyle), hyper, inlineFlag, TextFlag.WHOLE, paragraphWidth, rtl, textAlign);
        }
    }

    private String getFontFamily(IStyle computedStyle) {
        String fontFamily = null;
        CSSValueList families = (CSSValueList)computedStyle.getProperty(69);
        if (families != null && families.getLength() > 0) {
            fontFamily = this.mapGenericFont(families.item(0).getCssText());
        }
        return fontFamily;
    }

    private String mapGenericFont(String font) {
        String fontName = genericFontMapping.get(font);
        if (fontName == null) {
            return font;
        }
        return fontName;
    }

    private FontSplitter getFontSplitter(IContent content, String text) {
        FontMappingManager fontManager = FontMappingManagerFactory.getInstance().getFontMappingManager("doc", Locale.getDefault());
        FontSplitter fontSplitter = new FontSplitter(fontManager, new Chunk(text), (ITextContent)((TextContent)content), false, false);
        return fontSplitter;
    }

    private boolean isHidden(IContent content) {
        if (content != null) {
            IStyle style = content.getStyle();
            if (!CSSValueConstants.NONE_VALUE.equals(style.getProperty(63))) {
                return this.isHiddenByVisibility(content);
            }
            return true;
        }
        return false;
    }

    private boolean isHiddenByVisibility(IContent content) {
        assert (content != null);
        IStyle style = content.getStyle();
        String formats = style.getVisibleFormat();
        return this.contains(formats, this.getOutputFormat());
    }

    private boolean contains(String formats, String format) {
        return formats != null && (formats.indexOf("viewer") >= 0 || formats.indexOf("all") >= 0 || formats.indexOf(format) >= 0);
    }

    protected IStyle computeStyle(IStyle style) {
        if (this.styles.size() == 0) {
            return style;
        }
        int i = 0;
        while (i < 71) {
            if (this.isInherityProperty(i) && this.isNullValue(style.getProperty(i))) {
                style.setProperty(i, null);
                int p = this.styles.size() - 1;
                while (p >= 0) {
                    IStyle parent = (IStyle)this.styles.get(p);
                    if (!this.isNullValue(parent.getProperty(i))) {
                        style.setProperty(i, parent.getProperty(i));
                        break;
                    }
                    --p;
                }
            }
            ++i;
        }
        return style;
    }

    protected boolean isNullValue(CSSValue value) {
        if (value == null || value instanceof DataFormatValue) {
            return true;
        }
        if (value instanceof FloatValue) {
            return false;
        }
        String cssText = value.getCssText();
        return "none".equalsIgnoreCase(cssText) || "transparent".equalsIgnoreCase(cssText);
    }

    private void writeHeaderFooter() throws IOException, BirtException {
        IStyle style = this.previousPage.getStyle();
        String backgroundHeight = style.getBackgroundHeight();
        String backgroundWidth = style.getBackgroundWidth();
        SimpleMasterPageDesign master = (SimpleMasterPageDesign)this.previousPage.getGenerateBy();
        if (this.previousPage.getPageHeader() != null || backgroundHeight != null || backgroundWidth != null) {
            this.wordWriter.startHeader(!master.isShowHeaderOnFirst() && this.previousPage.getPageNumber() == 1L, this.headerHeight, this.contentWidth);
            if (backgroundHeight != null || backgroundWidth != null) {
                String backgroundImageUrl = EmitterUtil.getBackgroundImageUrl((IStyle)style, (ReportDesignHandle)this.reportContent.getDesign().getReportDesign(), (Map)this.reportContext.getAppContext());
                this.wordWriter.drawDocumentBackgroundImage(backgroundImageUrl, backgroundHeight, backgroundWidth, WordUtil.twipToPt(this.topMargin), WordUtil.twipToPt(this.leftMargin), WordUtil.twipToPt(this.pageHeight), WordUtil.twipToPt(this.pageWidth));
            }
            this.contentVisitor.visitChildren(this.previousPage.getPageHeader(), null);
            this.wordWriter.endHeader();
        }
        if (this.previousPage.getPageFooter() != null) {
            if (!master.isShowFooterOnLast() && this.previousPage.getPageNumber() == this.reportContent.getTotalPage()) {
                IContent footer = this.previousPage.getPageFooter();
                ILabelContent emptyContent = footer.getReportContent().createLabelContent();
                emptyContent.setText(EMPTY_FOOTER);
                this.wordWriter.startFooter(this.footerHeight, this.contentWidth);
                this.contentVisitor.visit((IContent)emptyContent, null);
                this.wordWriter.endFooter();
            } else {
                this.wordWriter.startFooter(this.footerHeight, this.contentWidth);
                this.contentVisitor.visitChildren(this.previousPage.getPageFooter(), null);
                this.wordWriter.endFooter();
            }
        }
    }

    protected void drawDocumentBackground() throws IOException {
        IStyle style = this.previousPage.getStyle();
        String backgroundColor = style.getBackgroundColor();
        String backgroundImageUrl = EmitterUtil.getBackgroundImageUrl((IStyle)style, (ReportDesignHandle)this.reportContent.getDesign().getReportDesign(), (Map)this.reportContext.getAppContext());
        String height = style.getBackgroundHeight();
        String width = style.getBackgroundWidth();
        this.wordWriter.drawDocumentBackground(backgroundColor, backgroundImageUrl, height, width);
    }

    private boolean isInherityProperty(int propertyIndex) {
        return !nonInherityStyles.contains(propertyIndex);
    }

    private int getCellWidth(int cellWidth, IStyle style) {
        int leftPadding = this.getPadding(style.getProperty(12));
        int rightPadding = this.getPadding(style.getProperty(16));
        if (leftPadding > cellWidth) {
            leftPadding = 0;
        }
        if (rightPadding > cellWidth) {
            rightPadding = 0;
        }
        if (leftPadding + rightPadding > cellWidth) {
            rightPadding = 0;
        }
        return cellWidth - leftPadding - rightPadding;
    }

    private int getPadding(CSSValue padding) {
        return PropertyUtil.getDimensionValue((CSSValue)padding) / 50;
    }

    private int[] computeTblColumnWidths(ITableContent table, int tblWidth) {
        int colCount = table.getColumnCount();
        int[] tblColumns = new int[colCount];
        int count = 0;
        int total = 0;
        int i = 0;
        while (i < colCount) {
            IColumn col = table.getColumn(i);
            if (col.getWidth() == null) {
                tblColumns[i] = -1;
                ++count;
            } else {
                int colWidth = WordUtil.convertTo(col.getWidth(), tblWidth, this.reportDpi);
                tblColumns[i] = colWidth = colWidth > 31680 ? 31680 : colWidth;
                total += tblColumns[i];
            }
            ++i;
        }
        if (table.getWidth() == null && count == 0) {
            return tblColumns;
        }
        tblWidth = (tblWidth = Math.min(tblWidth, this.context.getCurrentWidth())) > 31680 ? 31680 : tblWidth;
        int[] tblColWidth = EmitterUtil.resizeTableColumn((int)tblWidth, (int[])tblColumns, (int)count, (int)total);
        int i2 = 0;
        while (i2 < tblColWidth.length) {
            tblColWidth[i2] = tblColWidth[i2] > 31680 ? 31680 : tblColWidth[i2];
            ++i2;
        }
        return tblColWidth;
    }

    public int getWordVersion() {
        return this.wordVersion;
    }

    public void setWordVersion(int wordVersion) {
        this.wordVersion = wordVersion;
    }

    private String verifyURI(String uri) {
        if (uri != null && !((String)uri).toLowerCase().startsWith(URL_PROTOCOL_TYPE_DATA)) {
            Object tmpUrl = ((String)uri).replaceAll(EMPTY_FOOTER, URL_PROTOCOL_URL_ENCODED_SPACE);
            try {
                new URL((String)tmpUrl).toURI();
            }
            catch (MalformedURLException | URISyntaxException excUrl) {
                try {
                    tmpUrl = "file:///" + (String)uri;
                    new URL((String)tmpUrl).toURI();
                    uri = tmpUrl;
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    // empty catch block
                }
            }
        }
        return uri;
    }

    public static enum InlineFlag {
        FIRST_INLINE,
        MIDDLE_INLINE,
        BLOCK;

    }

    public static enum TextFlag {
        START,
        MIDDLE,
        END,
        WHOLE;

    }

    static class TocInfo {
        String tocValue;
        int tocLevel;

        TocInfo(String tocValue, int tocLevel) {
            this.tocValue = tocValue;
            this.tocLevel = tocLevel;
        }
    }
}

