/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model.schematic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.ReportItemtHandleAdapter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class MultipleAdapter
extends ReportItemtHandleAdapter {
    private static final String SET_VIEW = Messages.getString("MultipleAdapter.SetCurrentView");
    private static final String REMOVE_VIEW = Messages.getString("MultipleAdapter.RemoveView");

    public MultipleAdapter(ReportItemHandle handle, IModelAdapterHelper mark) {
        super(handle, mark);
    }

    public List getChildren() {
        ReportItemHandle handle = this.getReportItemHandle();
        DesignElementHandle viewHnadle = handle.getCurrentView();
        ArrayList<Object> list = new ArrayList<Object>();
        if (viewHnadle != null) {
            list.add(viewHnadle);
        } else {
            list.add(handle);
        }
        return list;
    }

    public List getViews() {
        ReportItemHandle handle = this.getReportItemHandle();
        return handle.getViews();
    }

    public DesignElementHandle getCurrentView() {
        ReportItemHandle handle = this.getReportItemHandle();
        return handle.getCurrentView();
    }

    public void setCurrentView(int number) {
        try {
            if (number == 0 && this.getCurrentView() == null) {
                return;
            }
            int position = number - 1;
            List list = this.getViews();
            if (position < 0 && position > list.size() - 1) {
                return;
            }
            this.transStar(SET_VIEW);
            ReportItemHandle handle = this.getReportItemHandle();
            if (number == 0 && this.getCurrentView() != null) {
                handle.setCurrentView(null);
                this.transEnd();
                return;
            }
            handle.setCurrentView((DesignElementHandle)list.get(position));
            this.transEnd();
        }
        catch (SemanticException e) {
            this.rollBack();
        }
    }

    public void removeView(int number) {
        if (number < 1) {
            return;
        }
        int position = number - 1;
        List list = this.getViews();
        if (position < 0 && position > list.size() - 1) {
            return;
        }
        this.transStar(REMOVE_VIEW);
        ReportItemHandle handle = this.getReportItemHandle();
        try {
            handle.dropView((DesignElementHandle)list.get(position));
            this.transEnd();
        }
        catch (SemanticException e) {
            this.rollBack();
        }
    }

    public int getCurrentViewNumber() {
        ReportItemHandle handle = this.getReportItemHandle();
        DesignElementHandle current = handle.getCurrentView();
        if (current == null || !this.getViews().contains(handle.getCurrentView())) {
            return 0;
        }
        return this.getViews().indexOf(handle.getCurrentView()) + 1;
    }
}

