/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.PropertyMask;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ReportElementParseTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testPropertyMask() throws Exception {
        this.openDesign("ReportElementParseTest.xml");
        LabelHandle handle = (LabelHandle)this.designHandle.findElement("bodyLabel1");
        int count = 0;
        Iterator iterator = handle.propertyMaskIterator();
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        ReportElementParseTest.assertEquals((int)5, (int)count);
        PropertyHandle propHandle = handle.getPropertyHandle("propertyMasks");
        StructureHandle structHandle = propHandle.getAt(0);
        MemberHandle memberHandle = structHandle.getMember("mask");
        ReportElementParseTest.assertEquals((String)"lock", (String)memberHandle.getStringValue());
        memberHandle = structHandle.getMember("name");
        ReportElementParseTest.assertEquals((String)"text", (String)memberHandle.getStringValue());
        structHandle = propHandle.getAt(2);
        memberHandle = structHandle.getMember("mask");
        ReportElementParseTest.assertEquals((String)"hide", (String)memberHandle.getStringValue());
        memberHandle = structHandle.getMember("name");
        ReportElementParseTest.assertEquals((String)"textID", (String)memberHandle.getStringValue());
        structHandle = propHandle.getAt(3);
        memberHandle = structHandle.getMember("mask");
        ReportElementParseTest.assertEquals((String)"hide", (String)memberHandle.getStringValue());
        memberHandle = structHandle.getMember("name");
        ReportElementParseTest.assertNull((Object)memberHandle.getStringValue());
        structHandle = propHandle.getAt(4);
        memberHandle = structHandle.getMember("mask");
        ReportElementParseTest.assertEquals((String)"hide", (String)memberHandle.getStringValue());
        memberHandle = structHandle.getMember("name");
        ReportElementParseTest.assertNull((Object)memberHandle.getStringValue());
        structHandle = propHandle.getAt(0);
        memberHandle = structHandle.getMember("mask");
        memberHandle.setValue((Object)"change");
        ReportElementParseTest.assertEquals((String)"change", (String)memberHandle.getStringValue());
        structHandle = propHandle.getAt(2);
        memberHandle = structHandle.getMember("mask");
        memberHandle.setValue((Object)"lock");
        ReportElementParseTest.assertEquals((String)"lock", (String)memberHandle.getStringValue());
        structHandle = propHandle.getAt(3);
        memberHandle = structHandle.getMember("mask");
        try {
            memberHandle.setValue((Object)"not mask");
            ReportElementParseTest.fail();
        }
        catch (PropertyValueException e) {
            ReportElementParseTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
        propHandle.removeItem(3);
        PropertyMask mask = new PropertyMask();
        mask.setProperty((PropertyDefn)structHandle.getDefn().getMember("name"), (Object)"height");
        mask.setProperty((PropertyDefn)structHandle.getDefn().getMember("mask"), (Object)"lock");
        propHandle.addItem((IStructure)mask);
        handle = (LabelHandle)this.designHandle.findElement("base");
        propHandle = handle.getPropertyHandle("propertyMasks");
        mask = new PropertyMask();
        mask.setProperty((PropertyDefn)structHandle.getDefn().getMember("name"), (Object)"height");
        mask.setProperty((PropertyDefn)structHandle.getDefn().getMember("mask"), (Object)"lock");
        propHandle.addItem((IStructure)mask);
        this.save();
        ReportElementParseTest.assertTrue((boolean)this.compareFile("ReportElementParseTest_golden.xml"));
    }

    public void testSemanticCheck() throws DesignFileException {
        this.openDesign("ReportElementParseTest_1.xml");
        List list = this.design.getErrorList();
        ReportElementParseTest.assertEquals((int)2, (int)list.size());
        ReportElementParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)((ErrorDetail)list.get(0)).getErrorCode());
        ReportElementParseTest.assertEquals((String)"Error.SemanticError.INVALID_PROPERTY_NAME", (String)((ErrorDetail)list.get(1)).getErrorCode());
    }
}

