/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.ContentVisitorAdapter;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.content.impl.ContainerContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class IContentTest
extends EngineCase {
    private IContent content;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.content = new ReportContent().createContainerContent();
    }

    public void testX() {
        IContentTest.assertNull((Object)this.content.getX());
        DimensionType x1 = new DimensionType(1.0, "in");
        this.content.setX(x1);
        IContentTest.assertEquals((Object)x1, (Object)this.content.getX());
        this.content.setX(null);
        IContentTest.assertNull((Object)this.content.getX());
    }

    public void testY() {
        IContentTest.assertNull((Object)this.content.getY());
        DimensionType y1 = new DimensionType(1.0, "in");
        this.content.setY(y1);
        IContentTest.assertEquals((Object)y1, (Object)this.content.getY());
        this.content.setY(null);
        IContentTest.assertNull((Object)this.content.getY());
    }

    public void testContent() throws IOException {
        ReportContent rContent = new ReportContent();
        IContainerContent content1 = rContent.createContainerContent();
        IContainerContent content2 = rContent.createContainerContent();
        content1.setName("myContent");
        content1.setHelpText("myHelpText");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        ((ContainerContent)content1).setVersion(1);
        content1.writeContent(dos);
        ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());
        DataInputStream dis = new DataInputStream(is);
        ((ContainerContent)content2).setVersion(1);
        content2.readContent(dis, null);
        IContentTest.assertEquals((String)content1.getName(), (String)content2.getName());
        IContentTest.assertEquals((String)content1.getHelpText(), (String)content2.getHelpText());
    }

    public void testWidth() {
        IContentTest.assertNull((Object)this.content.getWidth());
        DimensionType width = new DimensionType(1.0, "in");
        this.content.setWidth(width);
        IContentTest.assertEquals((Object)width, (Object)this.content.getWidth());
        this.content.setWidth(null);
        IContentTest.assertNull((Object)this.content.getWidth());
    }

    public void testToc() {
        IContentTest.assertNull((Object)this.content.getTOC());
        Object toc = new Object();
        this.content.setTOC(toc);
        IContentTest.assertEquals((Object)toc, (Object)this.content.getTOC());
        this.content.setTOC(null);
        IContentTest.assertNull((Object)this.content.getTOC());
    }

    public void testStyleClass() {
        IContentTest.assertNull((Object)this.content.getStyleClass());
        this.content.setStyleClass("style1");
        IContentTest.assertEquals((String)"style1", (String)this.content.getStyleClass());
        this.content.setStyleClass(null);
        IContentTest.assertNull((Object)this.content.getStyleClass());
    }

    public void testReportContent() {
        ReportContent report = new ReportContent();
        this.content.setReportContent((IReportContent)report);
        IContentTest.assertEquals((Object)report, (Object)this.content.getReportContent());
    }

    public void testName() {
        IContentTest.assertNull((Object)this.content.getName());
        this.content.setName("name");
        IContentTest.assertEquals((String)"name", (String)this.content.getName());
        this.content.setName(null);
        IContentTest.assertNull((Object)this.content.getName());
    }

    public void testInstanceID() {
        IContentTest.assertNull((Object)this.content.getInstanceID());
        InstanceID iid = new InstanceID(null, 1L, null);
        this.content.setInstanceID(iid);
        IContentTest.assertEquals((Object)iid, (Object)this.content.getInstanceID());
        this.content.setInstanceID(null);
        IContentTest.assertNull((Object)this.content.getInstanceID());
    }

    public void testInlineStyle() {
        IContentTest.assertNull((Object)this.content.getInlineStyle());
        IStyle style = new ReportContent().createStyle();
        this.content.setInlineStyle(style);
        IContentTest.assertEquals((Object)style, (Object)this.content.getInlineStyle());
    }

    public void testHyperlinkAction() {
        IContentTest.assertNull((Object)this.content.getHyperlinkAction());
        ActionContent action = new ActionContent();
        this.content.setHyperlinkAction((IHyperlinkAction)action);
        IContentTest.assertEquals((Object)action, (Object)this.content.getHyperlinkAction());
    }

    public void testHelpText() {
        IContentTest.assertNull((Object)this.content.getHelpText());
        this.content.setHelpText("help");
        IContentTest.assertEquals((String)"help", (String)this.content.getHelpText());
    }

    public void testHeight() {
        IContentTest.assertNull((Object)this.content.getHeight());
        DimensionType height = new DimensionType(1.0, "in");
        this.content.setHeight(height);
        IContentTest.assertEquals((Object)height, (Object)this.content.getHeight());
    }

    public void testGenerateBy() {
        IContentTest.assertNull((Object)this.content.getGenerateBy());
        Object obj = new Object();
        this.content.setGenerateBy(obj);
        IContentTest.assertEquals((Object)obj, (Object)this.content.getGenerateBy());
    }

    public void testBookmark() {
        IContentTest.assertNull((Object)this.content.getBookmark());
        this.content.setBookmark("bookmark");
        IContentTest.assertEquals((String)"bookmark", (String)this.content.getBookmark());
    }

    public void testExtension() {
        IContentTest.assertNull((Object)this.content.getExtension(0));
        IContentTest.assertNull((Object)this.content.getExtension(1));
        this.content.setExtension(0, (Object)"extension0");
        IContentTest.assertEquals((Object)"extension0", (Object)this.content.getExtension(0));
        this.content.setExtension(1, null);
        IContentTest.assertNull((Object)this.content.getExtension(1));
    }

    public void testAccept() throws BirtException {
        Object value = new Object();
        ContentVisitorAdapter visitor = new ContentVisitorAdapter();
        Object value1 = this.content.accept((IContentVisitor)visitor, value);
        IContentTest.assertEquals((Object)value, (Object)value1);
        value1 = this.content.accept((IContentVisitor)visitor, null);
        IContentTest.assertNull((Object)value1);
    }
}

