/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import com.ibm.icu.util.ULocale;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.integrate.SimpleDataRowExpressionEvaluator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public final class Regression_285009
extends ChartTestCase {
    private static String GOLDEN = "Regression_285009.jpg";
    private static String OUTPUT = "Regression_285009.jpg";
    private IDeviceRenderer idr = null;
    private Chart cm = null;
    private IDataRowExpressionEvaluator dree = null;

    public static void main(String[] args) {
        new Regression_285009();
    }

    public Regression_285009() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.idr = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = Regression_285009.createSimpleChart();
        BufferedImage img = new BufferedImage(600, 600, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.idr.setProperty("device.output.context", (Object)g2d);
        this.idr.setProperty("device.file.identifier", (Object)this.genOutputFile(OUTPUT));
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)600.0, (double)600.0);
        bo.scale(72.0 / (double)this.idr.getDisplayServer().getDpiResolution());
        RunTimeContext context = new RunTimeContext();
        context.setULocale(ULocale.getDefault());
        String[] set = new String[]{"Items", "Amounts", "New Amounts"};
        Object[][] data = new Object[][]{{"A", "B", "C"}, {7, 2, 5}, {3, 5, 2}};
        this.dree = new SimpleDataRowExpressionEvaluator(set, data);
        Generator gr = Generator.instance();
        try {
            gr.bindData(this.dree, this.cm, context);
            gr.render(this.idr, gr.build(this.idr.getDisplayServer(), this.cm, bo, null, context, null));
        }
        catch (ChartException ce) {
            ce.printStackTrace();
        }
    }

    private static Chart createSimpleChart() {
        ChartWithAxes cwaBar = ChartWithAxesImpl.create();
        cwaBar.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
        Axis xAxisPrimary = cwaBar.getPrimaryBaseAxes()[0];
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        xAxisPrimary.getTitle().setVisible(true);
        Axis yAxisPrimary = cwaBar.getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getTitle().setVisible(true);
        Series seCategory = SeriesImpl.create();
        Query query = QueryImpl.create((String)"Items");
        seCategory.getDataDefinition().add((Object)query);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seCategory);
        sdX.setSorting(SortOption.ASCENDING_LITERAL);
        sdX.setSortKey(QueryImpl.create((String)"Amounts"));
        BarSeries bs1 = (BarSeries)BarSeriesImpl.create();
        bs1.getDataDefinition().add((Object)QueryImpl.create((String)"Amounts"));
        bs1.setRiserOutline(null);
        bs1.getLabel().setVisible(true);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        sdY.getSeriesPalette().shift(-1);
        sdY.setQuery(QueryImpl.create((String)"Items"));
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeries().add((Object)bs1);
        sdY.setSorting(SortOption.ASCENDING_LITERAL);
        sdY.setSortKey(QueryImpl.create((String)"New Amounts"));
        return cwaBar;
    }

    public void test_regression_285009() throws Exception {
        Regression_285009 st = new Regression_285009();
        Regression_285009.assertTrue((boolean)st.compareImages(GOLDEN, OUTPUT));
    }
}

