/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.util.Comparator;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.executor.doc.LongComparator;
import org.eclipse.birt.report.engine.internal.executor.doc.Segment;
import org.eclipse.birt.report.engine.internal.executor.doc.Tree;

class TreeFragment {
    Tree tree;
    Fragment fragment = new Fragment((Comparator)new LongComparator());

    TreeFragment(Tree tree) {
        this.tree = tree;
    }

    void addFragment(long left, long right) {
        Tree.Node leftNode = this.tree.findNode(left);
        Tree.Node rightNode = this.tree.findNode(right);
        Object[] leftEdges = this.tree.getEdges(leftNode);
        Object[] rightEdges = this.tree.getEdges(rightNode);
        this.fragment.addSection(leftEdges, rightEdges);
    }

    void build() {
        this.fragment.build();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Fragment frag = this.fragment.getFragment((Object)this.tree.root.offset);
        this.visit(buffer, this.tree.root, frag);
        return buffer.toString();
    }

    void visit(StringBuffer buffer, Tree.Node node, Fragment frag) {
        Fragment childFrag;
        buffer.append(String.valueOf(node.offset));
        buffer.append(",");
        Tree.Node child = node.child;
        if (child != null && frag != null && !frag.inFragment((Object)child.offset)) {
            childFrag = frag.getNextFragment(Segment.LEFT_MOST_EDGE);
            child = childFrag != null ? this.tree.findNode((Long)childFrag.index) : null;
        }
        while (child != null) {
            childFrag = null;
            if (frag != null) {
                childFrag = frag.getFragment((Object)child.offset);
            }
            this.visit(buffer, child, childFrag);
            child = child.next;
            if (child == null || frag == null || frag.inFragment((Object)child.offset)) continue;
            Fragment nextFrag = frag.getNextFragment((Object)child.offset);
            child = nextFrag != null ? this.tree.findNode((Long)nextFrag.index) : null;
        }
    }
}

