/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;

public class Literals {
    private Literals() {
    }

    public static String toLiteral(Object o) {
        return Literals.toLiteral(o, null);
    }

    public static String toLiteral(Object o, GenModel genModel) {
        return Literals.toLiteral(o, false, genModel);
    }

    public static String toLiteral(Object o, boolean boxPrimitive, GenModel genModel) {
        if (o instanceof Boolean) {
            return Literals.toBooleanLiteral((Boolean)o, boxPrimitive, genModel);
        }
        if (o instanceof Byte) {
            return Literals.toByteLiteral((Byte)o, boxPrimitive, genModel);
        }
        if (o instanceof Short) {
            String result = Literals.toShortLiteral((Short)o, genModel);
            return boxPrimitive ? Literals.box(result, "Short", "short", genModel) : result;
        }
        if (o instanceof Integer) {
            String result = Literals.toIntLiteral((Integer)o, genModel);
            return boxPrimitive ? Literals.box(result, "Integer", null, genModel) : result;
        }
        if (o instanceof Long) {
            String result = Literals.toLongLiteral((Long)o, genModel);
            return boxPrimitive ? Literals.box(result, "Long", null, genModel) : result;
        }
        if (o instanceof Float) {
            String result = Literals.toFloatLiteral(((Float)o).floatValue(), genModel);
            return boxPrimitive ? Literals.box(result, "Float", null, genModel) : result;
        }
        if (o instanceof Double) {
            String result = Literals.toDoubleLiteral((Double)o, genModel);
            return boxPrimitive ? Literals.box(result, "Double", null, genModel) : result;
        }
        if (o instanceof Character) {
            String result = Literals.toCharLiteral(((Character)o).charValue(), genModel);
            return boxPrimitive ? Literals.box(result, "Character", null, genModel) : result;
        }
        if (o instanceof String) {
            return Literals.toStringLiteral((String)o, genModel);
        }
        if (o instanceof BigDecimal) {
            return Literals.toBigDecimalLiteral((BigDecimal)o, genModel);
        }
        if (o instanceof BigInteger) {
            return Literals.toBigIntegerLiteral((BigInteger)o, genModel);
        }
        if (o instanceof Date) {
            return Literals.toDateLiteral((Date)o, genModel);
        }
        if (o instanceof Class) {
            return Literals.toClassLiteral((Class)o, genModel);
        }
        if (o instanceof byte[]) {
            return Literals.toByteArrayLiteral((byte[])o, genModel);
        }
        return null;
    }

    private static String toBooleanLiteral(boolean b, boolean box, GenModel genModel) {
        if (box) {
            return String.valueOf(Literals.importName("java.lang.Boolean", genModel)) + (b ? ".TRUE" : ".FALSE");
        }
        return b ? "true" : "false";
    }

    public static String toBooleanLiteral(boolean b, GenModel genModel) {
        return Literals.toBooleanLiteral(b, false, genModel);
    }

    private static String toByteLiteral(byte b, boolean box, GenModel genModel) {
        String result = Literals.toByteLiteral(b, genModel);
        if (box) {
            String wrapperClass = Literals.importName("java.lang.Byte", genModel);
            StringBuilder boxed = new StringBuilder(16 + wrapperClass.length());
            Literals.appendBoxPrefix(boxed, wrapperClass, genModel);
            if (b >= 0) {
                boxed.append("(byte)");
            }
            boxed.append(result);
            boxed.append(')');
            result = boxed.toString();
        }
        return result;
    }

    public static String toByteLiteral(byte b, GenModel genModel) {
        String hex = Integer.toHexString(b);
        switch (hex.length()) {
            case 1: {
                return "0x0" + hex;
            }
            case 2: {
                return "0x" + hex;
            }
            case 8: {
                return "(byte)0x" + hex.substring(hex.length() - 2);
            }
        }
        throw new IllegalArgumentException("A byte cannot convert to a " + hex.length() + " digit hex string (Java platform error in Integer.toHexString())");
    }

    private static String box(String literal, String wrapperClass, String castType, GenModel genModel) {
        wrapperClass = Literals.importName(wrapperClass, genModel);
        StringBuilder boxed = new StringBuilder(6 + literal.length() + wrapperClass.length() + (castType != null ? castType.length() + 2 : 0));
        Literals.appendBoxPrefix(boxed, wrapperClass, genModel);
        if (castType != null) {
            boxed.append('(');
            boxed.append(castType);
            boxed.append(')');
        }
        boxed.append(literal);
        boxed.append(')');
        return boxed.toString();
    }

    private static void appendBoxPrefix(StringBuilder boxed, String wrapperClass, GenModel genModel) {
        if (genModel != null && genModel.getComplianceLevel().getValue() >= 5) {
            boxed.append(wrapperClass);
            boxed.append(".valueOf(");
        } else {
            boxed.append("new ");
            boxed.append(wrapperClass);
            boxed.append('(');
        }
    }

    public static String toShortLiteral(short s, GenModel genModel) {
        return Short.toString(s);
    }

    public static String toIntLiteral(int i, GenModel genModel) {
        return Integer.toString(i);
    }

    public static String toLongLiteral(long l, GenModel genModel) {
        return String.valueOf(Long.toString(l)) + "L";
    }

    public static String toFloatLiteral(float f, GenModel genModel) {
        if (Float.isNaN(f)) {
            return String.valueOf(Literals.importName("java.lang.Float", genModel)) + ".NaN";
        }
        if (Float.isInfinite(f)) {
            return f > 0.0f ? String.valueOf(Literals.importName("java.lang.Float", genModel)) + ".POSITIVE_INFINITY" : String.valueOf(Literals.importName("java.lang.Float", genModel)) + ".NEGATIVE_INFINITY";
        }
        return String.valueOf(Float.toString(f)) + "F";
    }

    public static String toDoubleLiteral(double d, GenModel genModel) {
        if (Double.isNaN(d)) {
            return String.valueOf(Literals.importName("java.lang.Double", genModel)) + ".NaN";
        }
        if (Double.isInfinite(d)) {
            return d > 0.0 ? String.valueOf(Literals.importName("java.lang.Double", genModel)) + ".POSITIVE_INFINITY" : String.valueOf(Literals.importName("java.lang.Double", genModel)) + ".NEGATIVE_INFINITY";
        }
        return Double.toString(d);
    }

    private static String importName(String name, GenModel genModel) {
        return genModel != null && genModel.getImportManager() != null ? genModel.getImportedName(name) : name;
    }

    public static String toCharLiteral(char c, GenModel genModel) {
        StringBuilder result = new StringBuilder(8);
        result.append('\'');
        result.append(Literals.escapeChar(c, false));
        result.append('\'');
        return result.toString();
    }

    public static String toUnsafeCharLiteral(char c, GenModel genModel) {
        StringBuilder result = new StringBuilder(8);
        result.append('\'');
        result.append(Literals.escapeChar(c, true));
        result.append('\'');
        return result.toString();
    }

    public static String toStringLiteral(String s, GenModel genModel) {
        return Literals.toStringLiteral(s, genModel, false);
    }

    public static String toUnsafeStringLiteral(String s, GenModel genModel) {
        return Literals.toStringLiteral(s, genModel, true);
    }

    private static String toStringLiteral(String s, GenModel genModel, boolean unsafe) {
        if (s == null) {
            return "null";
        }
        int len = s.length();
        StringBuilder result = new StringBuilder(len + 16);
        result.append('\"');
        int i = 0;
        while (i < len) {
            result.append(Literals.escapeChar(s.charAt(i), unsafe));
            ++i;
        }
        result.append('\"');
        return result.toString();
    }

    private static String escapeChar(char c, boolean unsafe) {
        if (c == '\b') {
            return "\\b";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\f') {
            return "\\f";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\"') {
            return "\\\"";
        }
        if (c == '\'') {
            return "\\'";
        }
        if (c == '\\') {
            return "\\\\";
        }
        if (unsafe || c >= ' ' && c < '\u007f') {
            return String.valueOf(c);
        }
        String num = Integer.toHexString(c);
        switch (num.length()) {
            case 1: {
                return "\\u000" + num;
            }
            case 2: {
                return "\\u00" + num;
            }
            case 3: {
                return "\\u0" + num;
            }
        }
        return "\\u" + num;
    }

    public static String toBigDecimalLiteral(BigDecimal bigDecimal, GenModel genModel) {
        if (bigDecimal == null) {
            return "null";
        }
        return "new " + Literals.importName("java.math.BigDecimal", genModel) + "(\"" + bigDecimal.toString() + "\")";
    }

    public static String toBigIntegerLiteral(BigInteger bigInteger, GenModel genModel) {
        if (bigInteger == null) {
            return "null";
        }
        return "new " + Literals.importName("java.math.BigInteger", genModel) + "(\"" + bigInteger.toString() + "\")";
    }

    public static String toDateLiteral(Date date, GenModel genModel) {
        String timeLiteral = Literals.toLongLiteral(date.getTime(), genModel);
        return "new " + Literals.importName("java.util.Date", genModel) + "(" + timeLiteral + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toClassLiteral(Class<?> c, GenModel genModel) {
        if (c == null) {
            return "null";
        }
        String name = c.getName();
        int arrayDepth = 0;
        while (name.charAt(arrayDepth) == '[') {
            ++arrayDepth;
        }
        if (arrayDepth > 0) {
            if (name.charAt(arrayDepth) == 'B') {
                name = "byte";
            } else if (name.charAt(arrayDepth) == 'C') {
                name = "char";
            } else if (name.charAt(arrayDepth) == 'D') {
                name = "double";
            } else if (name.charAt(arrayDepth) == 'F') {
                name = "float";
            } else if (name.charAt(arrayDepth) == 'I') {
                name = "int";
            } else if (name.charAt(arrayDepth) == 'J') {
                name = "long";
            } else if (name.charAt(arrayDepth) == 'S') {
                name = "short";
            } else if (name.charAt(arrayDepth) == 'Z') {
                name = "boolean";
            } else {
                if (name.charAt(arrayDepth) != 'L') throw new IllegalArgumentException("Invalid class name: " + name);
                name = Literals.importName(name.substring(arrayDepth + 1, name.length() - 1), genModel);
            }
        } else if (!c.isPrimitive()) {
            name = Literals.importName(name, genModel);
        }
        StringBuilder result = new StringBuilder(name.length() + 2 * arrayDepth + 8);
        result.append(name);
        int i = 0;
        while (i < arrayDepth) {
            result.append('[');
            result.append(']');
            ++i;
        }
        result.append(".class");
        return result.toString();
    }

    public static String toByteArrayLiteral(byte[] bytes, GenModel genModel) {
        if (bytes == null) {
            return "null";
        }
        if (bytes.length == 0) {
            return "{}";
        }
        StringBuilder result = new StringBuilder(2 + bytes.length * 7);
        result.append("{ ");
        int i = 0;
        int last = bytes.length - 1;
        while (i <= last) {
            result.append(Literals.toByteLiteral(bytes[i], genModel));
            if (i < last) {
                result.append(", ");
            }
            ++i;
        }
        result.append(" }");
        return result.toString();
    }
}

