/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.expression;

import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButtonProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionButtonProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionHelper;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionBuilder;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionSupport;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.MenuButton;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class ExpressionButton {
    private MenuButton button;
    private IExpressionHelper helper;
    private IExpressionButtonProvider provider;
    private Menu menu;
    private SelectionAdapter listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Widget widget = e.widget;
            if (widget instanceof MenuItem) {
                String exprType = (String)widget.getData();
                ExpressionButton.this.provider.handleSelectionEvent(exprType);
                ExpressionButton.this.refresh();
            } else if (widget instanceof MenuButton) {
                ExpressionButton.this.provider.handleSelectionEvent(ExpressionButton.this.getExpressionType());
            }
        }
    };

    public ExpressionButton(Composite parent, int style, boolean allowConstant) {
        this.button = new MenuButton(parent, style);
        this.button.addSelectionListener((SelectionListener)this.listener);
        this.menu = new Menu((Decorations)parent.getShell(), 8);
        this.button.setDropDownMenu(this.menu);
        this.setExpressionButtonProvider(new ExpressionButtonProvider(allowConstant));
        this.refresh();
    }

    public void setEnabled(boolean enable) {
        this.button.setEnabled(enable);
    }

    public boolean isEnabled() {
        return this.button.isEnabled();
    }

    public MenuButton getControl() {
        return this.button;
    }

    protected void setExpressionType(String exprType) {
        if (this.helper != null && !exprType.equals(this.helper.getExpressionType())) {
            this.helper.setExpressionType(exprType);
        }
    }

    protected String getExpressionType() {
        String type = null;
        if (this.helper != null) {
            List<String> types;
            type = this.helper.getExpressionType();
            if (type == null) {
                type = UIUtil.getDefaultScriptType();
                this.helper.setExpressionType(type);
            }
            if (this.provider != null && !(types = Arrays.asList(this.provider.getExpressionTypes())).contains(type) && types.size() > 0) {
                type = types.get(0).toString();
                this.helper.setExpressionType(type);
            }
        }
        return type;
    }

    protected String getExpression() {
        if (this.helper != null) {
            return this.helper.getExpression();
        }
        return "";
    }

    protected void setExpression(String expression) {
        if (expression != null && this.helper != null) {
            this.helper.setExpression(expression);
        }
    }

    protected int openExpressionBuilder(IExpressionBuilder builder, String expressionType) {
        builder.setExpression(this.getExpression());
        if (this.helper != null) {
            builder.setExpressionContext(this.helper.getExpressionContextFactory().getContext(expressionType, this.helper.getContextObject()));
        }
        if (builder.open() == 0) {
            this.setExpressionType(expressionType);
            if (this.helper != null) {
                Object result = builder.getExpression();
                String newExpression = result == null ? null : result.toString();
                this.helper.setExpression(newExpression);
            }
            return 0;
        }
        return 1;
    }

    public void notifyExpressionChangeEvent(String oldExpression, String newExpression) {
        if (this.helper != null) {
            this.helper.notifyExpressionChangeEvent(oldExpression, newExpression);
        }
    }

    public void setExpressionHelper(IExpressionHelper helper) {
        this.helper = helper;
    }

    public IExpressionHelper getExpressionHelper() {
        return this.helper;
    }

    public void refresh() {
        if (!this.button.isDisposed()) {
            this.button.setImage(this.provider.getImage(this.getExpressionType()));
            this.button.setToolTipText(this.provider.getTooltipText(this.getExpressionType()));
        }
    }

    public void setExpressionButtonProvider(IExpressionButtonProvider provider) {
        if (provider != null && provider != this.provider) {
            this.provider = provider;
            provider.setInput(this);
            int i = 0;
            while (i < this.menu.getItemCount()) {
                this.menu.getItem(i).dispose();
                --i;
                ++i;
            }
            String[] types = this.provider.getExpressionTypes();
            int i2 = 0;
            while (i2 < types.length) {
                MenuItem item = new MenuItem(this.menu, 8);
                item.setText(this.provider.getText(types[i2]));
                item.setData((Object)types[i2]);
                item.setImage(this.provider.getImage(types[i2]));
                item.addSelectionListener((SelectionListener)this.listener);
                ++i2;
            }
            if (this.menu.getItemCount() <= 1) {
                this.button.setDropDownMenu(null);
            }
            this.refresh();
        }
    }

    public IExpressionButtonProvider getExpressionButtonProvider() {
        return this.provider;
    }

    public boolean isSupportType(String expressionType) {
        if (this.provider != null) {
            String[] types = this.provider.getExpressionTypes();
            return Arrays.asList(types).contains(expressionType);
        }
        return false;
    }

    public IExpressionSupport getExpressionSupport(String exprType) {
        if (this.provider != null) {
            return this.provider.getExpressionSupport(exprType);
        }
        return null;
    }

    public IExpressionSupport getCurrentExpressionSupport() {
        if (this.provider != null) {
            return this.provider.getExpressionSupport(this.getExpressionType());
        }
        return null;
    }
}

