/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeCursor;
import org.eclipse.birt.core.btree.BTreeFile;
import org.eclipse.birt.core.btree.BTreeOption;
import org.eclipse.birt.core.btree.FileBTreeFile;
import org.junit.Test;

public class BTreeCursorTest
extends TestCase {
    @Test
    public void testCursor() throws Exception {
        new File("./utest/btree.dat").delete();
        FileBTreeFile file = new FileBTreeFile("./utest/btree.dat");
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                BTreeCursor cursor;
                BTreeOption option = new BTreeOption();
                option.setFile((BTreeFile)file, true);
                try (BTree btree = new BTree(option);){
                    cursor = btree.createCursor();
                    try {
                        this.doTestEmptyCursor((BTreeCursor<Integer, String>)cursor);
                        this.doTestInsert((BTreeCursor<Integer, String>)cursor);
                    }
                    finally {
                        cursor.close();
                    }
                }
                btree = new BTree(option);
                try {
                    cursor = btree.createCursor();
                    try {
                        this.doTestPrev((BTreeCursor<Integer, String>)cursor);
                        this.doTestNext((BTreeCursor<Integer, String>)cursor);
                        this.doTestFirstLast((BTreeCursor<Integer, String>)cursor);
                        this.doTestMove((BTreeCursor<Integer, String>)cursor);
                    }
                    finally {
                        cursor.close();
                    }
                }
                finally {
                    btree.close();
                }
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void doTestNext(BTreeCursor<Integer, String> cursor) throws IOException {
        int rowCount = 0;
        BTreeCursorTest.assertTrue((boolean)cursor.isBeforeFirst());
        BTreeCursorTest.assertFalse((boolean)cursor.isAfterLast());
        while (cursor.next()) {
            ++rowCount;
        }
        BTreeCursorTest.assertTrue((boolean)cursor.isAfterLast());
        BTreeCursorTest.assertFalse((boolean)cursor.isBeforeFirst());
        BTreeCursorTest.assertEquals((int)rowCount, (int)10001);
    }

    public void doTestPrev(BTreeCursor<Integer, String> cursor) throws IOException {
        int rowCount = 0;
        cursor.last();
        cursor.next();
        BTreeCursorTest.assertTrue((boolean)cursor.isAfterLast());
        BTreeCursorTest.assertFalse((boolean)cursor.isBeforeFirst());
        while (cursor.previous()) {
            ++rowCount;
        }
        BTreeCursorTest.assertTrue((boolean)cursor.isBeforeFirst());
        BTreeCursorTest.assertFalse((boolean)cursor.isAfterLast());
        BTreeCursorTest.assertEquals((int)rowCount, (int)10001);
    }

    public void doTestFirstLast(BTreeCursor<Integer, String> cursor) throws IOException {
        int rowCount = 0;
        if (cursor.first()) {
            do {
                BTreeCursorTest.assertEquals((Object)new Integer(rowCount), (Object)cursor.getKey());
                ++rowCount;
            } while (cursor.next());
            BTreeCursorTest.assertTrue((boolean)cursor.isAfterLast());
            BTreeCursorTest.assertEquals((int)10001, (int)rowCount);
        }
        if (cursor.last()) {
            do {
                BTreeCursorTest.assertEquals((Object)new Integer(--rowCount), (Object)cursor.getKey());
            } while (cursor.previous());
            BTreeCursorTest.assertTrue((boolean)cursor.isBeforeFirst());
            BTreeCursorTest.assertEquals((int)0, (int)rowCount);
        }
    }

    public void doTestMove(BTreeCursor<Integer, String> cursor) throws IOException {
        BTreeCursorTest.assertTrue((boolean)cursor.moveTo((Object)6));
        BTreeCursorTest.assertEquals((Object)new Integer(6), (Object)cursor.getKey());
        BTreeCursorTest.assertFalse((boolean)cursor.moveTo((Object)10001));
        BTreeCursorTest.assertEquals((Object)new Integer(10000), (Object)cursor.getKey());
        BTreeCursorTest.assertFalse((boolean)cursor.moveTo((Object)-1));
        BTreeCursorTest.assertTrue((boolean)cursor.isBeforeFirst());
    }

    public void doTestEmptyCursor(BTreeCursor<Integer, String> cursor) throws IOException {
        BTreeCursorTest.assertTrue((boolean)cursor.isBeforeFirst());
        BTreeCursorTest.assertFalse((boolean)cursor.next());
        BTreeCursorTest.assertTrue((boolean)cursor.isAfterLast());
        BTreeCursorTest.assertFalse((boolean)cursor.previous());
        BTreeCursorTest.assertTrue((boolean)cursor.isBeforeFirst());
        BTreeCursorTest.assertFalse((boolean)cursor.moveTo((Object)3));
        BTreeCursorTest.assertTrue((boolean)cursor.isBeforeFirst());
    }

    protected void doTestInsert(BTreeCursor<Integer, String> cursor) throws IOException {
        cursor.insert((Object)10000, (Object)String.valueOf(10000));
        cursor.insert((Object)0, (Object)String.valueOf(0));
        int i = 9999;
        while (i >= 1) {
            cursor.insert((Object)new Integer(i), (Object)String.valueOf(i));
            BTreeCursorTest.assertEquals((String)String.valueOf(i), (String)((String)cursor.getValue()));
            --i;
        }
    }
}

