/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import org.eclipse.birt.core.fs.IFile;
import org.eclipse.birt.core.fs.LocalFile;

public class LocalFileTest
extends TestCase {
    private static final String TEST_FOLDER = "./utest/fs/testfiles/";

    protected void setUp() throws Exception {
        File folder = new File(TEST_FOLDER);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        new File("./utest/fs/testfiles/abc.txt").createNewFile();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetName() {
        LocalFileTest.assertEquals((String)"abc.txt", (String)new LocalFile(new File("./utest/fs/testfiles/abc.txt")).getName());
    }

    public void testGetPath() {
        String expectedPath = String.join((CharSequence)File.separator, ".", "utest", "fs", "testfiles", "abc.txt");
        LocalFileTest.assertEquals((String)expectedPath, (String)new LocalFile(new File("./utest/fs/testfiles/abc.txt")).getPath());
    }

    public void testIsDirectory() {
        LocalFileTest.assertEquals((boolean)true, (boolean)new LocalFile(new File(TEST_FOLDER)).isDirectory());
        LocalFileTest.assertEquals((boolean)false, (boolean)new LocalFile(new File("./utest/fs/testfiles//abc.txt")).isDirectory());
    }

    public void testExists() {
        LocalFileTest.assertEquals((boolean)true, (boolean)new LocalFile(new File("./utest/fs/testfiles//abc.txt")).exists());
        LocalFileTest.assertEquals((boolean)false, (boolean)new LocalFile(new File("./utest/fs/testfiles//abcd.txt")).exists());
    }

    public void testListFiles() {
        IFile[] files = new LocalFile(new File(TEST_FOLDER)).listFiles();
        LocalFileTest.assertEquals((int)1, (int)files.length);
        LocalFileTest.assertEquals((String)"abc.txt", (String)files[0].getName());
    }

    public void testIsAbsolute() {
        LocalFile file = new LocalFile(new File("./utest/fs/testfiles//abc.txt"));
        LocalFileTest.assertEquals((boolean)false, (boolean)file.isAbsolute());
        try {
            LocalFileTest.assertEquals((boolean)true, (boolean)new LocalFile(new File(file.toURL().toURI())).isAbsolute());
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void testGetParent() {
        LocalFileTest.assertEquals((String)"testfiles", (String)new LocalFile(new File("./utest/fs/testfiles//abc.txt")).getParent().getName());
    }

    public void testToURL() {
        LocalFile file = new LocalFile(new File("./utest/fs/testfiles//abc.txt"));
        try {
            LocalFileTest.assertEquals((boolean)true, (boolean)new LocalFile(new File(file.toURL().toURI())).isAbsolute());
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void testDelete() {
        try {
            File newFile = new File("./utest/fs/testfiles/ccc.txt");
            newFile.createNewFile();
            LocalFile newIFile = new LocalFile(newFile);
            LocalFileTest.assertEquals((boolean)true, (boolean)newIFile.exists());
            newIFile.delete();
            LocalFileTest.assertEquals((boolean)false, (boolean)newIFile.exists());
            newIFile = new LocalFile(new File("./utest/fs/testfiles/folder"));
            newIFile.mkdirs();
            new File("./utest/fs/testfiles/folder/abc.txt").createNewFile();
            new File("./utest/fs/testfiles/folder/abcd.txt").createNewFile();
            LocalFileTest.assertEquals((boolean)true, (boolean)newIFile.exists());
            newIFile.delete();
            LocalFileTest.assertEquals((boolean)false, (boolean)newIFile.exists());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testMkdirs() {
        LocalFile newIFile = new LocalFile(new File("./utest/fs/testfiles/folder"));
        try {
            LocalFileTest.assertEquals((boolean)true, (boolean)newIFile.mkdirs());
            LocalFileTest.assertEquals((boolean)true, (boolean)newIFile.exists());
            newIFile.delete();
            LocalFileTest.assertEquals((boolean)false, (boolean)newIFile.exists());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testCreateInputAndOutputStream() {
        String testText = "This is a test!";
        LocalFile file = new LocalFile(new File("./utest/fs/testfiles//abc.txt"));
        try {
            OutputStream os = file.createOutputStream();
            os.write(testText.getBytes());
            os.flush();
            os.close();
            InputStream is = file.createInputStream();
            byte[] content = new byte[256];
            int len = is.read(content);
            is.close();
            LocalFileTest.assertEquals((String)testText, (String)new String(content, 0, len));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

