/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.library;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.LibraryReloadedEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ReloadLibraryTest
extends BaseTestCase {
    public void testReloadLibrary() throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add("input/DesignToReloadLibrary.xml");
        fileNames.add("input/LibraryToReload.xml");
        List filePaths = this.dumpDesignAndLibrariesToFile(fileNames);
        String designFilePath = (String)filePaths.get(0);
        this.openDesign(designFilePath, false);
        NameSpace ns = this.designHandle.getModule().getNameHelper().getNameSpace("element");
        ReloadLibraryTest.assertEquals((int)7, (int)ns.getCount());
        TableHandle table1 = (TableHandle)this.designHandle.findElement("table1");
        LabelHandle label1 = (LabelHandle)this.designHandle.findElement("label1");
        ReloadLibraryTest.assertEquals((String)"red", (String)table1.getStringProperty("color"));
        ReloadLibraryTest.assertEquals((String)"red", (String)label1.getStringProperty("color"));
        ReloadLibraryTest.assertEquals((String)"red", (String)label1.getStringProperty("color"));
        TableHandle parent = (TableHandle)table1.getExtends();
        ReloadLibraryTest.assertNotNull((Object)parent);
        RowHandle rowHandle = (RowHandle)table1.getHeader().get(0);
        CellHandle cellHandle = (CellHandle)rowHandle.getCells().get(0);
        ReloadLibraryTest.assertEquals((String)cellHandle.getStringProperty("color"), (String)"blue");
        TableHandle table2 = (TableHandle)this.designHandle.findElement("table2");
        ReloadLibraryTest.assertNotNull((Object)table2.getExtends());
        ReloadLibraryTest.assertEquals((String)table2.getStringProperty("color"), (String)"lime");
        String libFilePath = (String)filePaths.get(1);
        this.openLibrary(libFilePath, false);
        TableHandle libTable1 = (TableHandle)this.libraryHandle.findElement("libTable1");
        ((ThemeHandle)this.libraryHandle.getThemes().get(0)).getStyles().drop(0);
        libTable1.getDetail().drop(0);
        libTable1.getDetail().drop(0);
        ReloadLibraryTest.assertEquals((int)0, (int)libTable1.getDetail().getCount());
        TableHandle libTable2 = (TableHandle)this.libraryHandle.findElement("libTable2");
        libTable2.drop();
        this.libraryHandle.save();
        MyLibraryListener libraryListener = new MyLibraryListener();
        this.designHandle.addListener((Listener)libraryListener);
        this.designHandle.reloadLibrary(this.libraryHandle);
        ReloadLibraryTest.assertEquals((int)1, (int)libraryListener.events.size());
        ReloadLibraryTest.assertTrue((boolean)(libraryListener.events.get(0) instanceof LibraryReloadedEvent));
        ReloadLibraryTest.assertEquals((int)3, (int)ns.getCount());
        ReloadLibraryTest.assertEquals((String)"black", (String)table1.getStringProperty("color"));
        ReloadLibraryTest.assertEquals((String)"black", (String)label1.getStringProperty("color"));
        ReloadLibraryTest.assertNull((Object)label1.getStyle());
        ReloadLibraryTest.assertEquals((String)"style1", (String)label1.getStringProperty("style"));
        ReloadLibraryTest.assertEquals((int)0, (int)table1.getDetail().getCount());
        ReloadLibraryTest.assertEquals((int)1, (int)table1.getHeader().getCount());
        ReloadLibraryTest.assertFalse((boolean)this.designHandle.getCommandStack().canRedo());
        ReloadLibraryTest.assertFalse((boolean)this.designHandle.getCommandStack().canUndo());
        this.save();
        ReloadLibraryTest.assertTrue((boolean)this.compareFile("DesignToReloadLibrary_golden.xml"));
    }

    public void testReloadLibraryWithInvalidExtends() throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add("input/DesignToReloadLibrary.xml");
        fileNames.add("input/LibraryToReload.xml");
        List filePaths = this.dumpDesignAndLibrariesToFile(fileNames);
        String designFilePath = (String)filePaths.get(0);
        this.openDesign(designFilePath, false);
        String libFilePath = (String)filePaths.get(1);
        this.openLibrary(libFilePath, false);
        this.libraryHandle.findElement("libTable2").drop();
        GridHandle grid = this.libraryHandle.getElementFactory().newGridItem("libTable2", 2, 2);
        this.libraryHandle.getComponents().add((DesignElementHandle)grid);
        this.libraryHandle.save();
        this.designHandle.reloadLibrary(this.libraryHandle);
        TableHandle table2 = (TableHandle)this.designHandle.findElement("table2");
        ReloadLibraryTest.assertNull((Object)table2.getExtends());
        ReloadLibraryTest.assertEquals((String)"Lib1.libTable2", (String)table2.getElement().getExtendsName());
    }

    public void testReloadLibraryWithException() throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add("input/DesignToReloadLibrary.xml");
        fileNames.add("input/LibraryToReload.xml");
        fileNames.add("input/Library_1.xml");
        List filePaths = this.dumpDesignAndLibrariesToFile(fileNames);
        String designFilePath = (String)filePaths.get(0);
        this.openDesign(designFilePath, false);
        String lib1FilePath = (String)filePaths.get(2);
        this.openLibrary(lib1FilePath, false);
        this.designHandle.reloadLibrary(this.libraryHandle);
        String libFilePath = (String)filePaths.get(1);
        this.openLibrary(libFilePath, false);
        File f = new File(libFilePath);
        if (f.exists()) {
            f.delete();
        }
        this.designHandle.reloadLibrary(this.libraryHandle);
        ReloadLibraryTest.assertNull((Object)this.designHandle.findElement("table1").getExtends());
        ReloadLibraryTest.assertNotNull((Object)this.designHandle.findElement("table1").getStringProperty("extends"));
        InputStream fis = this.getResourceAStream("input/LibraryToReload_errors.xml");
        FileOutputStream fos = new FileOutputStream(f);
        byte[] data = new byte[10000];
        fis.read(data);
        fos.write(data);
        fis.close();
        fos.close();
        this.designHandle.reloadLibrary(this.libraryHandle);
        this.save();
        ReloadLibraryTest.assertTrue((boolean)this.compareFile("DesignToReloadLibrary_golden_1.xml"));
    }

    public void testReloadLibrary1() throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add("input/DesignToReloadLibrary1.xml");
        fileNames.add("input/LibraryToReload1.xml");
        List filePaths = this.dumpDesignAndLibrariesToFile(fileNames);
        String designFilePath = (String)filePaths.get(0);
        this.openDesign(designFilePath, false);
        LabelHandle label1 = (LabelHandle)this.designHandle.findElement("label1");
        ReloadLibraryTest.assertEquals((String)"aaa", (String)label1.getText());
        String libFilePath = (String)filePaths.get(1);
        this.openLibrary(libFilePath, false);
        LabelHandle libLabel1 = (LabelHandle)this.libraryHandle.findElement("libLabel1");
        libLabel1.setText("bbb");
        libLabel1 = (LabelHandle)this.libraryHandle.findElement("libPageLabel1");
        libLabel1.setText("ccc");
        this.libraryHandle.save();
        this.designHandle.reloadLibrary(this.libraryHandle);
        this.libraryHandle = this.designHandle.getLibrary("Lib1");
        libLabel1 = (LabelHandle)this.libraryHandle.findElement("libLabel1");
        ReloadLibraryTest.assertEquals((String)"bbb", (String)libLabel1.getText());
        ReloadLibraryTest.assertEquals((String)"bbb", (String)label1.getText());
        SimpleMasterPageHandle page = (SimpleMasterPageHandle)this.designHandle.findMasterPage("My Page");
        ReloadLibraryTest.assertEquals((int)1, (int)page.getPageHeader().getCount());
        libLabel1 = (LabelHandle)page.getPageHeader().get(0);
        ReloadLibraryTest.assertEquals((String)"ccc", (String)libLabel1.getText());
    }

    public void testReloadLibrary2() throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add("input/DesignToReloadLibrary.xml");
        fileNames.add("input/LibraryToReload.xml");
        fileNames.add("/org/eclipse/birt/report/model/library/input/LibraryToReload.xml");
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(null);
        ReloadLibraryTest.assertNotNull((Object)this.sessionHandle);
        List filePaths = this.dumpDesignAndLibrariesToFile(fileNames);
        String apiFilePath = (String)filePaths.get(2);
        int lastSlash = apiFilePath.lastIndexOf("/");
        String apiFileDir = "";
        if (lastSlash != -1) {
            apiFileDir = apiFilePath.substring(0, lastSlash + 1);
        }
        this.sessionHandle.setResourceFolder(apiFileDir);
        String designFilePath = (String)filePaths.get(0);
        this.designHandle = this.sessionHandle.openDesign(designFilePath);
        this.libraryHandle = this.designHandle.getLibrary("Lib1");
        ReloadLibraryTest.assertNotNull((Object)this.libraryHandle);
        String location1 = this.libraryHandle.getModule().getLocation();
        this.sessionHandle.setResourceFolder(null);
        this.designHandle.reloadLibrary(this.libraryHandle);
        this.libraryHandle = this.designHandle.getLibrary("Lib1");
        ReloadLibraryTest.assertNotNull((Object)this.libraryHandle);
        String location2 = this.libraryHandle.getModule().getLocation();
        ReloadLibraryTest.assertFalse((boolean)location1.equalsIgnoreCase(location2));
    }

    public void testReloadLibrary3() throws Exception {
        this.openDesign("DesignWithCube.xml");
        this.designHandle.reloadLibraries();
        this.save();
        ReloadLibraryTest.assertTrue((boolean)this.compareFile("DesignWithCube_golden.xml"));
    }

    private List dumpDesignAndLibrariesToFile(List fileNames) throws Exception {
        ArrayList<String> filePaths = new ArrayList<String>();
        int i = 0;
        while (i < fileNames.size()) {
            String resourceName = (String)fileNames.get(i);
            filePaths.add(this.copyContentToFile(resourceName));
            ++i;
        }
        return filePaths;
    }

    public void testErrorLibraryNeedsSave() throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add("input/DesignWithSaveStateTest.xml");
        fileNames.add("input/LibraryWithSaveStateTest.xml");
        List filePaths = this.dumpDesignAndLibrariesToFile(fileNames);
        String designFilePath = (String)filePaths.get(0);
        this.openDesign(designFilePath, false);
        String libFilePath = (String)filePaths.get(1);
        this.openLibrary(libFilePath, false);
        LabelHandle labelHandle = this.designHandle.getElementFactory().newLabel("new test label");
        this.designHandle.getBody().add((DesignElementHandle)labelHandle);
        ReloadLibraryTest.assertTrue((boolean)this.designHandle.needsSave());
        ReloadLibraryTest.assertTrue((boolean)this.designHandle.getCommandStack().canUndo());
        ReloadLibraryTest.assertFalse((boolean)this.designHandle.getCommandStack().canRedo());
        ActivityStack stack = (ActivityStack)this.designHandle.getCommandStack();
        File f = new File(libFilePath);
        RandomAccessFile raf = new RandomAccessFile(f, "rw");
        raf.seek(906L);
        raf.writeBytes("<label name=\"NewLabel1\"/>");
        raf.close();
        try {
            this.designHandle.reloadLibrary(this.libraryHandle);
            ReloadLibraryTest.fail();
        }
        catch (DesignFileException designFileException) {
            // empty catch block
        }
        ReloadLibraryTest.assertTrue((boolean)stack.canUndo());
        ReloadLibraryTest.assertFalse((boolean)stack.canRedo());
        ReloadLibraryTest.assertEquals((int)1, (int)stack.getCurrentTransNo());
        ReloadLibraryTest.assertTrue((boolean)this.designHandle.needsSave());
        this.libraryHandle.close();
        this.libraryHandle = null;
    }

    public void testReloadLibraryWithExtendedItem() throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add("input/DesignToReloadExtendedItem.xml");
        fileNames.add("input/LibraryWithExtendedItemToReload.xml");
        List filePaths = this.dumpDesignAndLibrariesToFile(fileNames);
        String designFilePath = (String)filePaths.get(0);
        this.openDesign(designFilePath, false);
        ExtendedItemHandle child = (ExtendedItemHandle)this.designHandle.findElement("child");
        ReloadLibraryTest.assertEquals((Object)new Integer(0), (Object)child.getProperty("xScale"));
        String libFilePath = (String)filePaths.get(1);
        this.openLibrary(libFilePath, false);
        ExtendedItemHandle parent = (ExtendedItemHandle)this.libraryHandle.findElement("parent");
        parent.setProperty("xScale", (Object)"3");
        this.libraryHandle.save();
        this.designHandle.reloadLibrary(this.libraryHandle);
        child.loadExtendedElement();
        ReloadLibraryTest.assertEquals((Object)new Integer(3), (Object)child.getProperty("xScale"));
    }

    public void testReloadWithOverideElementReference() throws Exception {
        this.openDesign("LibraryWithCubeTest.xml");
        DimensionHandle dimension = (DimensionHandle)this.designHandle.getElementByID(9L);
        ReloadLibraryTest.assertNotNull((Object)dimension.getDefaultHierarchy());
        ReloadLibraryTest.assertEquals((Object)dimension, (Object)dimension.getDefaultHierarchy().getContainer());
        this.designHandle.reloadLibraries();
        dimension = (DimensionHandle)this.designHandle.getElementByID(9L);
        ReloadLibraryTest.assertNotNull((Object)dimension.getDefaultHierarchy());
        ReloadLibraryTest.assertEquals((Object)dimension, (Object)dimension.getDefaultHierarchy().getContainer());
    }

    public void testReloadTableContainExtendedItem() throws Exception {
        this.openDesign("DesignWithExtendedItem.xml");
        this.designHandle.reloadLibraries();
        this.save();
        ReloadLibraryTest.assertTrue((boolean)this.compareFile("DesignWithExtendedItem_golden.xml"));
        this.openDesign("DesignWithExtendedItem_1.xml");
        this.designHandle.reloadLibraries();
        this.save();
        ReloadLibraryTest.assertTrue((boolean)this.compareFile("DesignWithExtendedItem_golden_1.xml"));
    }

    private static class MyLibraryListener
    implements Listener {
        List events = new ArrayList();

        private MyLibraryListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.events.add(ev);
        }
    }
}

