/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.CachedMetaData;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class CachedMetaDataParserTest
extends BaseTestCase {
    private static final String INPUT_FILE = "CachedMetaDataParserTest.xml";
    private static final String GOLDEN_FILE = "CachedMetaDataParserTest_golden.xml";
    private DataSetHandle dataSetHandle = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParserDesignFile() throws Exception {
        this.openDesign(INPUT_FILE);
        this.dataSetHandle = this.designHandle.findDataSet("firstDataSet");
        assert (this.dataSetHandle != null);
        this.parser();
    }

    public void testWriterDesignFile() throws Exception {
        this.openDesign(INPUT_FILE);
        this.dataSetHandle = this.designHandle.findDataSet("firstDataSet");
        assert (this.dataSetHandle != null);
        this.writer();
    }

    private void parser() {
        CachedMetaDataHandle metadataHandle = this.dataSetHandle.getCachedMetaDataHandle();
        CachedMetaDataParserTest.assertNotNull((Object)metadataHandle);
        MemberHandle inputParameterHandle = metadataHandle.getParameters();
        CachedMetaDataParserTest.assertEquals((int)4, (int)inputParameterHandle.getListValue().size());
        MemberHandle resultSetHandle = metadataHandle.getResultSet();
        CachedMetaDataParserTest.assertEquals((int)2, (int)resultSetHandle.getListValue().size());
    }

    private void writer() throws Exception {
        this.dataSetHandle.setCachedMetaData(null);
        CachedMetaDataHandle metadataHandle = this.dataSetHandle.getCachedMetaDataHandle();
        assert (metadataHandle == null);
        CachedMetaData metadata = StructureFactory.createCachedMetaData();
        metadataHandle = this.dataSetHandle.setCachedMetaData(metadata);
        assert (metadataHandle != null);
        MemberHandle paramHandle = metadataHandle.getParameters();
        DataSetParameter inputParam1 = new DataSetParameter();
        inputParam1.setName("inputParam1");
        inputParam1.setDataType("float");
        inputParam1.setPosition(new Integer(5));
        inputParam1.setAllowNull(true);
        paramHandle.addItem((IStructure)inputParam1);
        DataSetParameter outputParam1 = new DataSetParameter();
        outputParam1.setName("outputParam1");
        outputParam1.setDataType("integer");
        outputParam1.setPosition(new Integer(4));
        paramHandle.addItem((IStructure)outputParam1);
        MemberHandle resultSetHandle = metadataHandle.getResultSet();
        ResultSetColumn resultSet1 = new ResultSetColumn();
        resultSet1.setColumnName("student");
        resultSet1.setDataType("string");
        resultSet1.setPosition(new Integer(6));
        resultSetHandle.addItem((IStructure)resultSet1);
        this.save();
        this.compareFile(GOLDEN_FILE);
    }
}

