/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;

public class ParameterTest
extends EngineCase {
    static final String TEST_FOLDER = "./utest/";
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/run_task_design.xml";
    static final String BLANK_REPORT_DOCUMENT_RESOURCE = "org/eclipse/birt/report/engine/api/BlankReport.rptdocument";
    static final String BLANK_REPORT_DOCUMENT = "utest/BlankReport.rptdocument";
    static final String VIEW_DOCUMENT = "./utest/view.rptdocument";
    static final String REPORT_DESIGN = "utest/design.rptdesign";
    static final String REPORT_DOCUMENT = "./utest/reportdocument/";
    static final String REPORT_DOCUMENT_ZIP = "./utest/reportdocument.zip";
    static final String REPORT_DESIGN_RESOURCE1 = "org/eclipse/birt/report/engine/api/render_task_design.xml";
    static final String REPORT_DESIGN1 = "./utest/design.rptdesign";
    static final String REPORT_DOCUMENT1 = "./utest/reportdocument.folder/";

    public void setUp() throws Exception {
        super.setUp();
        this.removeFile(TEST_FOLDER);
        this.removeFile(REPORT_DOCUMENT_ZIP);
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
        this.copyResource(BLANK_REPORT_DOCUMENT_RESOURCE, BLANK_REPORT_DOCUMENT);
    }

    public void tearDown() throws Exception {
        this.removeFile(TEST_FOLDER);
        super.tearDown();
    }

    public void testRun() {
        try {
            IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
            IRunTask task = this.engine.createRunTask(report);
            task.setParameter("param1", (Object)1, "11");
            ParameterTest.assertEquals((Object)"11", (Object)task.getParameterDisplayText("param1"));
            task.setParameter("param2", (Object[])new String[]{"1", "2", "3"}, new String[]{"a", "b", "c"});
            task.run(BLANK_REPORT_DOCUMENT);
            task.close();
            IReportDocument doc = this.engine.openReportDocument(BLANK_REPORT_DOCUMENT);
            IRenderTask rtask = this.engine.createRenderTask(doc);
            Object displayText = rtask.getParameterDisplayText("param2");
            Object values = rtask.getParameterValue("param2");
            ParameterTest.assertTrue((boolean)(displayText instanceof String[]));
            ParameterTest.assertEquals((String)((String[])displayText)[2], (String)"c");
            ParameterTest.assertTrue((((Object[])values).length == 3 ? 1 : 0) != 0);
            rtask.close();
            doc.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ParameterTest.fail();
        }
    }
}

