/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.CubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeElementFactory;
import org.eclipse.birt.data.engine.olap.util.filter.DimensionFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IResultRow;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public class DimensionFilterProcessorTest {
    private Scriptable baseScope;
    private ICubeQueryDefinition cubeQuery;
    private ScriptContext cx;

    @Before
    public void dimensionFilterProcessorSetUp() {
        this.cx = new ScriptContext();
        this.baseScope = new ImporterTopLevel();
        this.cubeQuery = this.createCubeQueryDefinition();
    }

    @After
    public void dimensionFilterProcessorTearDown() {
        this.cx.close();
    }

    private ICubeQueryDefinition createCubeQueryDefinition() {
        ICubeQueryDefinition cubeQuery = new CubeElementFactory().createCubeQuery("cube1");
        IEdgeDefinition columnEdge = cubeQuery.createEdge(2);
        cubeQuery.createEdge(1);
        IDimensionDefinition dimension1 = columnEdge.createDimension("dim1");
        IHierarchyDefinition hier1 = dimension1.createHierarchy("hier1");
        hier1.createLevel("level1");
        return cubeQuery;
    }

    @Test
    public void testBasicFilter() throws DataException {
        ScriptExpression expr = new ScriptExpression("dimension[\"dim1\"][\"level1\"] * 2 + 2 == 6");
        CubeFilterDefinition cubeFilter = new CubeFilterDefinition((IBaseExpression)expr);
        DimensionFilterEvalHelper helper = new DimensionFilterEvalHelper(null, this.baseScope, this.cx, this.cubeQuery, (IFilterDefinition)cubeFilter);
        List resultRows = this.getResultRows1();
        int i = 0;
        while (i < resultRows.size()) {
            Assert.assertEquals((Object)(i == 2 ? 1 : 0), (Object)helper.evaluateFilter((IResultRow)resultRows.get(i)));
            ++i;
        }
        helper.close();
        try {
            i = 0;
            while (i < resultRows.size()) {
                Assert.assertEquals((Object)(i == 2 ? 1 : 0), (Object)helper.evaluateFilter((IResultRow)resultRows.get(i)));
                ++i;
            }
            Assert.fail((String)"should not arrive here");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicFilter1() throws DataException {
        ScriptExpression expr = new ScriptExpression("dimension[\"dim1\"][\"level1\"][\"attr1\"] * 2 + 2 == 6");
        CubeFilterDefinition cubeFilter = new CubeFilterDefinition((IBaseExpression)expr);
        DimensionFilterEvalHelper helper = new DimensionFilterEvalHelper(null, this.baseScope, this.cx, this.cubeQuery, (IFilterDefinition)cubeFilter);
        List resultRows = this.getResultRows1();
        int i = 0;
        while (i < resultRows.size()) {
            Assert.assertEquals((Object)(i == 2 ? 1 : 0), (Object)helper.evaluateFilter((IResultRow)resultRows.get(i)));
            ++i;
        }
    }

    @Test
    public void testBasicFilter3() {
        try {
            ScriptExpression expr = new ScriptExpression("dimension[\"dim1\"][\"level2\"][\"attr1\"] * 2 + 2 == 6");
            CubeFilterDefinition cubeFilter = new CubeFilterDefinition((IBaseExpression)expr);
            DimensionFilterEvalHelper helper = new DimensionFilterEvalHelper(null, this.baseScope, this.cx, this.cubeQuery, (IFilterDefinition)cubeFilter);
            List resultRows = this.getResultRows1();
            int i = 0;
            while (i < resultRows.size()) {
                Assert.assertEquals((Object)(i == 2 ? 1 : 0), (Object)helper.evaluateFilter((IResultRow)resultRows.get(i)));
                ++i;
            }
            Assert.fail((String)"Should not arrive here");
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    public List getResultRows1() {
        ArrayList<TempResultRow> result = new ArrayList<TempResultRow>();
        int i = 0;
        while (i < 5) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("dim1/level1", new Integer(i));
            map.put("dim1/level1/attr1", new Integer(i));
            result.add(new TempResultRow(map));
            ++i;
        }
        return result;
    }

    private class TempResultRow
    implements IResultRow {
        private Map nameValuePair;

        TempResultRow(Map nameValuePair) {
            this.nameValuePair = nameValuePair;
        }

        public Object getAggrValue(String aggrName) throws DataException {
            return null;
        }

        public Object getFieldValue(String name) throws DataException {
            String[] list = name.split("/");
            if (list.length >= 2 && list[list.length - 1].equals(list[list.length - 2])) {
                String test = name.substring(0, name.lastIndexOf("/"));
                Object x = this.nameValuePair.get(name.substring(0, name.lastIndexOf("/")));
                return this.nameValuePair.get(name.substring(0, name.lastIndexOf("/")));
            }
            return this.nameValuePair.get(name);
        }

        public boolean isTimeDimensionRow() {
            return false;
        }
    }
}

