/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.dataextraction.csv;

public class CSVUtil {
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final String QUOTE = "\"";

    public static String quoteCSVValue(String value, String sep) {
        boolean needQuote;
        if (value == null) {
            return null;
        }
        if (((String)value).length() == 0) {
            return "\"\"";
        }
        boolean bl = needQuote = ((String)(value = ((String)value).replace(QUOTE, "\"\""))).indexOf(sep) != -1 || ((String)value).indexOf(QUOTE) != -1 || ((String)value).indexOf(10) != -1 || ((String)value).startsWith(" ") || ((String)value).endsWith(" ") || ((String)value).startsWith("\t") || ((String)value).endsWith("\t");
        if (needQuote) {
            value = QUOTE + (String)value + QUOTE;
        }
        return value;
    }

    public static String makeCSVRow(String[] values, String sep, boolean addCR) {
        StringBuilder buf = new StringBuilder(values.length * 10);
        int i = 0;
        while (i < values.length) {
            String value;
            if (i > 0) {
                buf.append(sep);
            }
            if ((value = CSVUtil.quoteCSVValue(values[i], sep)) != null) {
                buf.append(value);
            }
            ++i;
        }
        if (addCR) {
            buf.append(CR);
        }
        buf.append(LF);
        return buf.toString();
    }
}

