/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor.buffermgr;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.executor.buffermgr.Cell;
import org.eclipse.birt.report.engine.executor.buffermgr.CellUtil;
import org.eclipse.birt.report.engine.executor.buffermgr.Row;
import org.eclipse.birt.report.engine.executor.buffermgr.Table;

public class TableTest
extends TestCase {
    public void testFixedLayout() throws Exception {
        this.executeTest("fixed");
    }

    public void testFloatLayout() throws Exception {
        this.executeTest("float");
    }

    public void testSpanLayout() throws Exception {
        this.executeTest("span");
    }

    public void testConflictLayout() throws Exception {
        this.executeTest("conflict");
    }

    public void testDropLayout() throws Exception {
        this.executeTest("drop");
    }

    public void testEmptyCellLayout() throws Exception {
        this.executeTest("empty");
    }

    void executeTest(String name) throws Exception {
        String sourceFile = "org/eclipse/birt/report/engine/executor/buffermgr/" + name + ".txt";
        String goldenFile = "org/eclipse/birt/report/engine/executor/buffermgr/" + name + ".golden";
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(sourceFile);
        Table table = this.createTable(in);
        TableTest.assertEquals((boolean)false, (boolean)table.hasDropCell());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.outputTable(table, out);
        byte[] output = out.toByteArray();
        byte[] golden = this.loadResource(goldenFile);
        TableTest.assertEquals((String)new String(golden).replaceAll("\\s", ""), (String)new String(output).replaceAll("\\s", ""));
    }

    byte[] loadResource(String name) throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(name);
        if (in != null) {
            int readSize;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            do {
                if ((readSize = in.read(buffer)) <= 0) continue;
                out.write(buffer, 0, readSize);
            } while (readSize != -1);
            return out.toByteArray();
        }
        return null;
    }

    Table createTable(InputStream in) throws IOException {
        Table table = new Table();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = reader.readLine();
        while (line != null) {
            String[] tokens;
            if (!line.startsWith("#") && (tokens = line.split(" ")) != null && tokens.length > 0) {
                if ("ROW".equals(tokens[0])) {
                    String rowName = tokens[1];
                    table.createRow((Object)rowName);
                } else if ("CELL".equals(tokens[0])) {
                    int colId = Integer.parseInt(tokens[1]);
                    int rowSpan = Integer.parseInt(tokens[2]);
                    int colSpan = Integer.parseInt(tokens[3]);
                    String cellName = tokens[4];
                    table.createCell(colId, rowSpan, colSpan, (Cell.Content)new CellContent(cellName));
                } else if ("BAND".equals(tokens[0])) {
                    int bandId = Integer.parseInt(tokens[1]);
                    table.resolveDropCells(bandId);
                }
            }
            line = reader.readLine();
        }
        return table;
    }

    void outputTable(Table table, OutputStream out) throws IOException {
        PrintWriter writer = new PrintWriter(out);
        int rowCount = table.getRowCount();
        int colCount = table.getColCount();
        int i = 0;
        while (i < rowCount) {
            Row row = table.getRow(i);
            writer.println("ROW " + String.valueOf(row.getContent()));
            int j = 0;
            while (j < colCount) {
                Cell cell = table.getCell(i, j);
                if (cell.getStatus() == 1) {
                    writer.println("CELL " + CellUtil.getColId((Cell)cell) + " " + CellUtil.getRowSpan((Cell)cell) + " " + CellUtil.getColSpan((Cell)cell) + " " + String.valueOf(CellUtil.getContent((Cell)cell)));
                } else if (cell.getStatus() == 0) {
                    writer.println("CELL " + j + " 1 1 EMPTY");
                }
                ++j;
            }
            ++i;
        }
        writer.flush();
    }

    class CellContent
    implements Cell.Content {
        String content;

        CellContent(String obj) {
            this.content = obj;
        }

        public boolean isEmpty() {
            return "NULL".equals(this.content);
        }

        public String toString() {
            return this.content;
        }

        public void reset() {
            this.content = null;
        }
    }
}

