/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.TooltipValueImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ui.ChartConfigurationBlock;
import org.eclipse.birt.chart.reportitem.ui.ChartMenuBuilder;
import org.eclipse.birt.chart.reportitem.ui.ChartReportItemBuilderImpl;
import org.eclipse.birt.chart.reportitem.ui.DesignerRepresentation;
import org.eclipse.birt.chart.reportitem.ui.DteAdapter;
import org.eclipse.birt.chart.reportitem.ui.ReportDataServiceProvider;
import org.eclipse.birt.chart.reportitem.ui.StandardChartDataSheet;
import org.eclipse.birt.chart.reportitem.ui.views.attributes.ChartPageGenerator;
import org.eclipse.birt.chart.ui.swt.ChartUIFactory;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartDataSheet;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartUIFactory;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IImageServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.ISectionHelper;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.extensions.IMenuBuilder;
import org.eclipse.birt.report.designer.ui.preferences.IStatusChangeListener;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.core.resources.IProject;

public class ChartReportItemUIFactory
extends ChartUIFactory {
    protected static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
    private static ChartReportItemUIFactory instance = new ChartReportItemUIFactory();
    protected ReportDataServiceProvider reportDataProvider = null;

    protected ChartReportItemUIFactory() {
    }

    public static ChartReportItemUIFactory instance() {
        return instance;
    }

    public static void initInstance(ChartReportItemUIFactory newInstance) {
        instance = newInstance;
    }

    public IChartDataSheet createDataSheet(ExtendedItemHandle handle, ReportDataServiceProvider dataProvider) {
        return new StandardChartDataSheet(handle, dataProvider);
    }

    public ChartWizardContext createWizardContext(Chart cm, IUIServiceProvider uiProvider, IImageServiceProvider imageProvider, IDataServiceProvider dataProvider, IChartDataSheet dataSheet) {
        return new ChartWizardContext(cm, uiProvider, imageProvider, dataProvider, dataSheet, (IChartUIFactory)this);
    }

    public DteAdapter createDteAdapter() {
        return new DteAdapter();
    }

    public ChartReportItemBuilderImpl createReportItemBuilder(String taskId) {
        return new ChartReportItemBuilderImpl(taskId);
    }

    public IMenuBuilder createMenuBuilder() {
        return new ChartMenuBuilder();
    }

    public ISectionHelper updateChartPageSectionHelper(ISectionHelper sectionHelper) {
        return sectionHelper;
    }

    public ReportDataServiceProvider createReportDataServiceProvider(ExtendedItemHandle extendedHandle) {
        return new ReportDataServiceProvider(extendedHandle);
    }

    public DesignerRepresentation createFigure(ChartReportItemImpl crii) {
        return new DesignerRepresentation(crii);
    }

    public ChartConfigurationBlock createChartConfigurationBlock(IStatusChangeListener context, IProject project) {
        return new ChartConfigurationBlock(context, project);
    }

    public AbstractFilterHandleProvider getFilterProvider(Object handle, ReportDataServiceProvider dataServiceProvider) {
        AbstractFilterHandleProvider baseProvider = (AbstractFilterHandleProvider)AbstractFilterHandleProvider.class.cast(ElementAdapterManager.getAdapter((Object)((Object)new ChartPageGenerator()), AbstractFilterHandleProvider.class));
        if (baseProvider == null) {
            baseProvider = new FilterHandleProvider();
        }
        return baseProvider;
    }

    public ExtendedItemHandle createChartViewHandle(DesignElementHandle host) throws ExtendedElementException {
        ChartWithAxes cm = ChartWithAxesImpl.createDefault();
        cm.setType("Bar Chart");
        cm.setSubType("Side-by-side");
        SeriesDefinition sdBase = SeriesDefinitionImpl.createDefault();
        Series series = SeriesImpl.createDefault();
        sdBase.getSeries().add((Object)series);
        cm.getBaseAxes()[0].getSeriesDefinitions().add((Object)sdBase);
        SeriesDefinition sdOrth = SeriesDefinitionImpl.createDefault();
        series = BarSeriesImpl.createDefault();
        Action a = ActionImpl.create((ActionType)ActionType.SHOW_TOOLTIP_LITERAL, (ActionValue)TooltipValueImpl.create((int)200, (String)""));
        Trigger e = TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEOVER_LITERAL, (Action)a);
        series.getTriggers().add((Object)e);
        sdOrth.getSeries().add((Object)series);
        cm.getOrthogonalAxes(cm.getBaseAxes()[0], true)[0].getSeriesDefinitions().add((Object)sdOrth);
        ChartUIUtil.setSeriesName((Chart)cm);
        SampleData sampleData = DataFactory.eINSTANCE.createSampleData();
        sampleData.getBaseSampleData().clear();
        sampleData.getOrthogonalSampleData().clear();
        BaseSampleData sampleDataBase = DataFactory.eINSTANCE.createBaseSampleData();
        sampleDataBase.setDataSetRepresentation("A, B, C");
        sampleData.getBaseSampleData().add((Object)sampleDataBase);
        OrthogonalSampleData sampleDataOrth = DataFactory.eINSTANCE.createOrthogonalSampleData();
        sampleDataOrth.setDataSetRepresentation("5,4,12");
        sampleDataOrth.setSeriesDefinitionIndex(0);
        sampleData.getOrthogonalSampleData().add((Object)sampleDataOrth);
        cm.setSampleData(sampleData);
        String name = ReportPlugin.getDefault().getCustomName("Chart");
        ExtendedItemHandle itemHandle = host.getElementFactory().newExtendedItem(name, "Chart");
        itemHandle.getReportItem().setProperty("chart.instance", (Object)cm);
        return itemHandle;
    }
}

