/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import com.ibm.icu.util.Calendar;
import java.io.IOException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.binding.APITestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import testutil.ConfigText;

public class GroupOnRowTest
extends APITestCase {
    private Calendar calendar = Calendar.getInstance();

    @Before
    public void groupOnRowSetUp() throws Exception {
        this.calendar = Calendar.getInstance();
        this.calendar.clear();
    }

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData2.TableName"), ConfigText.getString("Api.TestData2.TableSQL"), ConfigText.getString("Api.TestData2.TestDataFileName"));
    }

    @Test
    public void testValidateInterval() {
        QueryDefinition qd = this.populateNumericGroupQueryDefinition(-1, 0.0);
        try {
            this.executeQuery((IQueryDefinition)qd);
            Assert.fail((String)"should catch invalid interval type exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        qd = this.populateNumericGroupQueryDefinition(100, 0.0);
        try {
            this.executeQuery((IQueryDefinition)qd);
            Assert.fail((String)"should catch (interval type)/(data type) mismatch exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        qd = this.populateNumericGroupQueryDefinition(5, 0.0);
        try {
            this.executeQuery((IQueryDefinition)qd);
            Assert.fail((String)"should catch (interval type)/(data type) mismatch exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testValidateIntervalRange() {
        QueryDefinition qd = this.populateNumericGroupQueryDefinition(99, -1.0);
        try {
            this.executeQuery((IQueryDefinition)qd);
            Assert.fail((String)"should catch invalid interval range exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGroupOnRowKeyCount0() throws Exception {
        this.groupOnRowKeyCount(0.0);
    }

    @Test
    public void testGroupOnRowKeyCount1() throws Exception {
        this.groupOnRowKeyCount(1.0);
    }

    @Test
    public void testGroupOnRowKeyCount3() throws Exception {
        this.groupOnRowKeyCount(3.0);
    }

    private void groupOnRowKeyCount(double intervalRange) throws Exception, IOException {
        String[] bindingNameGroup = new String[]{"GROUP_NUMBER"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_NUMBER");
        groupDefn[0].setInterval(0);
        groupDefn[0].setIntervalRange(intervalRange);
        String[] bindingNameRow = new String[]{"ROW_ID", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"id", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        String outputStr = this.getOutputStrForGroupTest(30, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    private QueryDefinition populateNumericGroupQueryDefinition(int interval, double intervalRange) {
        String[] bindingNameGroup = new String[]{"GROUP_NUMBER"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID", 2)};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_NUMBER");
        groupDefn[0].setInterval(interval);
        groupDefn[0].setIntervalRange(intervalRange);
        String[] bindingNameRow = new String[]{"ROW_ID", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        try {
            return this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Test
    public void testGroupOnHour() throws Exception {
        this.calendar.set(2005, 0, 1);
        this.groupOnHour(this.calendar.getTime());
    }

    @Test
    public void testGroupOnHour1() throws Exception {
        this.groupOnHour(null);
    }

    private void groupOnHour(Object startValue) throws Exception, IOException {
        String[] bindingNameGroup = new String[]{"GROUP_DATE"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_DATE");
        groupDefn[0].setInterval(6);
        if (startValue != null) {
            groupDefn[0].setIntervalStart(startValue);
        }
        groupDefn[0].setIntervalRange(48.0);
        String[] bindingNameRow = new String[]{"ROW_DATE_FOR_GROUP", "ROW_ID", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP"), new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"date_for_group", "id", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        String outputStr = this.getOutputStrForGroupTest(30, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    @Test
    public void testGroupOnMinute() throws Exception {
        this.groupOnMinute("2005-01-01");
    }

    @Test
    public void testGroupOnMinute1() throws Exception {
        this.groupOnMinute(null);
    }

    private void groupOnMinute(Object startValue) throws Exception, IOException {
        String[] bindingNameGroup = new String[]{"GROUP_DATE"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_DATE");
        groupDefn[0].setInterval(7);
        if (startValue != null) {
            groupDefn[0].setIntervalStart(startValue);
        }
        groupDefn[0].setIntervalRange(4320.0);
        String[] bindingNameRow = new String[]{"ROW_DATE_FOR_GROUP", "ROW_ID", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP"), new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"date_for_group", "id", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        String outputStr = this.getOutputStrForGroupTest(30, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    @Test
    public void testGroupOnSecond() throws Exception {
        this.groupOnSecond("2005-01-01");
    }

    @Test
    public void testGroupOnSecond1() throws Exception {
        this.groupOnSecond(null);
    }

    private void groupOnSecond(Object startValue) throws Exception, IOException {
        String[] bindingNameGroup = new String[]{"GROUP_DATE"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_DATE");
        groupDefn[0].setInterval(8);
        if (startValue != null) {
            groupDefn[0].setIntervalStart(startValue);
        }
        groupDefn[0].setIntervalRange(259200.0);
        String[] bindingNameRow = new String[]{"ROW_DATE_FOR_GROUP", "ROW_ID", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP"), new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"date_for_group", "id", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        String outputStr = this.getOutputStrForGroupTest(30, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    @Test
    public void testSortOnKeyIndex() throws Exception {
        String[] bindingNameSort = new String[]{"SORT_AMOUNT2"};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT2")};
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
        sortDefn[0].setColumn("SORT_AMOUNT2");
        sortDefn[0].setSortDirection(1);
        String[] bindingNameRow = new String[]{"ROW_ID", "ROW_rowPosition", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        IResultIterator ri = this.executeQuery((IQueryDefinition)this.createQuery(null, null, null, bindingNameSort, bindingExprSort, sortDefn, null, null, null, bindingNameRow, bindingExprRow));
        int expectedLen = 15;
        Object metaData = "";
        metaData = (String)metaData + GroupOnRowTest.formatStr("ID", 15);
        metaData = (String)metaData + GroupOnRowTest.formatStr("_rowPosition", 15);
        metaData = (String)metaData + GroupOnRowTest.formatStr("AMOUNT1", 15);
        metaData = (String)metaData + GroupOnRowTest.formatStr("AMOUNT2", 15);
        this.testPrintln((String)metaData);
        while (ri.next()) {
            Object rowData = "";
            int j = 0;
            while (j < bindingNameRow.length) {
                String value = ri.getValue(bindingNameRow[j]).toString();
                rowData = (String)rowData + GroupOnRowTest.formatStr(value, 15);
                ++j;
            }
            this.testPrintln((String)rowData);
        }
        this.checkOutputFile();
    }

    @Test
    public void testGroupOnRowPosition() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_ID", "GROUP_0", "GROUP_AMOUNT1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.AMOUNT1")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1"), new GroupDefinition("group2"), new GroupDefinition("group3")};
        groupDefn[0].setKeyExpression("row.GROUP_ID");
        groupDefn[0].setInterval(99);
        groupDefn[0].setIntervalRange(5.0);
        groupDefn[0].setIntervalStart((Object)new Integer(8));
        groupDefn[1].setKeyExpression("row.GROUP_0");
        groupDefn[1].setInterval(99);
        groupDefn[1].setIntervalRange(3.0);
        groupDefn[1].setIntervalStart((Object)new Integer(0));
        groupDefn[2].setKeyExpression("row.GROUP_AMOUNT1");
        groupDefn[2].setInterval(99);
        groupDefn[2].setIntervalRange(11.0);
        groupDefn[2].setIntervalStart((Object)new Integer(80));
        String[] bindingNameRow = new String[]{"ROW_ID", "ROW_rowPosition", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"id", "_rowPosition", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        String outputStr = this.getOutputStrForGroupTest(15, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    @Test
    public void testGroupOnRowPosition2() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_ID", "GROUP_0", "GROUP_AMOUNT1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID"), new ScriptExpression("row[\"__rownum\"]"), new ScriptExpression("dataSetRow.AMOUNT1")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1"), new GroupDefinition("group2"), new GroupDefinition("group3")};
        groupDefn[0].setKeyExpression("row.GROUP_ID");
        groupDefn[0].setInterval(99);
        groupDefn[0].setIntervalRange(5.0);
        groupDefn[0].setIntervalStart((Object)new Integer(8));
        groupDefn[1].setKeyExpression("row.GROUP_0");
        groupDefn[1].setInterval(99);
        groupDefn[1].setIntervalRange(3.0);
        groupDefn[1].setIntervalStart((Object)new Integer(0));
        groupDefn[2].setKeyExpression("row.GROUP_AMOUNT1");
        groupDefn[2].setInterval(99);
        groupDefn[2].setIntervalRange(11.0);
        groupDefn[2].setIntervalStart((Object)new Integer(80));
        String[] bindingNameRow = new String[]{"ROW_ID", "ROW_rowPosition", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"id", "_rowPosition", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        String outputStr = this.getOutputStrForGroupTest(15, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    @Test
    public void testGroupOnRowPosition3() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_ID", "GROUP_AMOUNT1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1"), new GroupDefinition("group2"), new GroupDefinition("group3")};
        groupDefn[0].setKeyExpression("row.GROUP_ID");
        groupDefn[0].setInterval(99);
        groupDefn[0].setIntervalRange(5.0);
        groupDefn[0].setIntervalStart((Object)new Integer(8));
        groupDefn[1].setKeyExpression("row[\"__rownum\"]");
        groupDefn[1].setInterval(99);
        groupDefn[1].setIntervalRange(3.0);
        groupDefn[1].setIntervalStart((Object)new Integer(0));
        groupDefn[2].setKeyExpression("row.GROUP_AMOUNT1");
        groupDefn[2].setInterval(99);
        groupDefn[2].setIntervalRange(11.0);
        groupDefn[2].setIntervalStart((Object)new Integer(80));
        String[] bindingNameRow = new String[]{"ROW_ID", "ROW_rowPosition", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"id", "_rowPosition", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        String outputStr = this.getOutputStrForGroupTest(15, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    @Test
    public void testGroupOnRowPosition4() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_ID", "GROUP_0", "GROUP_AMOUNT1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID"), new ScriptExpression("row[\"__rownum\"]"), new ScriptExpression("dataSetRow.AMOUNT1")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1"), new GroupDefinition("group2"), new GroupDefinition("group3")};
        groupDefn[0].setKeyExpression("row.GROUP_ID");
        groupDefn[0].setInterval(99);
        groupDefn[0].setIntervalRange(5.0);
        groupDefn[0].setIntervalStart((Object)new Integer(8));
        groupDefn[1].setKeyExpression("row[\"__rownum\"]");
        groupDefn[1].setInterval(6);
        groupDefn[1].setIntervalRange(3.0);
        groupDefn[1].setIntervalStart((Object)new Integer(0));
        groupDefn[2].setKeyExpression("row.GROUP_AMOUNT1");
        groupDefn[2].setInterval(99);
        groupDefn[2].setIntervalRange(11.0);
        groupDefn[2].setIntervalStart((Object)new Integer(80));
        String[] bindingNameRow = new String[]{"ROW_ID", "ROW_rowPosition", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"id", "_rowPosition", "amount1", "amount2"};
        try {
            QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
            String outputStr = this.getOutputStrForGroupTest(15, qd, groupDefn.length, bindingNameRow, columnStr);
            this.testPrint(outputStr);
            this.checkOutputFile();
            Assert.fail((String)"exception expected!");
        }
        catch (BirtException be) {
            Assert.assertEquals((Object)be.getErrorCode(), (Object)"data.engine.group.interval");
        }
    }

    @Test
    public void testGroupOnRowPosition5() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_ID"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.__rownum");
        groupDefn[0].setInterval(99);
        groupDefn[0].setIntervalRange(5.0);
        String[] bindingNameRow = new String[]{"ROW_ID", "ROW_rowPosition", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"id", "_rowPosition", "amount1", "amount2"};
        try {
            QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
            String outputStr = this.getOutputStrForGroupTest(15, qd, groupDefn.length, bindingNameRow, columnStr);
            this.testPrint(outputStr);
            this.checkOutputFile();
        }
        catch (BirtException be) {
            Assert.assertEquals((Object)be.getErrorCode(), (Object)"data.engine.group.interval");
        }
    }

    @Test
    public void testGroupOnWeek() throws Exception {
        this.calendar.set(2005, 0, 1);
        this.groupOnWeek(this.calendar.getTime());
    }

    @Test
    public void testGroupOnWeek1() throws Exception {
        this.groupOnWeek(null);
    }

    @Test
    public void testGroupOnWeek2() throws Exception {
        this.groupOnWeek2(null);
    }

    private void groupOnWeek(Object startValue) throws Exception, IOException {
        String[] bindingNameGroup = new String[]{"GROUP_DATE"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_DATE");
        groupDefn[0].setInterval(4);
        if (startValue != null) {
            groupDefn[0].setIntervalStart(startValue);
        }
        groupDefn[0].setIntervalRange(2.0);
        String[] bindingNameRow = new String[]{"ROW_DATE_FOR_GROUP", "ROW_ID", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP"), new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"date_for_group", "id", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        String outputStr = this.getOutputStrForGroupTest(30, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    private void groupOnWeek2(Object startValue) throws Exception, IOException {
        String[] bindingNameGroup = new String[]{"GROUP_DATE"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_DATE");
        groupDefn[0].setInterval(4);
        if (startValue != null) {
            groupDefn[0].setIntervalStart(startValue);
        }
        groupDefn[0].setIntervalRange(2.0);
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("row.ROW_DATE_FOR_GROUP");
        sortDefn.setSortDirection(1);
        groupDefn[0].addSort(sortDefn);
        String[] bindingNameRow = new String[]{"ROW_DATE_FOR_GROUP", "ROW_ID", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP"), new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"date_for_group", "id", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        String outputStr = this.getOutputStrForGroupTest(30, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    @Test
    public void testGroupOnYear() throws Exception {
        this.calendar.set(2005, 0, 1);
        this.groupOnYear(this.calendar.getTime());
    }

    @Test
    public void testGroupOnYear1() throws Exception {
        this.groupOnYear(null);
    }

    private void groupOnYear(Object startValue) throws Exception, IOException {
        String[] bindingNameGroup = new String[]{"GROUP_DATE"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_DATE");
        groupDefn[0].setInterval(1);
        if (startValue != null) {
            groupDefn[0].setIntervalStart(startValue);
        }
        groupDefn[0].setIntervalRange(1.0);
        String[] bindingNameRow = new String[]{"ROW_DATE_FOR_GROUP", "ROW_ID", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP"), new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"date_for_group", "id", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        String outputStr = this.getOutputStrForGroupTest(30, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    @Test
    public void testGroupOnMonth() throws Exception {
        this.calendar.set(2005, 0, 1);
        this.groupOnMonth(this.calendar.getTime());
    }

    @Test
    public void testGroupOnMonthWithCache() throws Exception {
        this.calendar.set(2005, 0, 1);
        this.groupOnMonthWithCache(this.calendar.getTime());
    }

    @Test
    public void testGroupOnMonth1() throws Exception {
        this.groupOnMonth(null);
    }

    private void groupOnMonth(Object startValue) throws Exception, IOException {
        String[] bindingNameGroup = new String[]{"GROUP_DATE"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_DATE");
        groupDefn[0].setInterval(2);
        if (startValue != null) {
            groupDefn[0].setIntervalStart(startValue);
        }
        groupDefn[0].setIntervalRange(1.0);
        String[] bindingNameRow = new String[]{"ROW_DATE_FOR_GROUP", "ROW_ID", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP"), new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"date_for_group", "id", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        String outputStr = this.getOutputStrForGroupTest(30, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    private void groupOnMonthWithCache(Object startValue) throws Exception, IOException {
        String[] bindingNameGroup = new String[]{"GROUP_DATE"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_DATE");
        groupDefn[0].setInterval(2);
        if (startValue != null) {
            groupDefn[0].setIntervalStart(startValue);
        }
        groupDefn[0].setIntervalRange(1.0);
        String[] bindingNameRow = new String[]{"ROW_DATE_FOR_GROUP", "ROW_ID", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP"), new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"date_for_group", "id", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        qd.setCacheQueryResults(true);
        String outputStr = this.getOutputStrForGroupTestWithCache(30, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    @Test
    public void testGroupOnQuarter() throws Exception {
        this.calendar.set(2005, 2, 1);
        this.groupOnQuarter(this.calendar.getTime());
    }

    @Test
    public void testGroupOnQuarter1() throws Exception {
        this.groupOnQuarter(null);
    }

    private void groupOnQuarter(Object startValue) throws Exception, IOException {
        String[] bindingNameGroup = new String[]{"GROUP_DATE"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_QUARTER")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_DATE");
        groupDefn[0].setInterval(3);
        groupDefn[0].setIntervalRange(2.0);
        if (startValue != null) {
            groupDefn[0].setIntervalStart(startValue);
        }
        String[] bindingNameRow = new String[]{"ROW_DATE_FOR_QUARTER", "ROW_ID", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_QUARTER"), new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"date_for_quarter", "id", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        String outputStr = this.getOutputStrForGroupTest(40, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    private String getOutputStrForGroupTestWithCache(int expectedLen, QueryDefinition qd, int groupDefCount, String[] beArray, String[] columStr) throws Exception {
        StringBuffer sBuffer = new StringBuffer();
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)qd, this.getAppContext());
        IQueryResults queryResults = preparedQuery.execute(null);
        IResultIterator ri = queryResults.getResultIterator();
        String queryResultID = queryResults.getID();
        ri.close();
        qd.setQueryResultsID(queryResultID);
        preparedQuery = this.dataEngine.prepare((IQueryDefinition)qd, this.getAppContext());
        queryResults = preparedQuery.execute(null);
        ri = queryResults.getResultIterator();
        Object metaData = "";
        int i = 0;
        while (i < columStr.length) {
            metaData = (String)metaData + GroupOnRowTest.formatStr(columStr[i], expectedLen);
            ++i;
        }
        sBuffer.append((String)metaData);
        sBuffer.append("\n");
        int groupCount = groupDefCount;
        while (ri.next()) {
            Object rowData = "";
            int startLevel = ri.getStartingGroupLevel();
            if (startLevel <= groupCount) {
                if (startLevel == 0) {
                    startLevel = 1;
                }
                j = 0;
                while (j < startLevel - 1) {
                    rowData = (String)rowData + GroupOnRowTest.formatStr("", expectedLen);
                    ++j;
                }
                j = startLevel - 1;
                while (j < beArray.length) {
                    value = ri.getValue(beArray[j]) != null ? ri.getValue(beArray[j]).toString() : "null";
                    rowData = (String)rowData + GroupOnRowTest.formatStr(value, expectedLen);
                    ++j;
                }
            } else {
                j = 0;
                while (j < groupCount) {
                    rowData = (String)rowData + GroupOnRowTest.formatStr("", expectedLen);
                    ++j;
                }
                j = groupCount;
                while (j < beArray.length) {
                    value = ri.getValue(beArray[j]).toString();
                    rowData = (String)rowData + GroupOnRowTest.formatStr(value, expectedLen);
                    ++j;
                }
            }
            sBuffer.append((String)rowData);
            sBuffer.append("\n");
        }
        ri.close();
        return new String(sBuffer);
    }

    private String getOutputStrForGroupTest(int expectedLen, QueryDefinition qd, int groupDefCount, String[] beArray, String[] columStr) throws Exception {
        StringBuffer sBuffer = new StringBuffer();
        IResultIterator ri = this.executeQuery((IQueryDefinition)qd);
        Object metaData = "";
        int i = 0;
        while (i < columStr.length) {
            metaData = (String)metaData + GroupOnRowTest.formatStr(columStr[i], expectedLen);
            ++i;
        }
        sBuffer.append((String)metaData);
        sBuffer.append("\n");
        int groupCount = groupDefCount;
        while (ri.next()) {
            Object rowData = "";
            int startLevel = ri.getStartingGroupLevel();
            if (startLevel <= groupCount) {
                if (startLevel == 0) {
                    startLevel = 1;
                }
                j = 0;
                while (j < startLevel - 1) {
                    rowData = (String)rowData + GroupOnRowTest.formatStr("", expectedLen);
                    ++j;
                }
                j = startLevel - 1;
                while (j < beArray.length) {
                    value = ri.getValue(beArray[j]) != null ? ri.getValue(beArray[j]).toString() : "null";
                    rowData = (String)rowData + GroupOnRowTest.formatStr(value, expectedLen);
                    ++j;
                }
            } else {
                j = 0;
                while (j < groupCount) {
                    rowData = (String)rowData + GroupOnRowTest.formatStr("", expectedLen);
                    ++j;
                }
                j = groupCount;
                while (j < beArray.length) {
                    value = ri.getValue(beArray[j]).toString();
                    rowData = (String)rowData + GroupOnRowTest.formatStr(value, expectedLen);
                    ++j;
                }
            }
            sBuffer.append((String)rowData);
            sBuffer.append("\n");
        }
        return new String(sBuffer);
    }

    @Test
    public void testGroupOnDay() throws Exception {
        this.calendar.set(2005, 0, 1, 10, 0, 0);
        this.groupOnDay(this.calendar.getTime());
    }

    @Test
    public void testGroupOnDay1() throws Exception {
        this.groupOnDay(null);
    }

    @Test
    public void testGroupOnDayWithCache() throws Exception {
        this.groupOnDayWithCache(null);
    }

    private void groupOnDay(Object startValue) throws Exception, IOException {
        String[] bindingNameGroup = new String[]{"GROUP_DATE"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_DATE");
        groupDefn[0].setInterval(5);
        if (startValue != null) {
            groupDefn[0].setIntervalStart(startValue);
        }
        groupDefn[0].setIntervalRange(3.0);
        String[] bindingNameRow = new String[]{"ROW_DATE_FOR_GROUP", "ROW_ID", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP"), new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"date_for_group", "id", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        String outputStr = this.getOutputStrForGroupTest(30, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    private void groupOnDayWithCache(Object startValue) throws Exception, IOException {
        String[] bindingNameGroup = new String[]{"GROUP_DATE"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_DATE");
        groupDefn[0].setInterval(5);
        if (startValue != null) {
            groupDefn[0].setIntervalStart(startValue);
        }
        groupDefn[0].setIntervalRange(3.0);
        String[] bindingNameRow = new String[]{"ROW_DATE_FOR_GROUP", "ROW_ID", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.DATE_FOR_GROUP"), new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"date_for_group", "id", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        qd.setCacheQueryResults(true);
        String outputStr = this.getOutputStrForGroupTestWithCache(30, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    @Test
    public void testGroupOnNumber() throws Exception {
        this.groupOnNumber(new Integer(10), 3.0);
    }

    @Test
    public void testGroupOnNumber0() throws Exception {
        this.groupOnNumber(null, 0.0);
    }

    @Test
    public void testGroupOnNumber1() throws Exception {
        this.groupOnNumber(null, 3.0);
    }

    private void groupOnNumber(Object startValue, double intervalRange) throws Exception, IOException {
        String[] bindingNameGroup = new String[]{"GROUP_NUMBER"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_NUMBER");
        groupDefn[0].setInterval(99);
        if (startValue != null) {
            groupDefn[0].setIntervalStart(startValue);
        }
        groupDefn[0].setIntervalRange(intervalRange);
        String[] bindingNameRow = new String[]{"ROW_ID", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"id", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        String outputStr = this.getOutputStrForGroupTest(30, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    @Test
    public void testGroupOnString() throws Exception {
        this.groupOnString("13");
    }

    @Test
    public void testGroupOnString0() throws Exception {
        this.groupOnString(null, 0);
    }

    @Test
    public void testGroupOnString1() throws Exception {
        this.groupOnString(null);
    }

    @Test
    public void testGroupOnString2() throws Exception {
        this.groupOnString(null, 3);
    }

    private void groupOnString(Object startValue) throws IOException, Exception {
        this.groupOnString(startValue, 1);
    }

    private void groupOnString(Object startValue, int intervalRange) throws Exception, IOException {
        ComputedColumn computedColumn = new ComputedColumn("STR", "(row.ID==9)?\"\":((row.ID==8)?null:row.ID.toString())", 5);
        this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
        String[] bindingNameGroup = new String[]{"GROUP_STR"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.STR")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_STR");
        groupDefn[0].setInterval(100);
        if (startValue != null) {
            groupDefn[0].setIntervalStart(startValue);
        }
        groupDefn[0].setIntervalRange((double)intervalRange);
        String[] bindingNameRow = new String[]{"ROW_STR_FOR_GROUP", "ROW_ID", "ROW_AMOUT1", "ROW_AMOUT2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.STR"), new ScriptExpression("dataSetRow.ID"), new ScriptExpression("dataSetRow.AMOUNT1"), new ScriptExpression("dataSetRow.AMOUNT2")};
        String[] columnStr = new String[]{"Str", "ID", "amount1", "amount2"};
        QueryDefinition qd = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        String outputStr = this.getOutputStrForGroupTest(30, qd, groupDefn.length, bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
    }

    private static String formatStr(String inputStr, int length) {
        if (inputStr == null) {
            return null;
        }
        int inputLen = inputStr.length();
        if (inputLen >= length) {
            return inputStr;
        }
        int appendLen = length - inputLen;
        char[] appendChar = new char[appendLen];
        int i = 0;
        while (i < appendLen) {
            appendChar[i] = 32;
            ++i;
        }
        String result = inputStr + new String(appendChar);
        return result;
    }
}

