/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class CascadingParameterGroupTest
extends BaseTestCase {
    private static final String INPUT = "CascadingParameterGroupTest.xml";

    public void testGetPropertiesAndContents() throws DesignFileException {
        this.openDesign(INPUT);
        CascadingParameterGroupHandle groupHandle = this.getGroupHandle("Country-State-City");
        CascadingParameterGroupTest.assertEquals((String)"Group for Country-State-City", (String)groupHandle.getDisplayName());
        SlotHandle parameters = groupHandle.getParameters();
        CascadingParameterGroupTest.assertEquals((int)3, (int)parameters.getCount());
        ScalarParameterHandle p1 = (ScalarParameterHandle)parameters.get(0);
        CascadingParameterGroupTest.assertEquals((String)"dynamic", (String)p1.getValueType());
        CascadingParameterGroupTest.assertEquals((String)"Country", (String)p1.getName());
        CascadingParameterGroupTest.assertEquals((String)"ds1", (String)p1.getDataSetName());
        CascadingParameterGroupTest.assertEquals((String)"row[\"country\"]", (String)p1.getValueExpr());
        CascadingParameterGroupTest.assertEquals((String)"Enter country:", (String)p1.getLabelExpr());
    }

    private CascadingParameterGroupHandle getGroupHandle(String name) {
        SlotHandle parameters = this.designHandle.getParameters();
        int i = 0;
        while (i < parameters.getCount()) {
            DesignElementHandle elementHandle = parameters.get(i);
            if (elementHandle.getName().equals(name)) {
                return (CascadingParameterGroupHandle)elementHandle;
            }
            ++i;
        }
        return null;
    }
}

