/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.HideRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.HideRule;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.parser.ParserTestCase;

public class TableItemParseTest
extends ParserTestCase {
    String fileName = "TableItemParseTest.xml";
    String goldenFileName = "TableItemParseTest_golden.xml";
    String semanticCheckFileName = "TableItemParseTest_1.xml";
    String summaryFileName = "TableItemParseTest_2.xml";
    String summaryGoldenFileName = "TableItemParseTest_1_golden.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testReadVisibilityRules(RowHandle handle) throws Exception {
        Iterator rules = handle.visibilityRulesIterator();
        TableItemParseTest.assertNotNull((Object)rules);
        HideRuleHandle hideHandle = (HideRuleHandle)rules.next();
        TableItemParseTest.assertNotNull((Object)hideHandle);
        TableItemParseTest.assertEquals((String)"pdf", (String)hideHandle.getFormat());
        TableItemParseTest.assertEquals((String)"pdf, 10 people", (String)hideHandle.getExpression());
        hideHandle = (HideRuleHandle)rules.next();
        TableItemParseTest.assertNotNull((Object)hideHandle);
        TableItemParseTest.assertEquals((String)"all", (String)hideHandle.getFormat());
        TableItemParseTest.assertEquals((String)"excel, 10 people", (String)hideHandle.getExpression());
    }

    public void testParser() throws Exception {
        this.openDesign(this.fileName);
        this.save();
        TableHandle table = (TableHandle)this.designHandle.findElement("My table");
        TableItemParseTest.assertNotNull((Object)table);
        TableItemParseTest.assertEquals((String)"birt.js.myTableHandler", (String)table.getEventHandlerClass());
        TableItemParseTest.assertTrue((boolean)table.newHandlerOnEachEvent());
        TableItemParseTest.assertEquals((String)"create on the table", (String)table.getOnCreate());
        TableItemParseTest.assertEquals((String)"render on the table", (String)table.getOnRender());
        TableItemParseTest.assertEquals((String)"prepare on the table", (String)table.getOnPrepare());
        TableItemParseTest.assertFalse((boolean)table.repeatHeader());
        TableItemParseTest.assertEquals((String)"bluehero", (String)table.getCaption());
        TableItemParseTest.assertEquals((String)"blue he", (String)table.getCaptionKey());
        TableItemParseTest.assertEquals((String)"summary", (String)table.getSummary());
        TableItemParseTest.assertEquals((int)3, (int)table.getColumnCount());
        TableItemParseTest.assertEquals((String)"Table", (String)table.getTagType());
        TableItemParseTest.assertEquals((String)"English", (String)table.getLanguage());
        TableItemParseTest.assertEquals((int)1, (int)table.getOrder());
        Iterator sorts = table.sortsIterator();
        SortKeyHandle sortHandle = (SortKeyHandle)sorts.next();
        TableItemParseTest.assertEquals((String)"age", (String)sortHandle.getKey());
        TableItemParseTest.assertEquals((String)"asc", (String)sortHandle.getDirection());
        sortHandle = (SortKeyHandle)sorts.next();
        TableItemParseTest.assertEquals((String)"grade", (String)sortHandle.getKey());
        TableItemParseTest.assertEquals((String)"desc", (String)sortHandle.getDirection());
        TableItemParseTest.assertNull(sorts.next());
        Iterator filters = table.filtersIterator();
        FilterConditionHandle filterHandle = (FilterConditionHandle)filters.next();
        TableItemParseTest.assertEquals((String)"lt", (String)filterHandle.getOperator());
        TableItemParseTest.assertEquals((String)"filter expression", (String)filterHandle.getExpr());
        TableItemParseTest.assertEquals((String)"value1 expression", (String)filterHandle.getValue1());
        TableItemParseTest.assertEquals((String)"value2 expression", (String)filterHandle.getValue2());
        TableItemParseTest.assertFalse((boolean)table.isSortByGroups());
        SlotHandle headerSlot = table.getHeader();
        TableItemParseTest.assertNotNull((Object)headerSlot);
        RowHandle rowHandle = (RowHandle)headerSlot.get(0);
        TableItemParseTest.assertFalse((boolean)rowHandle.repeatable());
        this.testReadVisibilityRules(rowHandle);
        TableItemParseTest.assertEquals((int)1, (int)headerSlot.getCount());
        SlotHandle detailSlot = table.getDetail();
        TableItemParseTest.assertNotNull((Object)detailSlot);
        TableItemParseTest.assertEquals((int)1, (int)detailSlot.getCount());
        RowHandle row = (RowHandle)detailSlot.get(0);
        TableItemParseTest.assertTrue((boolean)row.suppressDuplicates());
        TableItemParseTest.assertEquals((String)"Row Bookmark", (String)row.getBookmark());
        TableItemParseTest.assertEquals((String)"Row Bookmark Display Name", (String)row.getBookmarkDisplayName());
        TableItemParseTest.assertEquals((String)"birt.js.myDetailRowHandler", (String)row.getEventHandlerClass());
        TableItemParseTest.assertTrue((boolean)row.newHandlerOnEachEvent());
        TableItemParseTest.assertEquals((String)"create on the row", (String)row.getOnCreate());
        TableItemParseTest.assertEquals((String)"render on the row", (String)row.getOnRender());
        TableItemParseTest.assertEquals((String)"prepare on the row", (String)row.getOnPrepare());
        TableItemParseTest.assertEquals((String)"TR", (String)row.getTagType());
        TableItemParseTest.assertEquals((String)"English", (String)row.getLanguage());
        SlotHandle headSlot = table.getHeader();
        RowHandle headRow = (RowHandle)headSlot.get(0);
        TableItemParseTest.assertEquals((String)"tr", (String)headRow.getTagType());
        ColumnHandle column = (ColumnHandle)table.getColumns().get(2);
        TableItemParseTest.assertTrue((boolean)column.getBooleanProperty("suppressDuplicates"));
        Iterator hideRules = column.visibilityRulesIterator();
        TableItemParseTest.assertTrue((boolean)hideRules.hasNext());
        HideRuleHandle hideRule = (HideRuleHandle)hideRules.next();
        TableItemParseTest.assertEquals((String)"viewer", (String)hideRule.getFormat());
        TableItemParseTest.assertEquals((String)"viewer, 10 people", (String)hideRule.getExpression());
        SlotHandle cells = row.getCells();
        TableItemParseTest.assertNotNull((Object)cells);
        TableItemParseTest.assertEquals((int)1, (int)cells.getCount());
        CellHandle cell = (CellHandle)cells.get(0);
        TableItemParseTest.assertEquals((String)"Cell Bookmark", (String)cell.getBookmark());
        TableItemParseTest.assertEquals((String)"Cell Bookmark Display Name", (String)cell.getBookmarkDisplayName());
        TableItemParseTest.assertEquals((String)"birt.js.myDetailCellHandler", (String)cell.getEventHandlerClass());
        TableItemParseTest.assertTrue((boolean)cell.newHandlerOnEachEvent());
        TableItemParseTest.assertEquals((String)"create on the cell", (String)cell.getOnCreate());
        TableItemParseTest.assertEquals((String)"render on the cell", (String)cell.getOnRender());
        TableItemParseTest.assertEquals((String)"prepare on the cell", (String)cell.getOnPrepare());
        SlotHandle groupSlot = table.getGroups();
        TableItemParseTest.assertNotNull((Object)groupSlot);
        TableItemParseTest.assertEquals((int)1, (int)groupSlot.getCount());
        TableGroupHandle group = (TableGroupHandle)groupSlot.get(0);
        TableItemParseTest.assertEquals((String)"week", (String)group.getInterval());
        TableItemParseTest.assertTrue((3.0 == group.getIntervalRange() ? 1 : 0) != 0);
        TableItemParseTest.assertEquals((String)"desc", (String)group.getSortDirection());
        TableItemParseTest.assertEquals((String)"[Country]", (String)group.getKeyExpr());
        TableItemParseTest.assertEquals((String)"toc Country", (String)group.getTOC().getExpression());
        TableItemParseTest.assertEquals((String)"acl expression test", (String)group.getACLExpression());
        TableItemParseTest.assertFalse((boolean)group.cascadeACL());
        TableItemParseTest.assertEquals((String)"Group Bookmark", (String)group.getBookmark());
        TableItemParseTest.assertEquals((String)"Group Bookmark Display Name", (String)group.getBookmarkDisplayName());
        TableItemParseTest.assertEquals((String)"birt.js.myGroup1Handler", (String)group.getEventHandlerClass());
        TableItemParseTest.assertTrue((boolean)group.newHandlerOnEachEvent());
        TableItemParseTest.assertEquals((String)"create on the group", (String)group.getOnCreate());
        TableItemParseTest.assertEquals((String)"render on the group", (String)group.getOnRender());
        TableItemParseTest.assertEquals((String)"prepare on the group", (String)group.getOnPrepare());
        sorts = group.sortsIterator();
        sortHandle = (SortKeyHandle)sorts.next();
        TableItemParseTest.assertEquals((String)"name", (String)sortHandle.getKey());
        TableItemParseTest.assertEquals((String)"asc", (String)sortHandle.getDirection());
        sortHandle = (SortKeyHandle)sorts.next();
        TableItemParseTest.assertEquals((String)"birthday", (String)sortHandle.getKey());
        TableItemParseTest.assertEquals((String)"desc", (String)sortHandle.getDirection());
        filters = group.filtersIterator();
        filterHandle = (FilterConditionHandle)filters.next();
        TableItemParseTest.assertEquals((String)"lt", (String)filterHandle.getOperator());
        TableItemParseTest.assertEquals((String)"filter expression", (String)filterHandle.getExpr());
        TableItemParseTest.assertEquals((String)"value1 expression", (String)filterHandle.getValue1());
        TableItemParseTest.assertEquals((String)"value2 expression", (String)filterHandle.getValue2());
        SlotHandle groupHeaderSlot = group.getHeader();
        TableItemParseTest.assertEquals((int)2, (int)groupHeaderSlot.getCount());
        SlotHandle groupFooterSlot = group.getFooter();
        TableItemParseTest.assertEquals((int)1, (int)groupFooterSlot.getCount());
        SlotHandle footerSlot = table.getFooter();
        TableItemParseTest.assertNotNull((Object)footerSlot);
        TableItemParseTest.assertEquals((int)1, (int)footerSlot.getCount());
        rowHandle = (RowHandle)footerSlot.get(0);
        TableItemParseTest.assertTrue((boolean)rowHandle.repeatable());
        table = (TableHandle)this.designHandle.findElement("componentsTable");
        TableItemParseTest.assertNotNull((Object)table);
        TableItemParseTest.assertEquals((String)"table", (String)table.getTagType());
        table = (TableHandle)this.designHandle.findElement("scratchpadTable");
        TableItemParseTest.assertNotNull((Object)table);
        table = (TableHandle)this.designHandle.findElement("freeformTable");
        TableItemParseTest.assertNotNull((Object)table);
        table = (TableHandle)this.designHandle.findElement("listHeaderTable");
        TableItemParseTest.assertNotNull((Object)table);
        table = (TableHandle)this.designHandle.findElement("listDetailTable");
        TableItemParseTest.assertNotNull((Object)table);
        table = (TableHandle)this.designHandle.findElement("listFooterTable");
        TableItemParseTest.assertNotNull((Object)table);
        table = (TableHandle)this.designHandle.findElement("listgroupHeaderTable");
        TableItemParseTest.assertNotNull((Object)table);
        table = (TableHandle)this.designHandle.findElement("listgroupFooterTable");
        TableItemParseTest.assertNotNull((Object)table);
    }

    public void testWriteVisibilityRules(RowHandle handle) throws Exception {
        Iterator rules = handle.visibilityRulesIterator();
        TableItemParseTest.assertNotNull((Object)rules);
        HideRuleHandle hideHandle = (HideRuleHandle)rules.next();
        TableItemParseTest.assertNotNull((Object)hideHandle);
        hideHandle.setFormat(null);
        hideHandle.setExpression("new rule 1");
        hideHandle = (HideRuleHandle)rules.next();
        TableItemParseTest.assertNotNull((Object)hideHandle);
        hideHandle.setFormat("reportlet");
        hideHandle.setExpression("new rule 2");
    }

    public void testWriter() throws Exception {
        this.openDesign(this.fileName);
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("My table");
        TableItemParseTest.assertNotNull((Object)tableHandle);
        tableHandle.setEventHandlerClass("birt.js.newTableHandler");
        tableHandle.setOnCreate("new create on table");
        tableHandle.setOnPrepare("new prepare on table");
        tableHandle.setOnRender("new render on table");
        tableHandle.setRepeatHeader(false);
        tableHandle.setCaption("new caption");
        tableHandle.setCaptionKey("new caption key");
        tableHandle.setSummary("new summary");
        tableHandle.setSortByGroups(true);
        tableHandle.setNewHandlerOnEachEvent(false);
        tableHandle.setTagType("Table");
        tableHandle.setLanguage("English");
        tableHandle.setOrder(1);
        ColumnHandle column = (ColumnHandle)tableHandle.getColumns().get(2);
        PropertyHandle propHandle = column.getPropertyHandle("visibility");
        propHandle.setValue(null);
        HideRule hideRule = StructureFactory.createHideRule();
        propHandle.addItem((IStructure)hideRule);
        hideRule.setFormat("reportlet");
        hideRule.setExpression("new expression of reportlet");
        SlotHandle groupSlot = tableHandle.getGroups();
        TableItemParseTest.assertNotNull((Object)groupSlot);
        TableItemParseTest.assertEquals((int)1, (int)groupSlot.getCount());
        RowHandle rowHandle = (RowHandle)tableHandle.getHeader().get(0);
        this.testWriteVisibilityRules(rowHandle);
        rowHandle = (RowHandle)tableHandle.getFooter().get(0);
        rowHandle.setRepeatable(false);
        TableGroupHandle group = (TableGroupHandle)groupSlot.get(0);
        group.setName("new group name");
        group.setInterval("day");
        group.setIntervalRange(99.0);
        group.setKeyExpr("new expression");
        group.setBookmark("group bookmark");
        group.setBookmarkDisplayName("group bookmark display name");
        group.getTOC().setExpression("new toc expression");
        group.setEventHandlerClass("birt.js.newGroup1Handler");
        group.setOnPrepare("new prepare on group");
        group.setOnCreate("new create on group");
        group.setOnRender("new render on group");
        group.setACLExpression("new acl expression test");
        group.setCascadeACL(true);
        SlotHandle detailSlot = tableHandle.getDetail();
        TableItemParseTest.assertNotNull((Object)detailSlot);
        TableItemParseTest.assertEquals((int)1, (int)detailSlot.getCount());
        RowHandle row = (RowHandle)detailSlot.get(0);
        row.setSuppressDuplicates(false);
        row.setEventHandlerClass("birt.js.newRowHandler");
        row.setOnCreate("new create on row");
        row.setOnPrepare("new prepare on row");
        row.setOnRender(null);
        row.setBookmark("row bookmark");
        row.setBookmarkDisplayName("row bookmark display name");
        row.setTagType("TR");
        row.setLanguage("English");
        SlotHandle cells = row.getCells();
        TableItemParseTest.assertNotNull((Object)cells);
        TableItemParseTest.assertEquals((int)1, (int)cells.getCount());
        CellHandle cell = (CellHandle)cells.get(0);
        cell.setEventHandlerClass("birt.js.newNewHandler");
        cell.setOnCreate(null);
        cell.setOnPrepare("new prepare on cell");
        cell.setOnRender("new render on cell");
        cell.setBookmark("cell bookmark");
        cell.setBookmarkDisplayName("cell bookmark display name");
        UserPropertyDefn prop = new UserPropertyDefn();
        prop.setName("hello");
        PropertyType typeDefn = MetaDataDictionary.getInstance().getPropertyType("string");
        prop.setType(typeDefn);
        cell.addUserPropertyDefn(prop);
        this.save();
        TableItemParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testSemanticCheck() throws Exception {
        this.openDesign(this.semanticCheckFileName);
        List errors = this.design.getErrorList();
        int i = 0;
        TableItemParseTest.assertEquals((int)8, (int)errors.size());
        ErrorDetail error = (ErrorDetail)errors.get(i++);
        TableItemParseTest.assertEquals((String)"First table", (String)error.getElement().getName());
        TableItemParseTest.assertEquals((String)"Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(i++);
        TableItemParseTest.assertEquals((String)"Second table", (String)error.getElement().getName());
        TableItemParseTest.assertEquals((String)"Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(i++);
        TableItemParseTest.assertEquals((String)"Forth table", (String)error.getElement().getName());
        TableItemParseTest.assertEquals((String)"Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(i++);
        TableItemParseTest.assertEquals((String)"Error.SemanticError.OVERLAPPING_CELLS", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(i++);
        TableItemParseTest.assertEquals((String)"Error.SemanticError.OVERLAPPING_CELLS", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(i++);
        TableItemParseTest.assertEquals((String)"Seventh table", (String)error.getElement().getName());
        TableItemParseTest.assertEquals((String)"Error.ContentException.INVALID_CONTEXT_CONTAINMENT", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(i++);
        TableItemParseTest.assertEquals((String)"First list", (String)error.getElement().getName());
        TableItemParseTest.assertEquals((String)"Error.SemanticError.MISSING_DATA_SET", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(i++);
        TableItemParseTest.assertEquals((String)"First inner table", (String)error.getElement().getName());
        TableItemParseTest.assertEquals((String)"Error.SemanticError.MISSING_DATA_SET", (String)error.getErrorCode());
    }

    public void testSummaryTable() throws Exception {
        this.openDesign(this.summaryFileName);
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("My table");
        TableItemParseTest.assertTrue((boolean)tableHandle.isSummaryTable());
        tableHandle.setIsSummaryTable(false);
        this.save();
        TableItemParseTest.assertTrue((boolean)this.compareFile(this.summaryGoldenFileName));
    }

    public void testHideRuleFormatCompatibility() throws Exception {
        this.openDesign("TableItemParseTest_3.xml");
        List errors = this.design.getAllErrors();
        TableItemParseTest.assertTrue((!errors.isEmpty() ? 1 : 0) != 0);
        TableItemParseTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)((ErrorDetail)errors.get(0)).getErrorCode());
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("My table");
        RowHandle rowHandle = (RowHandle)tableHandle.getHeader().get(0);
        Iterator rules = rowHandle.visibilityRulesIterator();
        TableItemParseTest.assertNotNull((Object)rules);
        HideRuleHandle handle = (HideRuleHandle)rules.next();
        TableItemParseTest.assertEquals((String)"my/format", (String)handle.getFormat());
        handle = (HideRuleHandle)rules.next();
        TableItemParseTest.assertEquals((String)"all", (String)handle.getFormat());
        try {
            handle.setFormat("wrong foramt");
            TableItemParseTest.fail();
        }
        catch (SemanticException e) {
            TableItemParseTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }
}

