/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutTest;
import org.eclipse.birt.report.engine.layout.pdf.TestRunAndRenderTask;
import org.eclipse.birt.report.engine.nLayout.area.impl.CellArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.PageArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.RowArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableArea;

public class PDFTextLMTest
extends PDFLayoutTest {
    public void testHyphenation() throws EngineException {
        String designFile = "org/eclipse/birt/report/engine/layout/pdf/181578.xml";
        try {
            IReportRunnable report = this.openReportDesign(designFile);
            ArrayList pageAreas = new ArrayList();
            PDFLayoutTest.PageMonitor monitor = new PDFLayoutTest.PageMonitor(pageAreas);
            TestRunAndRenderTask runAndRenderTask = new TestRunAndRenderTask(this.engine, report, monitor);
            runAndRenderTask.setLocale(Locale.CHINA);
            runAndRenderTask.setRenderOption((IRenderOption)this.createRenderOption());
            runAndRenderTask.run();
            runAndRenderTask.close();
        }
        catch (Throwable t) {
            System.out.println(t);
            PDFTextLMTest.assertTrue((boolean)false);
        }
        PDFTextLMTest.assertTrue((boolean)true);
    }

    public void testTextWrap() throws EngineException {
        String designFile = "org/eclipse/birt/report/engine/layout/pdf/textWrap.xml";
        IReportRunnable report = this.openReportDesign(designFile);
        List pageAreas = this.getPageAreas(report);
        PDFTextLMTest.assertEquals((int)1, (int)pageAreas.size());
        PageArea pageArea = (PageArea)pageAreas.get(0);
        ContainerArea body = (ContainerArea)pageArea.getBody();
        Iterator iter = body.getChildren();
        TableArea table = (TableArea)iter.next();
        iter = table.getChildren();
        RowArea row = (RowArea)iter.next();
        iter = row.getChildren();
        CellArea cell = (CellArea)iter.next();
        Iterator it = cell.getChildren();
        ContainerArea container = (ContainerArea)it.next();
        PDFTextLMTest.assertTrue((container.getChildrenCount() == 1 ? 1 : 0) != 0);
        cell = (CellArea)iter.next();
        it = cell.getChildren();
        container = (ContainerArea)it.next();
        PDFTextLMTest.assertTrue((container.getChildrenCount() == 2 ? 1 : 0) != 0);
        cell = (CellArea)iter.next();
        it = cell.getChildren();
        container = (ContainerArea)it.next();
        PDFTextLMTest.assertTrue((container.getChildrenCount() == 2 ? 1 : 0) != 0);
    }
}

