/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.metadata.AbstractMetaTest;
import org.eclipse.birt.report.model.metadata.ArgumentInfo;
import org.eclipse.birt.report.model.metadata.ArgumentInfoList;
import org.eclipse.birt.report.model.metadata.MemberInfo;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MethodInfo;

public class ClassDefnTest
extends AbstractMetaTest {
    public void testParseRomDef() throws MetaDataParserException {
        this.loadMetaData(ClassDefnTest.class.getResourceAsStream("input/ClassDefnTest.def"));
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IClassInfo classDefn = dd.getClass("MyClass");
        ClassDefnTest.assertNotNull((Object)classDefn);
        ClassDefnTest.assertEquals((String)"MyClass", (String)classDefn.getName());
        ClassDefnTest.assertEquals((String)"Class.MyClass", (String)classDefn.getDisplayNameKey());
        ClassDefnTest.assertEquals((String)"Class.MyClass.toolTip", (String)classDefn.getToolTipKey());
        ClassDefnTest.assertTrue((boolean)classDefn.isNative());
        IMethodInfo constructor = classDefn.getConstructor();
        ClassDefnTest.assertNotNull((Object)constructor);
        ClassDefnTest.assertEquals((String)"MyConstructor", (String)constructor.getName());
        ClassDefnTest.assertEquals((String)"Class.MyClass.Constructor", (String)constructor.getDisplayNameKey());
        ClassDefnTest.assertEquals((String)"Class.MyClass.Constructor.toolTip", (String)constructor.getToolTipKey());
        Iterator iter = constructor.argumentListIterator();
        ArgumentInfoList arg1 = (ArgumentInfoList)iter.next();
        iter = arg1.argumentsIterator();
        ArgumentInfo arg = (ArgumentInfo)iter.next();
        ClassDefnTest.assertNotNull((Object)arg);
        ClassDefnTest.assertFalse((boolean)iter.hasNext());
        ClassDefnTest.assertEquals((String)"pos", (String)arg.getName());
        ClassDefnTest.assertEquals((String)"Number", (String)arg.getType());
        ClassDefnTest.assertEquals((String)"Class.MyClass.Constructor.pos", (String)arg.getDisplayNameKey());
        List members = classDefn.getMembers();
        ClassDefnTest.assertEquals((int)2, (int)members.size());
        MemberInfo member = (MemberInfo)members.get(0);
        ClassDefnTest.assertEquals((String)"columnName", (String)member.getName());
        ClassDefnTest.assertEquals((String)"String", (String)member.getDataType());
        ClassDefnTest.assertEquals((String)"Class.MyClass.columnName", (String)member.getDisplayNameKey());
        ClassDefnTest.assertEquals((String)"Class.MyClass.columnName.toolTip", (String)member.getToolTipKey());
        member = (MemberInfo)members.get(1);
        ClassDefnTest.assertEquals((String)"columnType", (String)member.getName());
        ClassDefnTest.assertEquals((String)"String", (String)member.getDataType());
        ClassDefnTest.assertEquals((String)"Class.MyClass.columnType", (String)member.getDisplayNameKey());
        ClassDefnTest.assertEquals((String)"Class.MyClass.columnType.toolTip", (String)member.getToolTipKey());
        List methods = classDefn.getMethods();
        ClassDefnTest.assertEquals((int)2, (int)methods.size());
        MethodInfo method = (MethodInfo)methods.get(0);
        ClassDefnTest.assertEquals((String)"getColumnName", (String)method.getName());
        ClassDefnTest.assertEquals((String)"String", (String)method.getReturnType());
        ClassDefnTest.assertEquals((String)"Class.MyClass.getColumnName", (String)method.getDisplayNameKey());
        ClassDefnTest.assertEquals((String)"Class.MyClass.getColumnName.toolTip", (String)method.getToolTipKey());
        ClassDefnTest.assertFalse((boolean)method.isStatic());
        method = (MethodInfo)methods.get(1);
        ClassDefnTest.assertEquals((String)"addColumn", (String)method.getName());
        ClassDefnTest.assertEquals(null, (String)method.getReturnType());
        ClassDefnTest.assertEquals((String)"Class.MyClass.addColumn", (String)method.getDisplayNameKey());
        ClassDefnTest.assertEquals((String)"Class.MyClass.addColumn.toolTip", (String)method.getToolTipKey());
        ClassDefnTest.assertTrue((boolean)method.isStatic());
        iter = method.argumentListIterator();
        iter = ((ArgumentInfoList)iter.next()).argumentsIterator();
        ClassDefnTest.assertTrue((boolean)iter.hasNext());
        ClassDefnTest.assertTrue((boolean)iter.hasNext());
        classDefn = dd.getClass("MyClass1");
        ClassDefnTest.assertNotNull((Object)classDefn);
        ClassDefnTest.assertEquals((String)"MyClass1", (String)classDefn.getName());
        ClassDefnTest.assertEquals((String)"Class.MyClass1", (String)classDefn.getDisplayNameKey());
        ClassDefnTest.assertEquals((String)"Class.MyClass1.toolTip", (String)classDefn.getToolTipKey());
        ClassDefnTest.assertFalse((boolean)classDefn.isNative());
    }

    public void testOptionalArgument() {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IClassInfo classDefn = dd.getClass("String");
        ClassDefnTest.assertNotNull((Object)classDefn);
        IMethodInfo method = classDefn.getMethod("fromCharCode");
        Iterator iter1 = method.argumentListIterator();
        while (iter1.hasNext()) {
            ArgumentInfoList argumentList = (ArgumentInfoList)iter1.next();
            Iterator iter2 = argumentList.argumentsIterator();
            while (iter2.hasNext()) {
                ArgumentInfo argu = (ArgumentInfo)iter2.next();
                if (!"optionalArgument".equalsIgnoreCase(argu.getName())) continue;
                ClassDefnTest.assertEquals((String)"...", (String)argu.getDisplayName());
            }
        }
    }

    public void testMethodsWithDifferentArgumentLists() {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        ClassDefnTest.assertEquals((int)11, (int)dd.getClasses().size());
        IClassInfo classInfo = dd.getClass("Array");
        IMethodInfo constructor = classInfo.getConstructor();
        ClassDefnTest.assertNotNull((Object)constructor);
        Iterator argumentList = constructor.argumentListIterator();
        ClassDefnTest.assertTrue((boolean)argumentList.hasNext());
        Iterator arguments = ((ArgumentInfoList)argumentList.next()).argumentsIterator();
        ClassDefnTest.assertFalse((boolean)arguments.hasNext());
        arguments = ((ArgumentInfoList)argumentList.next()).argumentsIterator();
        ClassDefnTest.assertTrue((boolean)arguments.hasNext());
        arguments.next();
        ClassDefnTest.assertFalse((boolean)arguments.hasNext());
        arguments = ((ArgumentInfoList)argumentList.next()).argumentsIterator();
        ClassDefnTest.assertTrue((boolean)arguments.hasNext());
        arguments.next();
        ClassDefnTest.assertTrue((boolean)arguments.hasNext());
        arguments.next();
        ClassDefnTest.assertFalse((boolean)argumentList.hasNext());
        classInfo = dd.getClass("Total");
        IMethodInfo method = classInfo.getMethod("rank");
        argumentList = method.argumentListIterator();
        arguments = ((ArgumentInfoList)argumentList.next()).argumentsIterator();
        ClassDefnTest.assertTrue((boolean)arguments.hasNext());
        ArgumentInfo argument = (ArgumentInfo)arguments.next();
        ClassDefnTest.assertEquals((String)"boolean", (String)argument.getType());
        ClassDefnTest.assertFalse((boolean)arguments.hasNext());
        ClassDefnTest.assertFalse((boolean)argumentList.hasNext());
    }

    public void testClassesInRom() {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        if (dd.getClasses().size() == 0) {
            return;
        }
        ClassDefnTest.assertEquals((int)11, (int)dd.getClasses().size());
        IClassInfo classInfo = dd.getClass("String");
        ClassDefnTest.assertNotNull((Object)classInfo);
        ClassDefnTest.assertNotNull((Object)classInfo.getConstructor());
        ClassDefnTest.assertEquals((int)1, (int)classInfo.getMembers().size());
        ClassDefnTest.assertEquals((int)19, (int)classInfo.getMethods().size());
        classInfo = dd.getClass("Global");
        ClassDefnTest.assertNotNull((Object)classInfo);
        ClassDefnTest.assertNull((Object)classInfo.getConstructor());
        ClassDefnTest.assertEquals((int)3, (int)classInfo.getMembers().size());
        ClassDefnTest.assertEquals((int)11, (int)classInfo.getMethods().size());
        classInfo = dd.getClass("GlobalBirt");
        ClassDefnTest.assertNull((Object)classInfo);
        classInfo = dd.getClass("Array");
        ClassDefnTest.assertNotNull((Object)classInfo);
        ClassDefnTest.assertNotNull((Object)classInfo.getConstructor());
        ClassDefnTest.assertEquals((int)1, (int)classInfo.getMembers().size());
        ClassDefnTest.assertEquals((int)12, (int)classInfo.getMethods().size());
        classInfo = dd.getClass("Number");
        ClassDefnTest.assertNotNull((Object)classInfo);
        ClassDefnTest.assertNotNull((Object)classInfo.getConstructor());
        ClassDefnTest.assertEquals((int)5, (int)classInfo.getMembers().size());
        ClassDefnTest.assertEquals((int)6, (int)classInfo.getMethods().size());
        IMemberInfo memberInfo = classInfo.getMember("NaN");
        ClassDefnTest.assertTrue((boolean)memberInfo.isStatic());
        ClassDefnTest.assertNotNull((Object)dd.getClass("Date"));
        classInfo = dd.getClass("Date");
        ClassDefnTest.assertNotNull((Object)classInfo);
        ClassDefnTest.assertNotNull((Object)classInfo.getConstructor());
        ClassDefnTest.assertEquals((int)0, (int)classInfo.getMembers().size());
        ClassDefnTest.assertEquals((int)46, (int)classInfo.getMethods().size());
        ClassDefnTest.assertNotNull((Object)dd.getClass("Boolean"));
        classInfo = dd.getClass("Boolean");
        ClassDefnTest.assertNotNull((Object)classInfo);
        ClassDefnTest.assertNotNull((Object)classInfo.getConstructor());
        ClassDefnTest.assertEquals((int)0, (int)classInfo.getMembers().size());
        ClassDefnTest.assertEquals((int)2, (int)classInfo.getMethods().size());
        ClassDefnTest.assertTrue((boolean)classInfo.isNative());
        ClassDefnTest.assertNotNull((Object)dd.getClass("Math"));
        classInfo = dd.getClass("Math");
        ClassDefnTest.assertNotNull((Object)classInfo);
        ClassDefnTest.assertNull((Object)classInfo.getConstructor());
        ClassDefnTest.assertEquals((int)8, (int)classInfo.getMembers().size());
        ClassDefnTest.assertEquals((int)18, (int)classInfo.getMethods().size());
        classInfo = dd.getClass("Object");
        ClassDefnTest.assertNotNull((Object)classInfo);
        ClassDefnTest.assertNotNull((Object)classInfo.getConstructor());
        ClassDefnTest.assertEquals((int)0, (int)classInfo.getMembers().size());
        ClassDefnTest.assertEquals((int)6, (int)classInfo.getMethods().size());
        ClassDefnTest.assertNotNull((Object)dd.getClass("RegExp"));
        classInfo = dd.getClass("RegExp");
        ClassDefnTest.assertNotNull((Object)classInfo);
        ClassDefnTest.assertNotNull((Object)classInfo.getConstructor());
        ClassDefnTest.assertEquals((int)4, (int)classInfo.getMembers().size());
        ClassDefnTest.assertEquals((int)3, (int)classInfo.getMethods().size());
        ClassDefnTest.assertNotNull((Object)dd.getClass("JSON"));
        classInfo = dd.getClass("JSON");
        ClassDefnTest.assertNotNull((Object)classInfo);
        ClassDefnTest.assertNull((Object)classInfo.getConstructor());
        ClassDefnTest.assertEquals((int)2, (int)classInfo.getMethods().size());
    }
}

