/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.File;
import java.nio.file.FileSystems;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.tests.engine.EngineCase;
import org.eclipse.birt.report.tests.engine.api.EngineResourceLocator;

public class ResourceLocatorTest
extends EngineCase {
    private String root_path;
    private String path;
    private String separator = FileSystems.getDefault().getSeparator();

    public ResourceLocatorTest(String name) {
        super(name);
    }

    public static Test Suite() {
        return new TestSuite(ResourceLocatorTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT("resources/aa.jpg", "resources/aa.jpg");
        this.copyResource_INPUT("resources/resource_a.properties", "resources/resource_a.properties");
        this.copyResource_INPUT("resources/resource_library.rptlibrary", "resources/resource_library.rptlibrary");
        this.root_path = this.getFullQualifiedClassName() + this.separator;
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource();
    }

    public void testResourceImage() {
        this.path = "file://" + this.genInputFolder() + this.separator + "resources" + this.separator;
        EngineResourceLocator locator = new EngineResourceLocator(this.path);
        try {
            this.renderReport("resource_image", locator);
        }
        catch (BirtException e) {
            e.printStackTrace();
            ResourceLocatorTest.fail((String)"Failed to find image resource from custom resource locator");
        }
        File f = new File(this.genOutputFile("resource_image.html"));
        ResourceLocatorTest.assertTrue((String)"Failed render report from image resource", (boolean)f.exists());
    }

    public void testResourceProperties() {
        this.path = "file://" + this.genInputFolder() + this.separator + "resources" + this.separator;
        EngineResourceLocator locator = new EngineResourceLocator(this.path);
        try {
            this.renderReport("resource_properties", locator);
        }
        catch (BirtException e) {
            e.printStackTrace();
            ResourceLocatorTest.fail((String)"Failed to find library resource from custom resource locator");
        }
        File f = new File(this.genOutputFile("resource_properties.html"));
        ResourceLocatorTest.assertTrue((String)"Failed render report from properties resource", (boolean)f.exists());
    }

    public void testResourceLibrary() {
        this.path = "file://" + this.genInputFolder() + this.separator + "resources" + this.separator;
        EngineResourceLocator locator = new EngineResourceLocator(this.path);
        try {
            this.renderReport("resource_library", locator);
        }
        catch (BirtException e) {
            e.printStackTrace();
            ResourceLocatorTest.fail((String)"Failed to find properties resource from custom resource locator");
        }
        File f = new File(this.genOutputFile("resource_library.html"));
        ResourceLocatorTest.assertTrue((String)"Failed render report from library", (boolean)f.exists());
    }

    private void renderReport(String reportName, IResourceLocator locator) throws BirtException {
        String input = this.genInputFolder() + this.separator + reportName + ".rptdesign";
        this.copyResource_INPUT(reportName + ".rptdesign", reportName + ".rptdesign");
        String output = this.genOutputFile(reportName + ".html");
        EngineConfig config = new EngineConfig();
        config.setResourceLocator(locator);
        Platform.startup((PlatformConfig)new PlatformConfig());
        Object factory = Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
        IReportEngine engine_locator = ((IReportEngineFactory)factory).createReportEngine(config);
        IReportRunnable runnable = engine_locator.openReportDesign(input);
        IRunAndRenderTask rrTask = engine_locator.createRunAndRenderTask(runnable);
        HTMLRenderOption option = new HTMLRenderOption();
        option.setOutputFileName(output);
        option.setOutputFormat("html");
        rrTask.setRenderOption((IRenderOption)option);
        rrTask.setAppContext(new HashMap());
        rrTask.run();
        rrTask.close();
        engine_locator.destroy();
    }
}

