/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.IInlineStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;

public class InlineStackingLayout
extends ContainerLayout
implements IInlineStackingLayout {
    public InlineStackingLayout(LayoutEngineContext context, ContainerLayout parent, IContent content) {
        super(context, parent, content);
    }

    @Override
    protected void addToRoot(AbstractArea area) {
        this.currentContext.root.addChild(area);
        area.setAllocatedPosition(this.currentContext.currentIP + this.offsetX, this.currentContext.currentBP + this.offsetY);
        this.currentContext.currentIP += area.getAllocatedWidth();
        if (this.currentContext.currentIP + area.getAllocatedWidth() > this.currentContext.root.getContentWidth()) {
            this.currentContext.root.setNeedClip(true);
        } else if (this.currentContext.currentBP > this.currentContext.maxAvaHeight) {
            this.currentContext.root.setNeedClip(true);
        }
    }

    @Override
    protected void closeLayout(ContainerLayout.ContainerContext currentContext, int index, boolean finished) {
    }

    @Override
    protected void createRoot() {
    }

    protected void verticalAlign() {
        Iterator<IArea> iter = this.currentContext.root.getChildren();
        while (iter.hasNext()) {
            AbstractArea child = (AbstractArea)iter.next();
            IStyle childStyle = child.getStyle();
            String vAlign = childStyle.getVerticalAlign();
            if (childStyle == null) continue;
            int spacing = this.currentContext.root.getContentHeight() - child.getAllocatedHeight();
            if (spacing < 0) {
                spacing = 0;
            }
            if ("baseline".equalsIgnoreCase(vAlign)) {
                int lineHeight = this.parent.getLineHeight();
                if (lineHeight > 0) {
                    child.setPosition(child.getX(), child.getY() + this.getMaxBaseLine() - child.getBaseLine() + spacing / 2);
                    continue;
                }
                child.setPosition(child.getX(), child.getY() + this.getMaxBaseLine() - child.getBaseLine());
                continue;
            }
            if ("bottom".equalsIgnoreCase(vAlign)) {
                child.setPosition(child.getX(), child.getY() + spacing);
                continue;
            }
            if (!"middle".equalsIgnoreCase(vAlign)) continue;
            child.setPosition(child.getX(), child.getY() + spacing / 2);
        }
    }

    private int getMaxBaseLine() {
        int maxChildrenBaseLine = this.currentContext.root.getMaxChildrenBaseLine();
        if (maxChildrenBaseLine == 0) {
            int maxChildrenBaseLineBelow = 0;
            Iterator<IArea> iter = this.currentContext.root.getChildren();
            while (iter.hasNext()) {
                AbstractArea child = (AbstractArea)iter.next();
                maxChildrenBaseLine = Math.max(maxChildrenBaseLine, child.getBaseLine());
                maxChildrenBaseLineBelow = Math.max(maxChildrenBaseLineBelow, child.getAllocatedHeight() - child.getBaseLine());
            }
            this.currentContext.root.setContentHeight(Math.max(this.currentContext.root.getContentHeight(), maxChildrenBaseLine + maxChildrenBaseLineBelow));
            this.currentContext.root.setBaseLine(maxChildrenBaseLine);
            this.currentContext.root.setMaxChildrenBaseLine(maxChildrenBaseLine);
            this.currentContext.root.setMaxChildrenBaseLineBelow(maxChildrenBaseLineBelow);
        }
        return maxChildrenBaseLine;
    }

    @Override
    protected void initialize() {
    }

    @Override
    public boolean endLine() throws BirtException {
        return false;
    }

    @Override
    public int getMaxLineWidth() {
        return 0;
    }

    @Override
    public boolean isEmptyLine() {
        return false;
    }

    @Override
    public void setTextIndent(ITextContent textContent) {
    }
}

