/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes.providers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.LinkedDataSetAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.metadata.ChoiceSet;

public class ChoiceSetFactory {
    public static final String CHOICE_NONE = Messages.getString((String)"ChoiceSetFactory.choice.None");
    public static final String CHOICE_AUTO = Messages.getString((String)"ChoiceSetFactory.choice.Auto");

    @Deprecated
    public static IChoiceSet getDEChoiceSet(String property) {
        String unitKey = "units";
        if ("backgroundColor".equals(property)) {
            unitKey = "colors";
        } else if ("color".equals(property)) {
            unitKey = "colors";
        } else if ("fontSize".equals(property)) {
            unitKey = "fontSize";
        } else if ("fontFamily".equals(property)) {
            unitKey = "fontFamily";
        } else if ("contentType".equals(property)) {
            unitKey = "textContentType";
        } else if ("ui_border_style".equals(property)) {
            unitKey = "lineStyle";
        } else if ("ui_border_WIDTH".equals(property)) {
            unitKey = "lineWidth";
        } else if ("direction".equals(property)) {
            unitKey = "sortDirection";
        } else if ("operator".equals(property)) {
            unitKey = "filterOperator";
        } else if ("verticalAlign".equals(property)) {
            unitKey = "verticalAlign";
        } else if ("textAlign".equals(property)) {
            unitKey = "textAlign";
        } else if ("orientation".equals(property)) {
            unitKey = "pageOrientation";
        } else if ("type".equals(property)) {
            unitKey = "pageSize";
        } else if ("interval".equals(property)) {
            unitKey = "interval";
        } else if ("pageBreakBefore".equals(property)) {
            unitKey = "pageBreakBefore";
        } else if ("pageBreakAfter".equals(property)) {
            unitKey = "pageBreakAfter";
        } else if ("bidiTextDirection".equals(property)) {
            unitKey = "bidiDirection";
        }
        return DEUtil.getMetaDataDictionary().getChoiceSet(unitKey);
    }

    public static IChoiceSet getElementChoiceSet(String elementName, String property) {
        IElementPropertyDefn propertyDefn = DEUtil.getMetaDataDictionary().getElement(elementName).getProperty(property);
        return propertyDefn.getAllowedChoices();
    }

    public static IChoiceSet getDimensionChoiceSet(String elementName, String property) {
        IElementPropertyDefn propertyDefn = DEUtil.getMetaDataDictionary().getElement(elementName).getProperty(property);
        if (propertyDefn.getTypeCode() == 3) {
            return propertyDefn.getAllowedUnits();
        }
        return null;
    }

    public static IChoiceSet getStructChoiceSet(String structName, String property) {
        return ChoiceSetFactory.getStructChoiceSet(structName, property, false);
    }

    public static IChoiceSet getStructChoiceSet(String structName, String property, boolean removeNoSupportFilters) {
        IPropertyDefn propertyDefn = DEUtil.getMetaDataDictionary().getStructure(structName).findProperty(property);
        IChoiceSet cs = propertyDefn.getAllowedChoices();
        if (removeNoSupportFilters) {
            return ChoiceSetFactory.removeNoSupportedChoices(cs);
        }
        return cs;
    }

    private static IChoiceSet removeNoSupportedChoices(IChoiceSet cs) {
        if (cs == null) {
            return null;
        }
        ArrayList<String> notSupportedList = new ArrayList<String>();
        notSupportedList.add("top-n");
        notSupportedList.add("bottom-n");
        notSupportedList.add("top-percent");
        notSupportedList.add("bottom-percent");
        IChoice[] choiceList = cs.getChoices();
        ArrayList<IChoice> newChoiceList = new ArrayList<IChoice>();
        int i = 0;
        while (i < choiceList.length) {
            if (!notSupportedList.contains(choiceList[i].getName())) {
                newChoiceList.add(choiceList[i]);
            }
            ++i;
        }
        ChoiceSet newcs = new ChoiceSet(cs.getName());
        newcs.setChoices(newChoiceList.toArray(new IChoice[newChoiceList.size()]));
        return newcs;
    }

    public static String[] getDisplayNamefromChoiceSet(IChoiceSet choiceSet) {
        return ChoiceSetFactory.getDisplayNamefromChoiceSet(choiceSet, null);
    }

    public static String[] getDisplayNamefromChoiceSet(IChoiceSet choiceSet, Comparator comparator) {
        String[] displayNames = new String[]{};
        if (choiceSet == null) {
            return displayNames;
        }
        IChoice[] choices = choiceSet.getChoices(comparator);
        if (choices == null) {
            return displayNames;
        }
        displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getDisplayName();
            ++i;
        }
        return displayNames;
    }

    public static String[] getNamefromChoiceSet(IChoiceSet choiceSet) {
        String[] names = new String[]{};
        if (choiceSet == null) {
            return names;
        }
        IChoice[] choices = choiceSet.getChoices();
        if (choices == null) {
            return names;
        }
        names = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            names[i] = choices[i].getName();
            ++i;
        }
        return names;
    }

    public static String[] getPropertyDisplayNames(String elementName, String property) {
        IChoiceSet choiceSet = ChoiceSetFactory.getElementChoiceSet(elementName, property);
        return ChoiceSetFactory.getDisplayNamefromChoiceSet(choiceSet);
    }

    public static String getPropDisplayName(String elementName, String property, String value) {
        IChoiceSet set = ChoiceSetFactory.getElementChoiceSet(elementName, property);
        return ChoiceSetFactory.getDisplayNameFromChoiceSet(value, set);
    }

    public static String getStructDisplayName(String structName, String memberName, String value) {
        IChoiceSet set = ChoiceSetFactory.getStructChoiceSet(structName, memberName);
        return ChoiceSetFactory.getDisplayNameFromChoiceSet(value, set);
    }

    public static String getPropValue(String elementName, String property, String displayName) {
        IChoiceSet set = ChoiceSetFactory.getElementChoiceSet(elementName, property);
        return ChoiceSetFactory.getValueFromChoiceSet(displayName, set);
    }

    public static String getStructPropValue(String structName, String memberName, String displayName) {
        IChoiceSet set = ChoiceSetFactory.getStructChoiceSet(structName, memberName);
        return ChoiceSetFactory.getValueFromChoiceSet(displayName, set);
    }

    public static String getDisplayNameFromChoiceSet(String value, IChoiceSet set) {
        String name = value;
        if (set == null) {
            return name;
        }
        IChoice[] choices = set.getChoices();
        if (choices == null) {
            return name;
        }
        int i = 0;
        while (i < choices.length) {
            if (choices[i].getName().equals(value)) {
                return choices[i].getDisplayName();
            }
            ++i;
        }
        return name;
    }

    public static String getValueFromChoiceSet(String displayName, IChoiceSet set) {
        String value = displayName;
        if (set == null) {
            return value;
        }
        IChoice[] choices = set.getChoices();
        if (choices == null) {
            return value;
        }
        int i = 0;
        while (i < choices.length) {
            if (choices[i].getDisplayName().equals(displayName)) {
                return choices[i].getName();
            }
            ++i;
        }
        return value;
    }

    @Deprecated
    public static Object[] getChoiceSet(String property) {
        if ("dataSet".equals(property)) {
            return ChoiceSetFactory.getDataSets();
        }
        String unitKey = "units";
        if ("backgroundColor".equals(property)) {
            unitKey = "colors";
        } else if ("color".equals(property)) {
            unitKey = "colors";
        } else if ("fontSize".equals(property)) {
            unitKey = "fontSize";
        } else if ("fontFamily".equals(property)) {
            unitKey = "fontFamily";
        } else if ("contentType".equals(property)) {
            unitKey = "textContentType";
        } else if ("ui_border_style".equals(property)) {
            unitKey = "lineStyle";
        } else if ("ui_border_WIDTH".equals(property)) {
            unitKey = "lineWidth";
        } else if ("direction".equals(property)) {
            unitKey = "sortDirection";
        } else if ("operator".equals(property)) {
            unitKey = "filterOperator";
        } else if ("verticalAlign".equals(property)) {
            unitKey = "verticalAlign";
        } else if ("textAlign".equals(property)) {
            unitKey = "textAlign";
        } else if ("orientation".equals(property)) {
            unitKey = "pageOrientation";
        } else if ("type".equals(property)) {
            unitKey = "pageSize";
        } else if ("interval".equals(property)) {
            unitKey = "interval";
        } else if ("pageBreakBefore".equals(property)) {
            unitKey = "pageBreakBefore";
        } else if ("pageBreakAfter".equals(property)) {
            unitKey = "pageBreakAfter";
        } else if ("pageBreakInside".equals(property)) {
            unitKey = "pageBreakInside";
        }
        return ChoiceSetFactory.getUnitChoiceSet(unitKey);
    }

    private static Object[] getUnitChoiceSet(String unitKey) {
        ArrayList<IChoice> list = new ArrayList<IChoice>();
        IChoiceSet choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet(unitKey);
        if (choiceSet != null) {
            IChoice[] choices = choiceSet.getChoices();
            int i = 0;
            while (i < choices.length) {
                list.add(choices[i]);
                ++i;
            }
        }
        return list.toArray(new IChoice[0]);
    }

    public static String[] getDataSets() {
        ArrayList<String> list = new ArrayList<String>();
        ModuleHandle handle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        for (DataSetHandle DataSetHandle2 : handle.getVisibleDataSets()) {
            list.add(DataSetHandle2.getQualifiedName());
        }
        list.addAll(ChoiceSetFactory.getLinkedDataSetNames());
        return list.toArray(new String[0]);
    }

    public static List<String> getLinkedDataSetNames() {
        LinkedDataSetAdapter adapter = new LinkedDataSetAdapter();
        return adapter.getVisibleLinkedDataSets();
    }

    public static String[] getCubes() {
        ArrayList<String> list = new ArrayList<String>();
        ModuleHandle handle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        for (CubeHandle CubeHandle2 : handle.getVisibleCubes()) {
            list.add(CubeHandle2.getQualifiedName());
        }
        list.addAll(ChoiceSetFactory.getLinkedDataSetNames());
        return list.toArray(new String[0]);
    }

    public static String[] getMasterPages() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(CHOICE_NONE);
        ModuleHandle handle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        SlotHandle pages = handle.getMasterPages();
        if (pages != null) {
            for (ReportElementHandle elementHandle : pages) {
                list.add(elementHandle.getQualifiedName());
            }
        }
        return list.toArray(new String[0]);
    }

    public static String[] getStyles() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(CHOICE_NONE);
        Iterator iterator = DEUtil.getStyles();
        if (iterator != null) {
            while (iterator.hasNext()) {
                StyleHandle styleHandle = (StyleHandle)iterator.next();
                list.add(styleHandle.getName());
            }
        }
        return list.toArray(new String[0]);
    }

    public static String[] getThemes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(CHOICE_NONE);
        ModuleHandle handle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        Iterator iterator = handle.getVisibleThemes(1).iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                ReportElementHandle elementHandle = (ReportElementHandle)iterator.next();
                list.add(elementHandle.getQualifiedName());
            }
        }
        return list.toArray(new String[0]);
    }

    public static String[] getReportItemThemes(String type) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(CHOICE_NONE);
        ModuleHandle handle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        Iterator iterator = handle.getVisibleReportItemThemes(1, type).iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                ReportElementHandle elementHandle = (ReportElementHandle)iterator.next();
                list.add(elementHandle.getQualifiedName());
            }
        }
        return list.toArray(new String[0]);
    }

    public static String[] getDefaultFormatValue(String structName) {
        String[] formatValue = new String[2];
        IStructureDefn def = DEUtil.getMetaDataDictionary().getStructure(structName);
        formatValue[0] = (String)def.getMember("category").getDefault();
        formatValue[1] = (String)def.getMember("pattern").getDefault();
        return formatValue;
    }
}

