/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.CssSharedStyleHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ImportCssTest
extends BaseTestCase {
    private String cssFileName = "base.css";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sessionHandle = DesignEngine.newSession(null);
    }

    private CssStyleSheetHandle loadStyleSheet(String fileName, ModuleHandle module) throws Exception {
        fileName = "input/" + (String)fileName;
        InputStream is = this.getResourceAStream((String)fileName);
        return module.openCssStyleSheet(is);
    }

    private List<StyleHandle> getAllStyles(CssStyleSheetHandle styleSheet) {
        ArrayList<StyleHandle> selectedStyles = new ArrayList<StyleHandle>();
        Iterator iter1 = styleSheet.getStyleIterator();
        while (iter1.hasNext()) {
            selectedStyles.add((StyleHandle)iter1.next());
        }
        return selectedStyles;
    }

    public void testImportCssToDesign() throws Exception {
        this.createDesign();
        CssStyleSheetHandle styleSheet = this.loadStyleSheet(this.cssFileName, (ModuleHandle)this.designHandle);
        this.designHandle.importCssStyles(styleSheet, this.getAllStyles(styleSheet));
        ImportCssTest.assertEquals((int)0, (int)this.designHandle.getAllCssStyleSheets().size());
        Object obj = this.designHandle.getAllStyles().get(0);
        ImportCssTest.assertTrue((boolean)(obj instanceof SharedStyleHandle));
        ImportCssTest.assertFalse((boolean)(obj instanceof CssSharedStyleHandle));
        this.save();
        ImportCssTest.assertTrue((boolean)this.compareFile("ImportCssToDesign_golden.xml"));
    }

    public void testImportCssToLibraryWithoutDuplicate() throws Exception {
        this.libraryHandle = this.sessionHandle.createLibrary();
        CssStyleSheetHandle styleSheet = this.loadStyleSheet(this.cssFileName, (ModuleHandle)this.libraryHandle);
        this.libraryHandle.importCssStyles(styleSheet, this.getAllStyles(styleSheet));
        this.saveLibrary();
        ImportCssTest.assertTrue((boolean)this.compareFile("ImportCssToLibrary_golden.xml"));
        this.libraryHandle = this.sessionHandle.createLibrary();
        this.libraryHandle.getThemes().add((DesignElementHandle)this.libraryHandle.getElementFactory().newTheme("theme1"));
        styleSheet = this.loadStyleSheet(this.cssFileName, (ModuleHandle)this.libraryHandle);
        this.libraryHandle.importCssStyles(styleSheet, this.getAllStyles(styleSheet), "theme1");
        this.saveLibrary();
        ImportCssTest.assertTrue((boolean)this.compareFile("ImportCssToLibrary1_golden.xml"));
    }

    public void testImportCssToLibraryWithDuplicate() throws Exception {
        this.libraryHandle = this.sessionHandle.createLibrary();
        ThemeHandle theme1 = this.libraryHandle.getElementFactory().newTheme("theme1");
        this.libraryHandle.getThemes().add((DesignElementHandle)theme1);
        theme1.getStyles().add((DesignElementHandle)this.libraryHandle.getElementFactory().newStyle("table"));
        CssStyleSheetHandle styleSheet = this.loadStyleSheet(this.cssFileName, (ModuleHandle)this.libraryHandle);
        this.libraryHandle.importCssStyles(styleSheet, this.getAllStyles(styleSheet), "theme1");
        this.saveLibrary();
        ImportCssTest.assertTrue((boolean)this.compareFile("ImportCssToLibrary2_golden.xml"));
    }

    public void testContainerOfCssStyleSheet() throws Exception {
        this.openDesign("ImportCssReport.xml");
        CssStyleSheetHandle cssStyleSheetHandle = (CssStyleSheetHandle)this.designHandle.getTheme().getAllCssStyleSheets().get(0);
        SharedStyleHandle styleHandle = cssStyleSheetHandle.findStyle("table");
        ImportCssTest.assertTrue((boolean)(styleHandle instanceof CssSharedStyleHandle));
        CssSharedStyleHandle cssStyleHandle = (CssSharedStyleHandle)styleHandle;
        DesignElementHandle elementHandle = cssStyleHandle.getCssStyleSheetHandle().getContainerHandle();
        ImportCssTest.assertTrue((boolean)(elementHandle instanceof ThemeHandle));
    }

    public void testImportCssToLibraryWithoutThemeElement() throws Exception {
        this.openLibrary("ImportCssToLibrary3.xml", ULocale.ENGLISH);
        CssStyleSheetHandle styleSheet = this.loadStyleSheet(this.cssFileName, (ModuleHandle)this.libraryHandle);
        this.libraryHandle.importCssStyles(styleSheet, this.getAllStyles(styleSheet));
        this.saveLibrary();
        ImportCssTest.assertTrue((boolean)this.compareFile("ImportCssToLibrary3_golden.xml"));
        this.openLibrary("ImportCssToLibrary4.xml", ULocale.ENGLISH);
        styleSheet = this.loadStyleSheet(this.cssFileName, (ModuleHandle)this.libraryHandle);
        this.libraryHandle.importCssStyles(styleSheet, this.getAllStyles(styleSheet));
        this.saveLibrary();
        ImportCssTest.assertTrue((boolean)this.compareFile("ImportCssToLibrary4_golden.xml"));
    }
}

