/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.birt.data.engine.impl.util.DirectedGraph;
import org.eclipse.birt.data.engine.impl.util.DirectedGraphEdge;
import org.eclipse.birt.data.engine.impl.util.GraphNode;
import org.junit.Assert;
import org.junit.Test;

public class DirectedGraphTest {
    @Test
    public void testValidateCycle() {
        DirectedGraph graph = new DirectedGraph(this.toSet(new DirectedGraphEdge[]{this.createEdge("a", "b"), this.createEdge("a", "c")}));
        try {
            graph.validateCycle();
        }
        catch (DirectedGraph.CycleFoundException e) {
            Assert.fail((String)"Should not goes here");
        }
        GraphNode foundNode = null;
        graph = new DirectedGraph(this.toSet(new DirectedGraphEdge[]{this.createEdge("a", "b"), this.createEdge("a", "c"), this.createEdge("a", "a")}));
        try {
            graph.validateCycle();
        }
        catch (DirectedGraph.CycleFoundException e) {
            foundNode = e.getNode();
        }
        assert (foundNode != null && foundNode.getValue().equals("a"));
        foundNode = null;
        graph = new DirectedGraph(this.toSet(new DirectedGraphEdge[]{this.createEdge("a", "b"), this.createEdge("a", "c"), this.createEdge("a", "d"), this.createEdge("b", "d"), this.createEdge("b", "e"), this.createEdge("b", "f"), this.createEdge("d", "e"), this.createEdge("d", "f")}));
        try {
            graph.validateCycle();
        }
        catch (DirectedGraph.CycleFoundException e) {
            Assert.fail((String)"Should not goes here");
        }
        foundNode = null;
        graph = new DirectedGraph(this.toSet(new DirectedGraphEdge[]{this.createEdge("a", "b"), this.createEdge("a", "c"), this.createEdge("a", "d"), this.createEdge("b", "d"), this.createEdge("b", "e"), this.createEdge("b", "f"), this.createEdge("d", "e"), this.createEdge("d", "f"), this.createEdge("d", "a")}));
        try {
            graph.validateCycle();
        }
        catch (DirectedGraph.CycleFoundException e) {
            foundNode = e.getNode();
        }
        assert (foundNode != null && foundNode.getValue().equals("d"));
        foundNode = null;
        graph = new DirectedGraph(this.toSet(new DirectedGraphEdge[]{this.createEdge("a", "b"), this.createEdge("a", "c"), this.createEdge("a", "d"), this.createEdge("e", "a"), this.createEdge("e", "b"), this.createEdge("c", "d")}));
        try {
            graph.validateCycle();
        }
        catch (DirectedGraph.CycleFoundException e) {
            Assert.fail((String)"Should not goes here");
        }
        foundNode = null;
        graph = new DirectedGraph(this.toSet(new DirectedGraphEdge[]{this.createEdge("a", "b"), this.createEdge("a", "c"), this.createEdge("a", "d"), this.createEdge("e", "a"), this.createEdge("e", "b"), this.createEdge("c", "d"), this.createEdge("c", "e")}));
        try {
            graph.validateCycle();
        }
        catch (DirectedGraph.CycleFoundException e) {
            foundNode = e.getNode();
        }
        assert (foundNode != null && foundNode.getValue().equals("c"));
        foundNode = null;
        graph = new DirectedGraph(this.toSet(new DirectedGraphEdge[]{this.createEdge("a", "b"), this.createEdge("a", "c"), this.createEdge("b", "c"), this.createEdge("c", "d"), this.createEdge("d", "b")}));
        try {
            graph.validateCycle();
        }
        catch (DirectedGraph.CycleFoundException e) {
            foundNode = e.getNode();
        }
        assert (foundNode != null && foundNode.getValue().equals("d"));
    }

    @Test
    public void testFlattenNodesByDependency() throws Exception {
        GraphNode[] nodes;
        DirectedGraph graph = new DirectedGraph(this.toSet(new DirectedGraphEdge[]{this.createEdge("a", "b"), this.createEdge("a", "c")}));
        try {
            nodes = graph.flattenNodesByDependency();
            assert (nodes.length == 3);
            this.validateFlattened(nodes, graph);
        }
        catch (DirectedGraph.CycleFoundException e) {
            Assert.fail((String)"Shoule not goes here");
        }
        graph = new DirectedGraph(this.toSet(new DirectedGraphEdge[]{this.createEdge("a", "b"), this.createEdge("a", "c"), this.createEdge("a", "a")}));
        try {
            nodes = graph.flattenNodesByDependency();
            Assert.fail((String)"Should not goes here");
        }
        catch (DirectedGraph.CycleFoundException nodes2) {
            // empty catch block
        }
        graph = new DirectedGraph(this.toSet(new DirectedGraphEdge[]{this.createEdge("a", "b"), this.createEdge("a", "c"), this.createEdge("a", "d"), this.createEdge("b", "d"), this.createEdge("b", "e"), this.createEdge("b", "f"), this.createEdge("d", "e"), this.createEdge("d", "f")}));
        try {
            nodes = graph.flattenNodesByDependency();
            Assert.assertTrue((nodes.length == 6 ? 1 : 0) != 0);
            this.validateFlattened(nodes, graph);
        }
        catch (DirectedGraph.CycleFoundException e) {
            Assert.fail((String)"Should not goes here");
        }
        graph = new DirectedGraph(this.toSet(new DirectedGraphEdge[]{this.createEdge("a", "b"), this.createEdge("a", "c"), this.createEdge("a", "d"), this.createEdge("b", "d"), this.createEdge("b", "e"), this.createEdge("b", "f"), this.createEdge("d", "e"), this.createEdge("d", "f"), this.createEdge("d", "a")}));
        try {
            nodes = graph.flattenNodesByDependency();
            Assert.fail((String)"Should not goes here");
        }
        catch (DirectedGraph.CycleFoundException nodes3) {
            // empty catch block
        }
        graph = new DirectedGraph(this.toSet(new DirectedGraphEdge[]{this.createEdge("a", "b"), this.createEdge("a", "c"), this.createEdge("a", "d"), this.createEdge("e", "a"), this.createEdge("e", "b"), this.createEdge("c", "d")}));
        try {
            nodes = graph.flattenNodesByDependency();
            this.validateFlattened(nodes, graph);
        }
        catch (DirectedGraph.CycleFoundException nodes4) {
            // empty catch block
        }
        graph = new DirectedGraph(this.toSet(new DirectedGraphEdge[]{this.createEdge("a", "b"), this.createEdge("a", "c"), this.createEdge("a", "d"), this.createEdge("e", "a"), this.createEdge("e", "b"), this.createEdge("c", "d"), this.createEdge("c", "e")}));
        try {
            nodes = graph.flattenNodesByDependency();
            Assert.fail((String)"Should not goes here");
        }
        catch (DirectedGraph.CycleFoundException nodes5) {
            // empty catch block
        }
        graph = new DirectedGraph(this.toSet(new DirectedGraphEdge[]{this.createEdge("a", "b"), this.createEdge("a", "c"), this.createEdge("b", "c"), this.createEdge("c", "d"), this.createEdge("d", "b")}));
        try {
            nodes = graph.flattenNodesByDependency();
            Assert.fail((String)"Should not goes here");
        }
        catch (DirectedGraph.CycleFoundException cycleFoundException) {
            // empty catch block
        }
    }

    private DirectedGraphEdge createEdge(String from, String to) {
        return new DirectedGraphEdge(new GraphNode((Object)from), new GraphNode((Object)to));
    }

    private Set<DirectedGraphEdge> toSet(DirectedGraphEdge[] src) {
        return new HashSet<DirectedGraphEdge>(Arrays.asList(src));
    }

    private void validateFlattened(GraphNode[] nodes, DirectedGraph graph) throws Exception {
        int i = 0;
        while (i < nodes.length) {
            int j = i + 1;
            while (j < nodes.length) {
                if (graph.isDependOn(nodes[i], nodes[j])) {
                    throw new Exception(String.valueOf(nodes[i].getValue()) + "depends on " + String.valueOf(nodes[j].getValue()) + ", But its index( " + i + ") is before that dependency index(" + j + ")");
                }
                ++j;
            }
            ++i;
        }
    }
}

