/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import java.util.HashMap;
import org.eclipse.birt.report.designer.core.commands.CmdBaseTestCase;
import org.eclipse.birt.report.designer.core.commands.CreateCommand;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.SlotHandle;

public class CreateCommandTest
extends CmdBaseTestCase {
    public void testCreateFirstTableRow() {
        CreateCommandTest.assertEquals((int)0, (int)this.table.getDetail().getCount());
        this.createFirstRow();
        CreateCommandTest.assertEquals((Object)this.firstRow, (Object)this.table.getDetail().get(0));
    }

    public void testCreateSecondTableRow() {
        CreateCommandTest.assertTrue((boolean)this.adapter.getRows().isEmpty());
        this.createFirstRow();
        this.createSecondRow();
        CreateCommandTest.assertEquals((Object)this.secondRow, (Object)this.table.getDetail().get(0));
        CreateCommandTest.assertEquals((Object)this.firstRow, (Object)this.table.getDetail().get(1));
    }

    public void testCreateFirstCell() {
        CreateCommandTest.assertTrue((boolean)this.adapter.getRows().isEmpty());
        this.createFirstRow();
        this.createFirstCell();
        CreateCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(0));
    }

    public void testCreateSecondCell() {
        CreateCommandTest.assertTrue((boolean)this.adapter.getRows().isEmpty());
        this.createFirstRow();
        this.createFirstCell();
        this.createSecondCell();
        CreateCommandTest.assertEquals((Object)this.secondCell, (Object)this.firstRow.getCells().get(0));
        CreateCommandTest.assertEquals((Object)this.firstCell, (Object)this.firstRow.getCells().get(1));
    }

    public void testAddCell2Table() {
        CreateCommandTest.assertTrue((boolean)this.adapter.getRows().isEmpty());
        CellHandle cell = this.getElementFactory().newCell();
        HashMap<String, CellHandle> map = new HashMap<String, CellHandle>();
        map.put("newObject", cell);
        CreateCommand command = new CreateCommand(map);
        command.setParent((Object)this.table.getDetail());
        command.execute();
        CreateCommandTest.assertEquals((int)0, (int)this.table.getDetail().getCount());
    }

    public void testCreateDataItem() {
        this.createFirstRow();
        this.createFirstCell();
        this.addDataItems();
        CreateCommandTest.assertEquals((int)1, (int)this.firstCell.getContent().getCount());
        CreateCommandTest.assertEquals((Object)this.dataItem, (Object)this.firstCell.getContent().get(0));
    }

    public void testCreateFirstTableColumn() {
        CreateCommandTest.assertNull((Object)this.adapter.getColumn(1));
        this.createColumn();
        CreateCommandTest.assertNotNull((Object)this.adapter.getColumn(1));
        CreateCommandTest.assertEquals((Object)this.firstColumn, (Object)this.table.getColumns().get(0));
    }

    public void testCreateDataSource() {
        SlotHandle parent = this.getReportDesignHandle().getDataSources();
        CreateCommandTest.assertEquals((int)0, (int)parent.getCount());
        this.createDataSource();
        CreateCommandTest.assertEquals((int)1, (int)parent.getCount());
        CreateCommandTest.assertEquals((Object)this.dataSource, (Object)parent.get(0));
    }

    public void testCreateDataSourceWithSameName() {
        SlotHandle parent = this.getReportDesignHandle().getDataSources();
        CreateCommandTest.assertEquals((int)0, (int)parent.getCount());
        this.createDataSource();
        CreateCommandTest.assertEquals((int)1, (int)parent.getCount());
        OdaDataSourceHandle dataSource2 = this.getElementFactory().newOdaDataSource("Data Source");
        HashMap<String, OdaDataSourceHandle> map = new HashMap<String, OdaDataSourceHandle>();
        map.put("newObject", dataSource2);
        CreateCommand command = new CreateCommand(map);
        command.setParent((Object)parent);
        command.execute();
        CreateCommandTest.assertEquals((int)2, (int)parent.getCount());
        CreateCommandTest.assertEquals((Object)dataSource2, (Object)parent.get(1));
        CreateCommandTest.assertTrue((!dataSource2.getName().equals("Data Source") ? 1 : 0) != 0);
    }

    public void testCreateDataSet() {
        SlotHandle parent = this.getReportDesignHandle().getDataSets();
        CreateCommandTest.assertEquals((int)0, (int)parent.getCount());
        this.createDataSet();
        CreateCommandTest.assertEquals((int)1, (int)parent.getCount());
        CreateCommandTest.assertEquals((Object)this.dataSet, (Object)parent.get(0));
    }
}

