/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.JoinConditionHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class JointDataSetHandleTest
extends BaseTestCase {
    private String filename = "JointDataSetHandleTest.xml";
    private String filename1 = "JointDataSetHandleTest_1.xml";
    private String filename2 = "JointDataSetHandleTest_2.xml";

    public JointDataSetHandleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(JointDataSetHandleTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(this.filename, this.filename);
        this.copyResource_INPUT(this.filename1, this.filename1);
        this.copyResource_INPUT(this.filename2, this.filename2);
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public void testJointDataSetType() throws Exception {
        this.openDesign(this.filename1);
        JointDataSetHandle jointds1 = this.designHandle.findJointDataSet("jointds1");
        jointds1.addDataSet("ds1");
        jointds1.addDataSet("ds2");
        JointDataSetHandleTest.assertEquals((int)2, (int)jointds1.getListProperty("dataSets").size());
        JointDataSetHandle jointds2 = this.designHandle.findJointDataSet("jointds2");
        jointds2.addDataSet("ds1");
        jointds2.addDataSet("ds2");
        JointDataSetHandleTest.assertEquals((int)2, (int)jointds2.getListProperty("dataSets").size());
        JointDataSetHandle jointds3 = this.designHandle.findJointDataSet("jointds3");
        jointds3.addDataSet("ds1");
        JointDataSetHandleTest.assertEquals((int)1, (int)jointds3.getListProperty("dataSets").size());
    }

    public void testJointCondition() throws SemanticException, DesignFileException {
        this.openDesign(this.filename);
        JointDataSetHandle jointds = this.designHandle.findJointDataSet("JointDataSet");
        Iterator joinConditionsIterator = jointds.joinConditionsIterator();
        JoinConditionHandle joinConditionHandle = (JoinConditionHandle)joinConditionsIterator.next();
        joinConditionHandle.setJoinType("left-out");
        JointDataSetHandleTest.assertEquals((String)"left-out", (String)joinConditionHandle.getJoinType());
        String operator = "eq";
        joinConditionHandle.setOperator(operator);
        JointDataSetHandleTest.assertEquals((String)operator, (String)joinConditionHandle.getOperator());
        String leftDataSet = "ds1";
        joinConditionHandle.setLeftDataSet(leftDataSet);
        JointDataSetHandleTest.assertEquals((String)leftDataSet, (String)joinConditionHandle.getLeftDataSet());
        String rightDataSet = "ds2";
        joinConditionHandle.setRightDataSet(rightDataSet);
        JointDataSetHandleTest.assertEquals((String)rightDataSet, (String)joinConditionHandle.getRightDataSet());
        String leftExpression = "leftExpression";
        joinConditionHandle.setLeftExpression(leftExpression);
        JointDataSetHandleTest.assertEquals((String)leftExpression, (String)joinConditionHandle.getLeftExpression());
        String rightExpression = "rightExpression";
        joinConditionHandle.setRightExpression(rightExpression);
        JointDataSetHandleTest.assertEquals((String)rightExpression, (String)joinConditionHandle.getRightExpression());
    }

    public void testParameter() throws Exception {
        this.openDesign(this.filename2);
        JointDataSetHandle jointds = this.designHandle.findJointDataSet("jointds");
        DataSetHandle ds1 = this.designHandle.findDataSet("ds1");
        DataSetHandle ds2 = this.designHandle.findDataSet("ds2");
        DataSetParameterHandle param1 = (DataSetParameterHandle)ds1.parametersIterator().next();
        DataSetParameterHandle param2 = (DataSetParameterHandle)ds2.parametersIterator().next();
        jointds.addDataSet("ds1");
        jointds.addDataSet("ds2");
        JointDataSetHandleTest.assertFalse((boolean)jointds.paramBindingsIterator().hasNext());
        List list = jointds.getElement().getListProperty((Module)this.design, "dataSets");
        JointDataSetHandleTest.assertSame((Object)this.design.findDataSet("ds1"), (Object)((ElementRefValue)list.get(0)).getElement());
        JointDataSetHandleTest.assertSame((Object)this.design.findDataSet("ds2"), (Object)((ElementRefValue)list.get(1)).getElement());
        JointDataSetHandleTest.assertEquals((String)"param1", (String)param1.getName());
        JointDataSetHandleTest.assertEquals((String)"param1", (String)param2.getName());
    }

    public void testFilter() throws Exception {
        SessionHandle session = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = session.createDesign();
        ElementFactory factory = new ElementFactory(this.designHandle.getModule());
        StructureFactory structFactory = new StructureFactory();
        JointDataSetHandle jointds = factory.newJointDataSet("jointds");
        FilterCondition filter = StructureFactory.createFilterCond();
        filter.setExpr("row[\"abc\"]");
        filter.setOperator("between");
        filter.setValue1("a");
        filter.setValue2("b");
        JointDataSetHandleTest.assertEquals((String)"row[\"abc\"]", (String)filter.getExpr());
        JointDataSetHandleTest.assertEquals((String)"between", (String)filter.getOperator());
        JointDataSetHandleTest.assertEquals((String)"a", (String)filter.getValue1());
        JointDataSetHandleTest.assertEquals((String)"b", (String)filter.getValue2());
        PropertyHandle prophandle = jointds.getPropertyHandle("filter");
        prophandle.addItem((IStructure)filter);
    }
}

