/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.text;

import org.openpdf.text.Chunk;
import org.openpdf.text.Element;
import org.openpdf.text.FontFactory;
import org.openpdf.text.List;
import org.openpdf.text.ListItem;

public class ZapfDingbatsList
extends List {
    protected int zn;

    public ZapfDingbatsList(int zn) {
        super(true);
        this.zn = zn;
        float fontsize = this.symbol.getFont().getSize();
        this.symbol.setFont(FontFactory.getFont("ZapfDingbats", fontsize, 0));
        this.postSymbol = " ";
    }

    public ZapfDingbatsList(int zn, int symbolIndent) {
        super(true, symbolIndent);
        this.zn = zn;
        float fontsize = this.symbol.getFont().getSize();
        this.symbol.setFont(FontFactory.getFont("ZapfDingbats", fontsize, 0));
        this.postSymbol = " ";
    }

    public int getCharNumber() {
        return this.zn;
    }

    public void setCharNumber(int zn) {
        this.zn = zn;
    }

    @Override
    public boolean add(Element o) {
        if (o instanceof ListItem) {
            ListItem item = (ListItem)o;
            Chunk chunk = new Chunk(this.preSymbol, this.symbol.getFont());
            chunk.append(String.valueOf((char)this.zn));
            chunk.append(this.postSymbol);
            item.setListSymbol(chunk);
            item.setIndentationLeft(this.symbolIndent, this.autoindent);
            item.setIndentationRight(0.0f);
            this.list.add(item);
        } else if (o instanceof List) {
            List nested = (List)o;
            nested.setIndentationLeft(nested.getIndentationLeft() + this.symbolIndent);
            --this.first;
            return this.list.add(nested);
        }
        return false;
    }

    @Override
    public boolean add(String s) {
        return this.add(new ListItem(s));
    }
}

