/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.shared.common.error.StandardException;

public class RIBulkChecker {
    private static final int EQUAL = 0;
    private static final int GREATER_THAN = 1;
    private static final int LESS_THAN = -1;
    private final long fkCID;
    private final long pkCID;
    private final String schemaName;
    private final String tableName;
    private final UUID constraintId;
    private BackingStoreHashtable deferredRowsHashTable;
    private final LanguageConnectionContext lcc;
    private final boolean deferred;
    private GroupFetchScanController referencedKeyScan;
    private DataValueDescriptor[][] referencedKeyRowArray;
    private GroupFetchScanController foreignKeyScan;
    private DataValueDescriptor[][] foreignKeyRowArray;
    private ConglomerateController unreferencedCC;
    private int failedCounter;
    private boolean quitOnFirstFailure;
    private int numColumns;
    private int currRefRowIndex;
    private int currFKRowIndex;
    private int lastRefRowIndex;
    private int lastFKRowIndex;
    private ExecRow firstRowToFail;

    public RIBulkChecker(Activation a, GroupFetchScanController referencedKeyScan, GroupFetchScanController foreignKeyScan, ExecRow templateRow, boolean quitOnFirstFailure, ConglomerateController unreferencedCC, ExecRow firstRowToFail, String schemaName, String tableName, UUID constraintId, boolean deferrable, long fkCID, long pkCID) throws StandardException {
        this.referencedKeyScan = referencedKeyScan;
        this.foreignKeyScan = foreignKeyScan;
        this.quitOnFirstFailure = quitOnFirstFailure;
        this.unreferencedCC = unreferencedCC;
        this.firstRowToFail = firstRowToFail;
        this.constraintId = constraintId;
        this.fkCID = fkCID;
        this.pkCID = pkCID;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.foreignKeyRowArray = new DataValueDescriptor[16][];
        this.foreignKeyRowArray[0] = templateRow.getRowArrayClone();
        this.referencedKeyRowArray = new DataValueDescriptor[16][];
        this.referencedKeyRowArray[0] = templateRow.getRowArrayClone();
        this.failedCounter = 0;
        this.numColumns = templateRow.getRowArray().length - 1;
        this.currFKRowIndex = -1;
        this.currRefRowIndex = -1;
        this.lcc = a.getLanguageConnectionContext();
        this.deferred = deferrable && this.lcc.isEffectivelyDeferred(this.lcc.getCurrentSQLSessionContext(a), constraintId);
    }

    public int doCheck() throws StandardException {
        DataValueDescriptor[] foreignKey;
        DataValueDescriptor[] referencedKey = this.getNextRef();
        while ((foreignKey = this.getNextFK()) != null) {
            int compareResult;
            if (!this.anyNull(foreignKey) && referencedKey == null) {
                do {
                    this.failure(foreignKey);
                    if (!this.quitOnFirstFailure) continue;
                    return this.failedCounter;
                } while ((foreignKey = this.getNextFK()) != null);
                return this.failedCounter;
            }
            while ((compareResult = this.greaterThan(foreignKey, referencedKey)) == 1) {
                referencedKey = this.getNextRef();
                if (referencedKey != null) continue;
                do {
                    this.failure(foreignKey);
                    if (!this.quitOnFirstFailure) continue;
                    return this.failedCounter;
                } while ((foreignKey = this.getNextFK()) != null);
                return this.failedCounter;
            }
            if (compareResult == 0) continue;
            this.failure(foreignKey);
            if (!this.quitOnFirstFailure) continue;
            return this.failedCounter;
        }
        return this.failedCounter;
    }

    private DataValueDescriptor[] getNextFK() throws StandardException {
        if (this.currFKRowIndex > this.lastFKRowIndex || this.currFKRowIndex == -1) {
            int rowCount = this.foreignKeyScan.fetchNextGroup(this.foreignKeyRowArray, null);
            if (rowCount == 0) {
                this.currFKRowIndex = -1;
                return null;
            }
            this.lastFKRowIndex = rowCount - 1;
            this.currFKRowIndex = 0;
        }
        return this.foreignKeyRowArray[this.currFKRowIndex++];
    }

    private DataValueDescriptor[] getNextRef() throws StandardException {
        if (this.currRefRowIndex > this.lastRefRowIndex || this.currRefRowIndex == -1) {
            int rowCount = this.referencedKeyScan.fetchNextGroup(this.referencedKeyRowArray, null);
            if (rowCount == 0) {
                this.currRefRowIndex = -1;
                return null;
            }
            this.lastRefRowIndex = rowCount - 1;
            this.currRefRowIndex = 0;
        }
        return this.referencedKeyRowArray[this.currRefRowIndex++];
    }

    private void failure(DataValueDescriptor[] foreignKeyRow) throws StandardException {
        if (this.deferred) {
            this.deferredRowsHashTable = DeferredConstraintsMemory.rememberFKViolation(this.lcc, this.deferredRowsHashTable, this.constraintId, foreignKeyRow, this.schemaName, this.tableName);
        } else {
            if (this.failedCounter == 0 && this.firstRowToFail != null) {
                this.firstRowToFail.setRowArray(foreignKeyRow);
                this.firstRowToFail.setRowArray(this.firstRowToFail.getRowArrayClone());
            }
            ++this.failedCounter;
            if (this.unreferencedCC != null) {
                this.unreferencedCC.insert(foreignKeyRow);
            }
        }
    }

    private boolean anyNull(DataValueDescriptor[] fkRowArray) throws StandardException {
        for (int i = 0; i < this.numColumns; ++i) {
            DataValueDescriptor fkCol = fkRowArray[i];
            if (!fkCol.isNull()) continue;
            return true;
        }
        return false;
    }

    private int greaterThan(DataValueDescriptor[] fkRowArray, DataValueDescriptor[] refRowArray) throws StandardException {
        if (this.anyNull(fkRowArray)) {
            return 0;
        }
        for (int i = 0; i < this.numColumns; ++i) {
            DataValueDescriptor fkCol = fkRowArray[i];
            DataValueDescriptor refCol = refRowArray[i];
            int result = fkCol.compare(refCol);
            if (result > 0) {
                return 1;
            }
            if (result >= 0) continue;
            return -1;
        }
        return 0;
    }
}

