/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.text.DateFormat;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ScriptContextTest
extends TestCase {
    ScriptContext context;

    @Before
    public void setUp() {
        this.context = new ScriptContext();
    }

    @After
    public void tearDown() {
        this.context.close();
    }

    @Test
    public void testScope() throws BirtException {
        this.context.setAttribute("A", (Object)new Integer(10));
        ScriptContext context1 = this.context.newContext(null);
        this.context.setAttribute("B", (Object)new Integer(20));
        Object result = this.eval(context1, "A + B");
        ScriptContextTest.assertEquals((double)((Number)result).doubleValue(), (double)30.0, (double)Double.MIN_VALUE);
        boolean hasException = false;
        try {
            result = this.eval(this.context, "A + B");
        }
        catch (Exception ex) {
            hasException = true;
        }
        ScriptContextTest.assertTrue((!hasException ? 1 : 0) != 0);
        result = this.eval(this.context, "A");
        ScriptContextTest.assertEquals((double)((Number)result).doubleValue(), (double)10.0, (double)Double.MIN_VALUE);
    }

    private Object eval(ScriptContext scriptContext, String script) throws BirtException {
        Object result = scriptContext.evaluate(this.context.compile("javascript", "<inline>", 1, script));
        return result;
    }

    @Test
    public void testJavaScope() throws BirtException {
        StringBuffer buffer = new StringBuffer();
        this.eval(this.context, "function getText() { return 'TEXT'};");
        ScriptContext context1 = this.context.newContext((Object)buffer);
        this.eval(context1, "append(getText());");
        this.eval(context1, "append('TEXT2');");
        ScriptContextTest.assertEquals((String)"TEXTTEXT2", (String)buffer.toString());
        Object result = this.eval(this.context, "getText()");
        ScriptContextTest.assertEquals((Object)"TEXT", (Object)result);
    }

    @Test
    public void testCompiledScript() throws BirtException {
        ScriptContext context1 = this.context.newContext(null);
        this.eval(context1, "function getText() { return 'A'}");
        ScriptContextTest.assertEquals((Object)"A", (Object)this.eval(context1, "getText()"));
        ScriptContext context2 = this.context.newContext(null);
        this.eval(context2, "function getText() { return 'B'}");
        ScriptContextTest.assertEquals((Object)"B", (Object)this.eval(context2, "getText()"));
        boolean hasException = false;
        try {
            this.eval(this.context, "getText()");
        }
        catch (Exception ex) {
            hasException = true;
        }
        ScriptContextTest.assertTrue((boolean)hasException);
    }

    @Test
    public void testGlobal() throws BirtException {
        this.eval(this.context, "importPackage(java.util)");
        this.eval(this.context, "importClass(java.text.DateFormat)");
        Object list = this.eval(this.context, "new ArrayList()");
        Object fmt = this.eval(this.context, "DateFormat.getInstance()");
        ScriptContextTest.assertTrue((boolean)(list instanceof ArrayList));
        ScriptContextTest.assertTrue((boolean)(fmt instanceof DateFormat));
    }

    @Test
    public void testRootScope() throws BirtException {
        this.context.setAttribute("share", (Object)"ABCDEFG");
        Object result = this.eval(this.context, "share + 'c'");
        ScriptContextTest.assertEquals((String)"ABCDEFGc", (String)result.toString());
        this.context.close();
    }

    @Test
    public void testThisObject() throws BirtException {
        this.context.setAttribute("A", (Object)"ABCDE");
        ScriptContext context1 = this.context.newContext(null);
        context1.setAttribute("a", (Object)"VALUE");
        Object result = this.eval(context1, "a");
        ScriptContextTest.assertEquals((Object)"VALUE", (Object)result);
        result = this.eval(context1, "this.a");
        ScriptContextTest.assertEquals((Object)"VALUE", (Object)result);
        result = this.eval(context1, "A");
        ScriptContextTest.assertEquals((Object)"ABCDE", (Object)result);
        result = this.eval(context1, "this.A");
        ScriptContextTest.assertEquals(null, (Object)result);
        this.context.close();
    }
}

