/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.dscache.DataSetFromCache;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.pass.ComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.pass.DataSetProcessUtil;
import org.eclipse.birt.data.engine.executor.transform.pass.PassStatusController;
import org.eclipse.birt.data.engine.executor.transform.pass.PassUtil;
import org.eclipse.birt.data.engine.executor.transform.pass.ResultSetProcessUtil;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;
import org.eclipse.birt.data.engine.script.OnFetchScriptHelper;

public class PassManager {
    protected ResultSetPopulator populator;
    protected ComputedColumnHelper computedColumnHelper;
    protected FilterByRow filterByRow;
    protected ComputedColumnsState iccState;
    protected PassStatusController psController;

    protected PassManager(ResultSetPopulator populator) {
        this.populator = populator;
    }

    public static void populateResultSet(ResultSetPopulator populator, OdiResultSetWrapper odaResultSet, DataEngineSession session) throws DataException {
        new PassManager(populator).pass(odaResultSet);
    }

    public static void populateDataSetResultSet(ResultSetPopulator populator, OdiResultSetWrapper odaResultSetWrapper) throws DataException {
        new PassManager(populator).prepareDataSetResultSet(odaResultSetWrapper);
    }

    private void prepareDataSetResultSet(OdiResultSetWrapper odaResultSet) throws DataException {
        this.populator.getExpressionProcessor().setDataSetMode(true);
        this.prepareFetchEventList();
        this.psController = new PassStatusController(this.populator, this.filterByRow, this.computedColumnHelper);
        boolean needMultiPass = this.psController.needMultipassProcessing();
        if (!needMultiPass) {
            this.doSinglePass(odaResultSet);
        } else {
            this.populateDataSet(odaResultSet);
        }
    }

    protected void prepareQueryResultSet() throws DataException {
        if (this.psController.needMultipassProcessing()) {
            this.populator.getExpressionProcessor().setDataSetMode(false);
            ResultSetProcessUtil.doPopulate(this.populator, this.iccState, this.computedColumnHelper, this.filterByRow, this.psController, Arrays.asList(this.populator.getQuery().getOrdering()));
        } else {
            ResultSetProcessUtil.doPopulateAggregation(this.populator, this.iccState, this.computedColumnHelper, this.filterByRow, this.psController, Arrays.asList(this.populator.getQuery().getOrdering()));
        }
    }

    protected void pass(OdiResultSetWrapper odaResultSet) throws DataException {
        this.prepareDataSetResultSet(odaResultSet);
        this.prepareQueryResultSet();
    }

    private void prepareFetchEventList() {
        Object[] fetchEventsList = PassManager.getFetchEventListFromQuery(this.populator);
        int i = 0;
        while (i < fetchEventsList.length) {
            if (fetchEventsList[i] instanceof ComputedColumnHelper) {
                this.computedColumnHelper = (ComputedColumnHelper)fetchEventsList[i];
            } else if (fetchEventsList[i] instanceof FilterByRow) {
                this.filterByRow = (FilterByRow)fetchEventsList[i];
            }
            ++i;
        }
    }

    private void doSinglePass(OdiResultSetWrapper odaResultSet) throws DataException {
        if (this.computedColumnHelper != null) {
            this.computedColumnHelper.setModel(0);
        }
        PassUtil.pass(this.populator, odaResultSet, false);
        this.populator.getExpressionProcessor().setDataSetMode(false);
        this.removeOnFetchScriptHelper();
        this.handleEndOfDataSetProcess();
    }

    private void removeOnFetchScriptHelper() {
        if (this.populator.getQuery().getFetchEvents() == null) {
            return;
        }
        Iterator<IResultObjectEvent> it = this.populator.getQuery().getFetchEvents().iterator();
        while (it.hasNext()) {
            IResultObjectEvent o = it.next();
            if (!(o instanceof OnFetchScriptHelper)) continue;
            it.remove();
        }
    }

    private static Object[] getFetchEventListFromQuery(ResultSetPopulator rsp) {
        Object[] fetchEventsList = null;
        fetchEventsList = rsp.getQuery().getFetchEvents() == null ? new Object[]{} : rsp.getQuery().getFetchEvents().toArray();
        return fetchEventsList;
    }

    private void populateDataSet(OdiResultSetWrapper odaResultSet) throws DataException {
        if (this.computedColumnHelper != null) {
            this.iccState = new ComputedColumnsState(this.computedColumnHelper);
        }
        List<Object> cachedSorting = Arrays.asList(this.populator.getQuery().getOrdering() == null ? new Object[]{} : this.populator.getQuery().getOrdering());
        this.populator.getQuery().setOrdering(new ArrayList<IQuery.SortSpec>());
        this.populator.getExpressionProcessor().setDataSetMode(true);
        this.populateResultSetCacheInResultSetPopulator(odaResultSet);
        if (!(odaResultSet.getWrappedOdiResultSet() instanceof DataSetFromCache)) {
            DataSetProcessUtil.doPopulate(this.populator, this.iccState, this.computedColumnHelper, this.filterByRow, this.psController);
        }
        this.handleEndOfDataSetProcess();
        this.populator.getQuery().setOrdering(cachedSorting);
    }

    private void populateResultSetCacheInResultSetPopulator(OdiResultSetWrapper odaResultSet) throws DataException {
        if (this.computedColumnHelper != null) {
            this.computedColumnHelper.setModel(5);
        }
        if (this.filterByRow != null) {
            this.filterByRow.setWorkingFilterSet(4);
        }
        int max = this.populator.getQuery().getMaxRows();
        if (this.filterByRow != null) {
            this.populator.getQuery().setMaxRows(0);
        }
        PassUtil.pass(this.populator, odaResultSet, false);
        this.removeOnFetchScriptHelper();
        this.populator.getQuery().setMaxRows(max);
    }

    private void handleEndOfDataSetProcess() throws DataException {
        IEventHandler eventHandler = this.populator.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleEndOfDataSetProcess(this.populator.getResultIterator());
        }
    }
}

