/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.IncludeScriptHandle;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.CssException;
import org.eclipse.birt.report.model.api.core.AttributeEvent;
import org.eclipse.birt.report.model.api.core.DisposeEvent;
import org.eclipse.birt.report.model.api.core.IAttributeListener;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.IDisposeListener;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.IncludeScript;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.FreeForm;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.SimpleMasterPage;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.olap.TabularHierarchy;
import org.eclipse.birt.report.model.elements.olap.TabularLevel;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.BaseTestCase;
import org.eclipse.birt.report.model.util.ReportDesignSerializer;

public class ReportDesignHandleTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("ReportDesignHandleTest.xml");
    }

    public void testConfigVars() throws Exception {
        PropertyHandle configVars = this.designHandle.getPropertyHandle("configVars");
        ArrayList list = configVars.getListValue();
        ReportDesignHandleTest.assertEquals((int)2, (int)list.size());
        ConfigVariable var = this.designHandle.findConfigVariable("var1");
        ReportDesignHandleTest.assertEquals((String)"mumble.jpg", (String)var.getValue());
        this.designHandle.dropConfigVariable("var2");
        list = configVars.getListValue();
        ReportDesignHandleTest.assertEquals((int)1, (int)list.size());
        ConfigVariable newvar = new ConfigVariable();
        newvar.setName("newvar2");
        newvar.setValue("new value 2");
        this.designHandle.addConfigVariable(newvar);
        newvar = new ConfigVariable();
        newvar.setName("new var1");
        newvar.setValue("new value 1");
        this.designHandle.replaceConfigVariable(var, newvar);
        list = configVars.getListValue();
        ReportDesignHandleTest.assertEquals((int)2, (int)list.size());
        this.designHandle.dropConfigVariable("newvar2");
        this.designHandle.dropConfigVariable("new var1");
        configVars.setValue(null);
        ReportDesignHandleTest.assertNull((Object)configVars.getValue());
        ConfigVariable structure3 = StructureFactory.createConfigVar();
        structure3.setName("myvar");
        structure3.setValue("my value");
        this.designHandle.addConfigVariable(structure3);
        PropertyHandle propHandle = this.designHandle.getPropertyHandle("configVars");
        Iterator iter = propHandle.iterator();
        ConfigVariableHandle structureHandle3 = (ConfigVariableHandle)iter.next();
        structureHandle3.setName("new name");
        structureHandle3.setValue("new value");
        ReportDesignHandleTest.assertEquals((String)"new name", (String)structureHandle3.getName());
        ReportDesignHandleTest.assertEquals((String)"new value", (String)structureHandle3.getValue());
        try {
            this.designHandle.replaceConfigVariable(structure3, structure3);
            ReportDesignHandleTest.fail();
        }
        catch (PropertyValueException e) {
            ReportDesignHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        ConfigVariable structure4 = StructureFactory.createConfigVar();
        structure4.setName("myvar1");
        structure4.setValue("my value1");
        this.designHandle.replaceConfigVariable(structure3, structure4);
        this.designHandle.dropConfigVariable("myvar1");
        try {
            this.designHandle.dropConfigVariable("myvar");
            ReportDesignHandleTest.fail();
        }
        catch (PropertyValueException e) {
            ReportDesignHandleTest.assertEquals((String)"Error.PropertyValueException.ITEM_NOT_FOUND", (String)e.getErrorCode());
        }
    }

    public void testCssStyleSheet() throws Exception {
        this.openDesign("BlankReportDesign.xml");
        ReportDesignHandleTest.assertTrue((boolean)this.designHandle.canAddCssStyleSheet(this.getResource("input/base.css").getFile()));
        ReportDesignHandleTest.assertTrue((boolean)this.designHandle.canAddCssStyleSheet("base.css"));
        CssStyleSheetHandle sheetHandle = this.designHandle.openCssStyleSheet(this.getResource("input/base.css").getFile());
        ReportDesignHandleTest.assertNull((Object)sheetHandle.getContainerHandle());
        this.designHandle.addCss(sheetHandle);
        ReportDesignHandleTest.assertFalse((boolean)this.designHandle.canAddCssStyleSheet(this.getResource("input/base.css").getFile()));
        ReportDesignHandleTest.assertFalse((boolean)this.designHandle.canAddCssStyleSheet(sheetHandle));
        ReportDesignHandleTest.assertNotNull((Object)sheetHandle.getContainerHandle());
        List styles = this.designHandle.getAllStyles();
        ReportDesignHandleTest.assertEquals((int)5, (int)styles.size());
        try {
            this.designHandle.addCss(sheetHandle);
            ReportDesignHandleTest.fail();
        }
        catch (CssException e) {
            ReportDesignHandleTest.assertEquals((String)"Error.CSSException.DUPLICATE_CSS", (String)e.getErrorCode());
        }
        LabelHandle labelHandle = this.designHandle.getElementFactory().newLabel("label");
        this.designHandle.getBody().add((DesignElementHandle)labelHandle);
        labelHandle.setStyle((SharedStyleHandle)styles.get(0));
        ReportDesignHandleTest.assertTrue((boolean)this.designHandle.canDropCssStyleSheet(sheetHandle));
        ElementRefValue value = (ElementRefValue)labelHandle.getElement().getLocalProperty(this.designHandle.getModule(), "style");
        ReportDesignHandleTest.assertTrue((boolean)value.isResolved());
        this.designHandle.dropCss(sheetHandle);
        ReportDesignHandleTest.assertFalse((boolean)value.isResolved());
        ReportDesignHandleTest.assertNull(this.designHandle.includeCssesIterator().next());
        ReportDesignHandleTest.assertNull((Object)labelHandle.getStyle());
        ReportDesignHandleTest.assertFalse((boolean)this.designHandle.canDropCssStyleSheet(sheetHandle));
        ReportDesignHandleTest.assertNull((Object)sheetHandle.getContainerHandle());
        this.designHandle.addCss("base.css");
        styles = this.designHandle.getAllStyles();
        ReportDesignHandleTest.assertEquals((int)5, (int)styles.size());
        this.designHandle.getCommandStack().undo();
        IncludedCssStyleSheet cssStruct = StructureFactory.createIncludedCssStyleSheet();
        cssStruct.setFileName("base.css");
        cssStruct.setExternalCssURI("/tmp");
        this.designHandle.addCss(cssStruct);
        cssStruct = (IncludedCssStyleSheet)this.designHandle.getListProperty("cssStyleSheets").get(0);
        ReportDesignHandleTest.assertEquals((String)"base.css", (String)cssStruct.getFileName());
        ReportDesignHandleTest.assertEquals((String)"/tmp", (String)cssStruct.getExternalCssURI());
        styles = this.designHandle.getAllStyles();
        ReportDesignHandleTest.assertEquals((int)5, (int)styles.size());
        CssStyleSheetHandle stylySheetHandle = this.designHandle.findCssStyleSheetHandleByFileName("base.css");
        ReportDesignHandleTest.assertNotNull((Object)stylySheetHandle);
        ReportDesignHandleTest.assertEquals((String)"base.css", (String)stylySheetHandle.getFileName());
        IncludedCssStyleSheetHandle includedStylySheetHandle = this.designHandle.findIncludedCssStyleSheetHandleByFileName("base.css");
        ReportDesignHandleTest.assertNotNull((Object)includedStylySheetHandle);
        ReportDesignHandleTest.assertEquals((String)"base.css", (String)includedStylySheetHandle.getFileName());
    }

    public void testRenameCss() throws Exception {
        this.openDesign("RenameCssTest.xml");
        IncludedCssStyleSheetHandle includedStylySheetHandle = this.designHandle.findIncludedCssStyleSheetHandleByFileName("base.css");
        ReportDesignHandleTest.assertFalse((boolean)this.designHandle.canRenameCss(includedStylySheetHandle, "base.css"));
        ReportDesignHandleTest.assertFalse((boolean)this.designHandle.canRenameCss(includedStylySheetHandle, "base1.css"));
        ReportDesignHandleTest.assertTrue((boolean)this.designHandle.canRenameCss(includedStylySheetHandle, "base2.css"));
        ReportDesignHandleTest.assertFalse((boolean)this.designHandle.canRenameCss(includedStylySheetHandle, "base3.css"));
        try {
            this.designHandle.renameCss(includedStylySheetHandle, "base1.css");
            ReportDesignHandleTest.fail();
        }
        catch (CssException e) {
            ReportDesignHandleTest.assertEquals((String)"Error.CSSException.DUPLICATE_CSS", (String)e.getErrorCode());
        }
        try {
            this.designHandle.renameCss(includedStylySheetHandle, "base3.css");
            ReportDesignHandleTest.fail();
        }
        catch (CssException e) {
            ReportDesignHandleTest.assertEquals((String)"Error.CSSException.CSS_NOT_FOUND", (String)e.getErrorCode());
        }
        this.designHandle.renameCss(includedStylySheetHandle, "base2.css");
        includedStylySheetHandle = this.designHandle.findIncludedCssStyleSheetHandleByFileName("base2.css");
        ReportDesignHandleTest.assertEquals((String)"base2.css", (String)includedStylySheetHandle.getFileName());
        List list = this.designHandle.getAllCssStyleSheets();
        CssStyleSheetHandle cssStyleSheetHandle = (CssStyleSheetHandle)list.get(0);
        ReportDesignHandleTest.assertEquals((String)"base2.css", (String)cssStyleSheetHandle.getFileName());
        this.designHandle.getCommandStack().undo();
        includedStylySheetHandle = this.designHandle.findIncludedCssStyleSheetHandleByFileName("base.css");
        ReportDesignHandleTest.assertEquals((String)"base.css", (String)includedStylySheetHandle.getFileName());
        list = this.designHandle.getAllCssStyleSheets();
        cssStyleSheetHandle = (CssStyleSheetHandle)list.get(0);
        ReportDesignHandleTest.assertEquals((String)"base.css", (String)cssStyleSheetHandle.getFileName());
        this.designHandle.getCommandStack().redo();
        includedStylySheetHandle = this.designHandle.findIncludedCssStyleSheetHandleByFileName("base2.css");
        ReportDesignHandleTest.assertEquals((String)"base2.css", (String)includedStylySheetHandle.getFileName());
        list = this.designHandle.getAllCssStyleSheets();
        cssStyleSheetHandle = (CssStyleSheetHandle)list.get(0);
        ReportDesignHandleTest.assertEquals((String)"base2.css", (String)cssStyleSheetHandle.getFileName());
    }

    public void testReportDesignOtherMethods() {
        DesignElement element = this.designHandle.getElement();
        ReportDesignHandleTest.assertTrue((boolean)(element instanceof ReportDesign));
        ReportDesignHandleTest.assertTrue((element == this.design ? 1 : 0) != 0);
        ReportDesignHandleTest.assertTrue((this.designHandle.getDesign() == this.design ? 1 : 0) != 0);
        ReportDesignHandleTest.assertTrue((this.designHandle.getDesignHandle() != null ? 1 : 0) != 0);
        ParameterHandle paramHandle = this.designHandle.findParameter("Param 2");
        ReportDesignHandleTest.assertNotNull((Object)paramHandle);
    }

    public void testReportDesignSlots() {
        SlotHandle slotHandle = this.designHandle.getBody();
        ReportDesignHandleTest.assertEquals((int)1, (int)slotHandle.getCount());
        slotHandle = this.designHandle.getParameters();
        ReportDesignHandleTest.assertEquals((int)3, (int)slotHandle.getCount());
        List list = this.designHandle.getFlattenParameters();
        ReportDesignHandleTest.assertEquals((int)4, (int)list.size());
        slotHandle = this.designHandle.getComponents();
        ReportDesignHandleTest.assertEquals((int)0, (int)slotHandle.getCount());
        slotHandle = this.designHandle.getDataSets();
        ReportDesignHandleTest.assertEquals((int)1, (int)slotHandle.getCount());
        slotHandle = this.designHandle.getDataSources();
        ReportDesignHandleTest.assertEquals((int)1, (int)slotHandle.getCount());
        slotHandle = this.designHandle.getMasterPages();
        ReportDesignHandleTest.assertEquals((int)1, (int)slotHandle.getCount());
        slotHandle = this.designHandle.getScratchPad();
        ReportDesignHandleTest.assertEquals((int)0, (int)slotHandle.getCount());
        slotHandle = this.designHandle.getStyles();
        ReportDesignHandleTest.assertEquals((int)0, (int)slotHandle.getCount());
        PropertyHandle colorPalette = this.designHandle.getPropertyHandle("colorPalette");
        ReportDesignHandleTest.assertNull((Object)colorPalette.getListValue());
    }

    public void testReportDesignProperties() throws Exception {
        ReportDesignHandleTest.assertEquals((int)0, (int)this.designHandle.getImageDPI());
        ReportDesignHandleTest.assertEquals((String)"c:\\", (String)this.designHandle.getBase());
        ReportDesignHandleTest.assertEquals((String)this.getResource("input/ReportDesignHandleTest.xml").toString(), (String)this.designHandle.getFileName());
        this.designHandle.setBase("../test/input/");
        ReportDesignHandleTest.assertEquals((String)"../test/input/", (String)this.designHandle.getBase());
        ReportDesignHandleTest.assertEquals((String)"W.C. Fields", (String)this.designHandle.getAuthor());
        ReportDesignHandleTest.assertEquals((String)"http://company.com/reportHelp.html", (String)this.designHandle.getHelpGuide());
        ReportDesignHandleTest.assertEquals((String)"Whiz-Bang Plus", (String)this.designHandle.getCreatedBy());
        ReportDesignHandleTest.assertEquals((int)30, (int)this.designHandle.getRefreshRate());
        this.designHandle.setAuthor("Eclipse BIRT 1.00");
        this.designHandle.setHelpGuide("http://www.eclipse.org/birt/help.html");
        this.designHandle.setCreatedBy("Eclipse BIRT");
        this.designHandle.setRefreshRate(50);
        ReportDesignHandleTest.assertEquals((String)"Eclipse BIRT 1.00", (String)this.designHandle.getAuthor());
        ReportDesignHandleTest.assertEquals((String)"http://www.eclipse.org/birt/help.html", (String)this.designHandle.getHelpGuide());
        ReportDesignHandleTest.assertEquals((String)"Eclipse BIRT", (String)this.designHandle.getCreatedBy());
        ReportDesignHandleTest.assertEquals((int)50, (int)this.designHandle.getRefreshRate());
        List variables = this.designHandle.getAllVariables();
        for (VariableElementHandle variable : variables) {
            String name = variable.getVariableName();
            ReportDesignHandleTest.assertEquals((String)name, (String)"test");
            String expression = variable.getValue();
            ReportDesignHandleTest.assertEquals((String)expression, (String)"\"the test value\"");
        }
    }

    public void testRename() throws Exception {
        this.openDesign("ReportDesignHandleTest1.xml");
        FreeFormHandle handle = (FreeFormHandle)this.designHandle.getBody().get(0);
        ReportDesignHandleTest.assertTrue((boolean)(handle.getElement() instanceof FreeForm));
        FreeForm form = (FreeForm)handle.getElement();
        this.designHandle.rename(form.getHandle((Module)this.design));
        SimpleMasterPage page = (SimpleMasterPage)this.designHandle.getMasterPages().get(0).getElement();
        this.designHandle.rename(page.getHandle((Module)this.design));
    }

    public void testUniqueStyleName() throws Exception {
        this.createLibrary();
        ElementFactory libFactory = this.libraryHandle.getElementFactory();
        ThemeHandle theme = libFactory.newTheme("theme1");
        this.libraryHandle.getThemes().add((DesignElementHandle)theme);
        SharedStyleHandle style = libFactory.newStyle("NewStyle");
        theme.getStyles().add((DesignElementHandle)style);
        ReportDesignHandleTest.assertEquals((String)"NewStyle", (String)style.getName());
        SharedStyleHandle style1 = libFactory.newStyle("NewStyle1");
        theme.getStyles().add((DesignElementHandle)style1);
        ReportDesignHandleTest.assertEquals((String)"NewStyle1", (String)style1.getName());
        SharedStyleHandle style2 = libFactory.newStyle("NewStyle2");
        theme.getStyles().add((DesignElementHandle)style2);
        ReportDesignHandleTest.assertEquals((String)"NewStyle2", (String)style2.getName());
        IDesignElement clonedElement = style2.copy();
        DesignElementHandle clonedElementHandle = clonedElement.getHandle(this.libraryHandle.getModule());
        this.libraryHandle.getRoot().rename((DesignElementHandle)theme, clonedElementHandle);
        ReportDesignHandleTest.assertEquals((String)"NewStyle21", (String)clonedElementHandle.getName());
        clonedElement = style2.copy();
        clonedElementHandle = clonedElement.getHandle(this.libraryHandle.getModule());
        this.libraryHandle.getRoot().rename((DesignElementHandle)this.libraryHandle, clonedElementHandle);
        ReportDesignHandleTest.assertEquals((String)"NewStyle2", (String)clonedElementHandle.getName());
    }

    public void testUniqueLevelName() throws Exception {
        this.openLibrary("ReportDesignHandleTest_UniqueLevelName.xml");
        CubeHandle cubeHandle = (CubeHandle)this.libraryHandle.getCubes().get(0);
        DimensionHandle dimensionHandle = cubeHandle.getDimension("Group");
        HierarchyHandle hierarchyHandle = (HierarchyHandle)dimensionHandle.getListProperty("hierarchies").get(0);
        TabularLevel level = new TabularLevel("ORDERNUMBER");
        LevelHandle levelHandle = (LevelHandle)level.getHandle(this.libraryHandle.getModule());
        this.libraryHandle.getRoot().rename((DesignElementHandle)hierarchyHandle, (DesignElementHandle)levelHandle);
        ReportDesignHandleTest.assertEquals((String)"ORDERNUMBER1", (String)levelHandle.getName());
        TabularHierarchy hierarchy = new TabularHierarchy("NewTabularHierarchy");
        hierarchyHandle = (HierarchyHandle)hierarchy.getHandle(this.libraryHandle.getModule());
        level = new TabularLevel("ORDERNUMBER");
        levelHandle = (LevelHandle)level.getHandle(this.libraryHandle.getModule());
        hierarchyHandle.add("levels", (DesignElementHandle)levelHandle);
        this.libraryHandle.getRoot().rename((DesignElementHandle)hierarchyHandle, (DesignElementHandle)levelHandle);
        ReportDesignHandleTest.assertEquals((String)"ORDERNUMBER", (String)levelHandle.getName());
        dimensionHandle = (DimensionHandle)dimensionHandle.copy().getHandle(this.libraryHandle.getModule());
        hierarchy = new TabularHierarchy("NewTabularHierarchy");
        hierarchyHandle = (HierarchyHandle)hierarchy.getHandle(this.libraryHandle.getModule());
        dimensionHandle.add("hierarchies", (DesignElementHandle)hierarchyHandle);
        level = new TabularLevel("ORDERNUMBER");
        levelHandle = (LevelHandle)level.getHandle(this.libraryHandle.getModule());
        hierarchyHandle.add("levels", (DesignElementHandle)levelHandle);
        this.libraryHandle.getRoot().rename((DesignElementHandle)hierarchyHandle, (DesignElementHandle)levelHandle);
        ReportDesignHandleTest.assertEquals((String)"ORDERNUMBER1", (String)levelHandle.getName());
        dimensionHandle = cubeHandle.getDimension("Group");
        dimensionHandle = (DimensionHandle)dimensionHandle.copy().getHandle(this.libraryHandle.getModule());
        hierarchy = new TabularHierarchy("NewTabularHierarchy");
        hierarchyHandle = (HierarchyHandle)hierarchy.getHandle(this.libraryHandle.getModule());
        dimensionHandle.add("hierarchies", (DesignElementHandle)hierarchyHandle);
        level = new TabularLevel("ORDERNUMBER");
        levelHandle = (LevelHandle)level.getHandle(this.libraryHandle.getModule());
        hierarchyHandle.add("levels", (DesignElementHandle)levelHandle);
        this.libraryHandle.getRoot().rename((DesignElementHandle)dimensionHandle, (DesignElementHandle)hierarchyHandle);
        ReportDesignHandleTest.assertEquals((String)"NewTabularHierarchy2", (String)hierarchyHandle.getName());
        ReportDesignHandleTest.assertEquals((String)"ORDERNUMBER1", (String)levelHandle.getName());
        TableItem table = new TableItem("table");
        this.libraryHandle.getComponents().add(table.getHandle(this.libraryHandle.getModule()));
        TableHandle tableHandle = (TableHandle)this.libraryHandle.getComponents().get(0);
        TableItem innerTable = new TableItem("table");
        this.libraryHandle.getRoot().rename((DesignElementHandle)tableHandle, innerTable.getHandle(this.libraryHandle.getModule()));
        ReportDesignHandleTest.assertEquals((String)"table1", (String)innerTable.getName());
        table = new TableItem("another table");
        ContainerSlot slot = table.getSlot(2);
        innerTable = new TableItem("another table");
        slot.add((DesignElement)innerTable);
        this.libraryHandle.getRoot().rename((DesignElementHandle)this.libraryHandle, table.getHandle(this.libraryHandle.getModule()));
        ReportDesignHandleTest.assertEquals((String)"another table", (String)table.getName());
        ReportDesignHandleTest.assertEquals((String)"another table1", (String)innerTable.getName());
    }

    public void testIteratorMethods() throws Exception {
        Iterator iter = this.designHandle.imagesIterator();
        ReportDesignHandleTest.assertFalse((boolean)iter.hasNext());
        iter = this.designHandle.configVariablesIterator();
        ReportDesignHandleTest.assertNotNull(iter.next());
        ReportDesignHandleTest.assertNotNull(iter.next());
        ReportDesignHandleTest.assertFalse((boolean)iter.hasNext());
    }

    public void testNeedsSave() throws Exception {
        String outputPath = this.getTempFolder() + "/output/";
        File outputFolder = new File(outputPath);
        Files.createDirectories(outputFolder.toPath(), new FileAttribute[0]);
        ElementFactory factory = new ElementFactory((Module)this.design);
        GridHandle grid = factory.newGridItem("new grid");
        SlotHandle slot = this.designHandle.getBody();
        slot.add((DesignElementHandle)grid);
        ReportDesignHandleTest.assertTrue((boolean)this.designHandle.needsSave());
        this.designHandle.saveAs(outputPath + "ReportDesignTestNew.xml");
        ReportDesignHandleTest.assertFalse((boolean)this.designHandle.needsSave());
        grid = factory.newGridItem("new second grid");
        slot.add((DesignElementHandle)grid);
        ReportDesignHandleTest.assertTrue((boolean)this.designHandle.needsSave());
        slot.dropAndClear((DesignElementHandle)grid);
        ReportDesignHandleTest.assertTrue((boolean)this.designHandle.needsSave());
        ActivityStack as = this.design.getActivityStack();
        as.undo();
        ReportDesignHandleTest.assertTrue((boolean)this.designHandle.needsSave());
        as.undo();
        ReportDesignHandleTest.assertFalse((boolean)this.designHandle.needsSave());
        as.undo();
        ReportDesignHandleTest.assertFalse((boolean)as.canUndo());
        ReportDesignHandleTest.assertTrue((boolean)this.designHandle.needsSave());
    }

    public void testNeedsSave2() throws Exception {
        this.save((ModuleHandle)this.designHandle);
        ElementFactory factory = new ElementFactory((Module)this.design);
        LabelHandle label = factory.newLabel("Label1");
        SlotHandle slotHandle = this.designHandle.getBody();
        slotHandle.add((DesignElementHandle)label);
        ReportDesignHandleTest.assertTrue((boolean)this.designHandle.needsSave());
        this.design.getActivityStack().undo();
        ReportDesignHandleTest.assertFalse((boolean)this.designHandle.needsSave());
    }

    public void testEmbeddedImage() throws Exception {
        this.openDesign("EmbeddedImageTest.xml", ULocale.ENGLISH);
        PropertyHandle images = this.designHandle.getPropertyHandle("images");
        ReportDesignHandleTest.assertNotNull((Object)images);
        EmbeddedImageHandle image1 = (EmbeddedImageHandle)images.getAt(0);
        EmbeddedImageHandle image2 = (EmbeddedImageHandle)images.getAt(1);
        String image1Name = image1.getName();
        String image2Name = image2.getName();
        ArrayList<EmbeddedImageHandle> imageList = new ArrayList<EmbeddedImageHandle>();
        imageList.add(image1);
        imageList.add(image2);
        this.designHandle.dropImage(imageList);
        this.design.getActivityStack().undo();
        image1 = (EmbeddedImageHandle)images.getAt(0);
        image2 = (EmbeddedImageHandle)images.getAt(1);
        this.design.getActivityStack().redo();
        ReportDesignHandleTest.assertNull((Object)images.getListValue());
        try {
            this.designHandle.dropImage(image1Name);
            this.designHandle.dropImage(image2Name);
            ReportDesignHandleTest.fail();
        }
        catch (PropertyValueException e) {
            ReportDesignHandleTest.assertEquals((String)"Error.PropertyValueException.ITEM_NOT_FOUND", (String)e.getErrorCode());
        }
    }

    public void testFileNameAndDisposeListener() throws Exception {
        FileNameListener fListener = new FileNameListener();
        this.designHandle.addAttributeListener((IAttributeListener)fListener);
        DisposeListener dListener = new DisposeListener();
        this.designHandle.addDisposeListener((IDisposeListener)dListener);
        this.designHandle.setFileName("test file");
        this.designHandle.close();
        ReportDesignHandleTest.assertEquals((String)"test file", (String)fListener.getStatus());
        ReportDesignHandleTest.assertEquals((String)"disposed", (String)dListener.getStatus());
        this.openDesign("ReportDesignHandleTest.xml");
        SelfDisposeListener dropListener = new SelfDisposeListener();
        this.designHandle.addDisposeListener((IDisposeListener)dropListener);
        this.designHandle.getModule().broadcastDisposeEvent(new DisposeEvent(this.designHandle.getModule()));
        ReportDesignHandleTest.assertEquals((int)1, (int)dropListener.getStatus());
        this.designHandle.getModule().broadcastDisposeEvent(new DisposeEvent(this.designHandle.getModule()));
        ReportDesignHandleTest.assertEquals((int)1, (int)dropListener.getStatus());
    }

    public void testFindResource() throws Exception {
        this.designHandle.setFileName(null);
        this.designHandle.getModule().setSystemId(null);
        URL filePath = this.getResource("input/ReportDesignHandleTest.xml");
        this.designHandle.setFileName(filePath.toString());
        URL url = this.designHandle.findResource("ReportDesignHandleTest.xml", 2);
        ReportDesignHandleTest.assertNotNull((Object)url);
        url = this.designHandle.findResource("NoExistedDesign.xml", 2);
        ReportDesignHandleTest.assertNull((Object)url);
        this.designHandle.setFileName(this.getResource("input/").toString() + "NoExistedDesign.xml");
        url = this.designHandle.findResource("ReportDesignHandleTest.xml", 2);
        ReportDesignHandleTest.assertNotNull((Object)url);
        url = this.designHandle.findResource("NoExistedDesign.xml", 2);
        ReportDesignHandleTest.assertNull((Object)url);
        this.designHandle.getModule().setSystemId(new URL("http://www.eclipse.org/"));
        url = this.designHandle.findResource("images/EclipseBannerPic.jpg", 1);
        ReportDesignHandleTest.assertEquals((String)"http://www.eclipse.org/images/EclipseBannerPic.jpg", (String)url.toString());
        url = this.designHandle.findResource("NoExistedDir/NoExistedDesign.xml", 2);
        ReportDesignHandleTest.assertNotNull((Object)url);
    }

    public void testSetFileName() throws Exception {
        this.designHandle.setFileName("http://www.eclipse.org/ima%23ge%20%20/s/");
        this.assertEqualsOnWindows("http://www.eclipse.org/ima%23ge%20%20/s/", this.designHandle.getSystemId().toString());
        this.designHandle.setFileName("http://hello.com/\u4e0d\u5b58\u5728\u7684\u5355\u4f4d");
        ReportDesignHandleTest.assertEquals((String)"http://hello.com/", (String)this.designHandle.getSystemId().toString());
        this.designHandle.setFileName("http://hello.com/\u4e0d\u5b58/index.rtpdesign");
        ReportDesignHandleTest.assertEquals((String)"http://hello.com/\u4e0d\u5b58/", (String)this.designHandle.getSystemId().toString());
        this.designHandle.setFileName("/usr/home/birt/report.xml");
        ReportDesignHandleTest.assertEquals((String)new File("/usr/home/birt/report.xml").getParentFile().toURL().toString(), (String)this.designHandle.getSystemId().toString());
        this.designHandle.setFileName("C:\\reports\\1.xml");
        this.assertEqualsOnWindows("file:/C:/reports", this.designHandle.getSystemId().toString());
        this.designHandle.setFileName("jar:file:/C:/reports/testRead.jar!/1.xml");
        ReportDesignHandleTest.assertEquals((String)"jar:file:/C:/reports/testRead.jar!/", (String)this.designHandle.getSystemId().toString());
        this.designHandle.setFileName("jar:http://hello.com/reports/testRead.jar!/1.xml");
        ReportDesignHandleTest.assertEquals((String)"jar:http://hello.com/reports/testRead.jar!/", (String)this.designHandle.getSystemId().toString());
        this.designHandle.setFileName("1.xml");
        ReportDesignHandleTest.assertNotNull((Object)this.designHandle.getModule().getSystemId());
        ReportDesignHandleTest.assertEquals((String)new File("1.xml").getAbsoluteFile().getParentFile().toURL().toExternalForm(), (String)this.designHandle.getSystemId().toString());
        this.designHandle.setFileName("bundleresource://22868/samplereports/Reporting Feature Examples/Combination Chart/CustomerOrdersFinal.rptdesign");
        URL tmpURL = this.designHandle.getSystemId();
        ReportDesignHandleTest.assertEquals((String)"bundleresource", (String)tmpURL.getProtocol());
        ReportDesignHandleTest.assertEquals((String)"/samplereports/Reporting Feature Examples/Combination Chart/", (String)tmpURL.getPath());
    }

    public void testCopyAndPasteEmbeddedImage() throws Exception {
        this.openDesign("EmbeddedImageTest.xml");
        EmbeddedImage image = this.designHandle.findImage("image one");
        ReportDesignHandleTest.assertNotNull((Object)image);
        EmbeddedImage newImage = (EmbeddedImage)image.copy();
        ReportDesignHandleTest.assertNotNull((Object)newImage);
        ReportDesignHandleTest.assertEquals((String)image.getName(), (String)newImage.getName());
        this.designHandle.rename(newImage);
        ReportDesignHandleTest.assertEquals((String)(image.getName() + "1"), (String)newImage.getName());
        this.designHandle.addImage(newImage);
        ReportDesignHandleTest.assertEquals((Object)newImage, (Object)this.designHandle.findImage(image.getName() + "1"));
    }

    public void testCascadingParameters() throws DesignFileException {
        this.openDesign("ReportDesignHandleTest2.xml");
        CascadingParameterGroupHandle group1 = this.designHandle.findCascadingParameterGroup("Country-State-City");
        ReportDesignHandleTest.assertNotNull((Object)group1);
        ReportDesignHandleTest.assertEquals((int)3, (int)group1.getParameters().getCount());
        CascadingParameterGroupHandle group2 = this.designHandle.findCascadingParameterGroup("group2");
        ReportDesignHandleTest.assertNotNull((Object)group2);
        ReportDesignHandleTest.assertEquals((String)"Group2 displayName", (String)group2.getDisplayName());
        CascadingParameterGroupHandle group3 = this.designHandle.findCascadingParameterGroup("group3");
        ReportDesignHandleTest.assertNotNull((Object)group3);
        ReportDesignHandleTest.assertEquals((String)"Group3 displayName", (String)group3.getDisplayName());
        CascadingParameterGroupHandle group4 = this.designHandle.findCascadingParameterGroup("non-exsit-group");
        ReportDesignHandleTest.assertNull((Object)group4);
    }

    public void testGetBookmarksAndTocs() throws Exception {
        this.openDesign("ReportDesignBookmark.xml");
        List bookmarks = this.designHandle.getAllBookmarks();
        ReportDesignHandleTest.assertEquals((int)4, (int)bookmarks.size());
        ReportDesignHandleTest.assertEquals((Object)"bookmark_label", bookmarks.get(0));
        ReportDesignHandleTest.assertEquals((Object)"\"bookmark_group\"", bookmarks.get(1));
        ReportDesignHandleTest.assertEquals((Object)"bookmark_detail_row", bookmarks.get(2));
        ReportDesignHandleTest.assertEquals((Object)"bookmark_detail_text", bookmarks.get(3));
        List tocs = this.designHandle.getAllTocs();
        ReportDesignHandleTest.assertEquals((int)3, (int)tocs.size());
        ReportDesignHandleTest.assertEquals((Object)"Toc_label", tocs.get(0));
        ReportDesignHandleTest.assertEquals((Object)"DateTimeSpan.days(2005/01/01, 2006/01/01)", tocs.get(1));
        ReportDesignHandleTest.assertEquals((Object)"toc_detail_text", tocs.get(2));
    }

    public void testInitializeReportDesign() throws SemanticException, IOException {
        SessionHandle sessionHandle = new SessionHandle(null);
        this.designHandle = sessionHandle.createDesign();
        HashMap<String, String> properties = new HashMap<String, String>();
        String createdBy = "test initialize";
        properties.put("Build", "2006-12-25");
        properties.put("createdBy", createdBy);
        this.designHandle.initializeModule(properties);
        ReportDesignHandleTest.assertEquals((int)0, (int)this.designHandle.getMasterPages().getCount());
        ReportDesignHandleTest.assertNull((Object)this.designHandle.getProperty("Build"));
        ReportDesignHandleTest.assertEquals((Object)createdBy, (Object)this.designHandle.getProperty("createdBy"));
        CommandStack stack = this.designHandle.getCommandStack();
        ReportDesignHandleTest.assertFalse((boolean)stack.canRedo());
        ReportDesignHandleTest.assertFalse((boolean)stack.canUndo());
    }

    private void assertEqualsOnWindows(String expected, String actual) {
        if (this.isWindowsPlatform()) {
            ReportDesignHandleTest.assertEquals((String)expected, (String)actual);
        }
    }

    public void testGetReportItemsBasedonTempalates() throws DesignFileException {
        this.openDesign("ReportDesignHandleTest3.xml");
        List result = this.designHandle.getReportItemsBasedonTempalates();
        ReportDesignHandleTest.assertEquals((int)6, (int)result.size());
        ReportDesignHandleTest.assertEquals((String)"template table 1", (String)((DesignElementHandle)result.get(0)).getName());
        ReportDesignHandleTest.assertEquals((String)"template inner table", (String)((DesignElementHandle)result.get(1)).getName());
        ReportDesignHandleTest.assertEquals((String)"inner label", (String)((DesignElementHandle)result.get(2)).getName());
        ReportDesignHandleTest.assertEquals((String)"tamplate label 2", (String)((DesignElementHandle)result.get(3)).getName());
        ReportDesignHandleTest.assertEquals((String)"label 3", (String)((DesignElementHandle)result.get(4)).getName());
        ReportDesignHandleTest.assertEquals((String)"label in master page", (String)((DesignElementHandle)result.get(5)).getName());
    }

    public void testLoadMessageFiles() throws DesignFileException, SemanticException {
        this.openDesign("TestLoadMessageFiles.xml", ULocale.CHINA);
        LabelHandle label1 = (LabelHandle)this.designHandle.findElement("label1");
        LabelHandle label2 = (LabelHandle)this.designHandle.findElement("label2");
        LabelHandle label3 = (LabelHandle)this.designHandle.findElement("label3");
        ReportDesignHandleTest.assertNotNull((Object)label1);
        ReportDesignHandleTest.assertNotNull((Object)label2);
        ReportDesignHandleTest.assertNotNull((Object)label3);
        label1.setTextKey("keyone");
        label2.setTextKey("keytwo");
        label2.setTextKey("keythree");
        ReportDesignHandleTest.assertEquals((String)"zh CN message file", (String)label1.getDisplayText());
        ReportDesignHandleTest.assertEquals((String)"key two", (String)label2.getDisplayText());
        ReportDesignHandleTest.assertEquals((String)"key three", (String)label3.getDisplayText());
    }

    public void testGetTOCStyle() throws Exception {
        this.createDesign();
        LabelHandle labelHandle = this.designHandle.getElementFactory().newLabel("Label1");
        this.designHandle.getBody().add((DesignElementHandle)labelHandle);
        SharedStyleHandle styleHandle = labelHandle.getModuleHandle().findStyle("TOC-level-2");
        ReportDesignHandleTest.assertEquals((String)"12pt", (String)styleHandle.getFontSize().getStringValue());
        labelHandle.setStyleName("TOC-level-1");
        styleHandle = labelHandle.getStyle();
        ReportDesignHandleTest.assertNotNull((Object)styleHandle);
        ReportDesignHandleTest.assertEquals((String)"sans-serif", (String)styleHandle.getFontFamilyHandle().getStringValue());
    }

    public void testGetVersionNo() throws Exception {
        ReportDesignHandleTest.assertEquals((String)"3.2.20", (String)this.designHandle.getVersion());
        this.createDesign();
        ReportDesignHandleTest.assertNull((Object)this.designHandle.getVersion());
    }

    public void testIncludeScriptsIterator() throws Exception {
        this.openDesign("IncludedScriptFileTest.xml");
        Iterator scriptIter = this.designHandle.includeLibraryScriptsIterator();
        IncludeScriptHandle script = (IncludeScriptHandle)scriptIter.next();
        ReportDesignHandleTest.assertEquals((String)"script first", (String)script.getFileName());
        script = (IncludeScriptHandle)scriptIter.next();
        ReportDesignHandleTest.assertEquals((String)"script second", (String)script.getFileName());
    }

    public void testIncludeScripts() throws Exception {
        this.openDesign("ReportDesignIncludeScriptParseTest.xml", ULocale.ENGLISH);
        IncludeScript includeScript = new IncludeScript();
        includeScript.setFileName(null);
        try {
            this.designHandle.addIncludeScript(includeScript);
            ReportDesignHandleTest.fail((String)"Not allowed set invalid value ");
        }
        catch (SemanticException e) {
            ReportDesignHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)e.getErrorCode());
        }
        List scriptList = this.designHandle.getAllIncludeScripts();
        ReportDesignHandleTest.assertEquals((int)2, (int)scriptList.size());
        includeScript.setFileName("third");
        this.designHandle.addIncludeScript(includeScript);
        this.designHandle.shifIncludeScripts(0, 2);
        Iterator iter1 = this.designHandle.includeScriptsIterator();
        IncludeScriptHandle scriptHandle = (IncludeScriptHandle)iter1.next();
        ReportDesignHandleTest.assertEquals((String)"second", (String)scriptHandle.getFileName());
        scriptHandle = (IncludeScriptHandle)iter1.next();
        ReportDesignHandleTest.assertEquals((String)"third", (String)scriptHandle.getFileName());
        scriptHandle = (IncludeScriptHandle)iter1.next();
        ReportDesignHandleTest.assertEquals((String)"first", (String)scriptHandle.getFileName());
        this.designHandle.dropIncludeScript(includeScript);
        ReportDesignHandleTest.assertEquals((int)2, (int)this.designHandle.getListProperty("includeScripts").size());
    }

    public void testCopyDesign() throws Exception {
        this.openDesign("ReportDesignCopyTest.xml");
        ReportDesignHandle designHandle1 = (ReportDesignHandle)this.designHandle.copy().getHandle(null);
        this.save((ModuleHandle)designHandle1);
        ReportDesignHandleTest.assertTrue((boolean)this.compareFile("ReportDesignCopyTest_golden.xml"));
    }

    public void testCopyTemplateParameterDefinition() throws Exception {
        this.openDesign("CopyTemplateParameterDefinitionTest.xml");
        SlotHandle slot = this.designHandle.getSlot(8);
        ReportDesignHandleTest.assertEquals((int)1, (int)slot.getCount());
        ReportDesignHandle copyDesignHandle = (ReportDesignHandle)this.designHandle.copy().getHandle(null);
        slot = copyDesignHandle.getSlot(8);
        ReportDesignHandleTest.assertEquals((int)0, (int)slot.getCount());
    }

    public void testGetFlattenElementName() throws Exception {
        this.openDesign("ReportDesignHandleTest4.xml");
        ReportDesignSerializer visitor = new ReportDesignSerializer();
        this.design.apply((ElementVisitor)visitor);
        ReportDesignHandle flattenDesign = (ReportDesignHandle)visitor.getTarget().getModuleHandle();
        DataSetHandle derivedDataSet = flattenDesign.findDataSet("union");
        ReportDesignHandleTest.assertNotNull((Object)derivedDataSet);
        DesignElementHandle dataSet1 = flattenDesign.getFlattenElement((DesignElementHandle)derivedDataSet, "ds1");
        DesignElementHandle dataSet2 = flattenDesign.getFlattenElement((DesignElementHandle)derivedDataSet, "ds2");
        ReportDesignHandleTest.assertNotNull((Object)dataSet1);
        ReportDesignHandleTest.assertNotNull((Object)dataSet2);
        ReportDesignHandleTest.assertEquals((String)"ds11", (String)dataSet1.getName());
        ReportDesignHandleTest.assertEquals((String)"ds21", (String)dataSet2.getName());
        ReportDesignHandleTest.assertTrue((boolean)(dataSet1 instanceof DataSetHandle));
        ReportDesignHandleTest.assertTrue((boolean)(dataSet2 instanceof DataSetHandle));
        ReportDesignHandleTest.assertEquals((String)"Lib DataSet 1", (String)((DataSetHandle)dataSet1).getDisplayName());
        ReportDesignHandleTest.assertEquals((String)"Lib DataSet 2", (String)((DataSetHandle)dataSet2).getDisplayName());
        ReportDesignHandleTest.assertNull((Object)flattenDesign.getFlattenElement(null, "ds1"));
        ReportDesignHandleTest.assertNull((Object)flattenDesign.getFlattenElement((DesignElementHandle)derivedDataSet, "NonExistedName"));
    }

    class DisposeListener
    implements IDisposeListener {
        private String status = null;

        DisposeListener() {
        }

        public void moduleDisposed(ModuleHandle targetElement, DisposeEvent ev) {
            this.status = "disposed";
        }

        public String getStatus() {
            return this.status;
        }
    }

    class FileNameListener
    implements IAttributeListener {
        private String status = null;

        FileNameListener() {
        }

        public void fileNameChanged(ModuleHandle targetElement, AttributeEvent ev) {
            this.status = targetElement.getFileName();
        }

        public String getStatus() {
            return this.status;
        }
    }

    class SelfDisposeListener
    implements IDisposeListener {
        private int status = 0;

        SelfDisposeListener() {
        }

        public void moduleDisposed(ModuleHandle targetElement, DisposeEvent ev) {
            targetElement.removeDisposeListener((IDisposeListener)this);
            ++this.status;
        }

        protected int getStatus() {
            return this.status;
        }
    }
}

