/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.IDesignEngine;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.DesignFileCompareUtil;
import org.eclipse.birt.report.model.util.ReportDesignSerializer;
import org.eclipse.birt.report.model.writer.DesignWriter;
import org.eclipse.birt.report.model.writer.DesignWriterUtil;
import org.junit.Assert;

public abstract class BaseTestCase
extends TestCase {
    protected static IDesignEngine engine = null;
    protected ReportDesignHandle designHandle = null;
    protected LibraryHandle libraryHandle = null;
    protected ModuleHandle moduleHandle = null;
    protected SessionHandle sessionHandle = null;
    protected ReportDesign design = null;
    protected ByteArrayOutputStream os = null;
    protected static final String ROM_DEF_NAME = "rom.def";
    protected static final String TEST_FOLDER = "test/";
    protected static final String OUTPUT_FOLDER = "/output/";
    protected static final String INPUT_FOLDER = "input/";
    protected static final String GOLDEN_FOLDER = "golden/";
    protected static final ULocale TEST_LOCALE = new ULocale("aa");
    protected ReportDesignHandle beforeSerializedDesignHandle = null;
    private static String PATTERN_VERSION = "version=\"[^\"]*\"";
    private static String PATTERN_ID = "id=\"\\d+\"";
    private static boolean IGNORE_VERSION_ID = true;

    protected void setUp() throws Exception {
        super.setUp();
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        if (engine == null) {
            MetaDataDictionary.reset();
            engine = new DesignEngine(new DesignConfig());
        }
    }

    protected void resetMetadata() {
        MetaDataDictionary.reset();
        MetaDataDictionary.initialize();
    }

    protected void tearDown() throws Exception {
        if (this.beforeSerializedDesignHandle != null) {
            this.designHandle = this.beforeSerializedDesignHandle;
        }
        if (this.designHandle != null) {
            this.designHandle.close();
        }
        if (this.libraryHandle != null) {
            this.libraryHandle.close();
        }
        if (this.os != null) {
            this.os.close();
        }
        super.tearDown();
    }

    protected ReportDesignHandle createDesign() {
        return this.createDesign(null);
    }

    protected ReportDesignHandle createDesign(ULocale locale) {
        if (engine == null) {
            engine = new DesignEngine(new DesignConfig());
            this.resetMetadata();
        }
        this.sessionHandle = engine.newSessionHandle(locale);
        this.designHandle = this.sessionHandle.createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        this.removeExtensionStyles(this.design);
        return this.designHandle;
    }

    private void removeExtensionStyles(ReportDesign design) {
        ContainerSlot styles = design.getSlot(0);
        styles.clear();
    }

    protected LibraryHandle createLibrary() {
        return this.createLibrary(null);
    }

    protected LibraryHandle createLibrary(ULocale locale) {
        if (engine == null) {
            engine = new DesignEngine(new DesignConfig());
            this.resetMetadata();
        }
        this.sessionHandle = engine.newSessionHandle(locale);
        this.libraryHandle = this.sessionHandle.createLibrary();
        return this.libraryHandle;
    }

    protected void openDesign(String fileName) throws DesignFileException {
        this.openDesign(fileName, true);
    }

    protected void openDesign(String fileName, boolean inSingleJarMode) throws DesignFileException {
        this.openDesign(fileName, ULocale.getDefault(), inSingleJarMode);
    }

    protected void openDesign(String fileName, ULocale locale, boolean inSingleJarMode) throws DesignFileException {
        if (inSingleJarMode) {
            fileName = INPUT_FOLDER + (String)fileName;
        }
        if (engine == null) {
            engine = new DesignEngine(new DesignConfig());
            this.resetMetadata();
        }
        this.sessionHandle = engine.newSessionHandle(locale);
        BaseTestCase.assertNotNull((Object)this.sessionHandle);
        if (inSingleJarMode) {
            String name = null;
            try {
                name = this.getResource((String)fileName).toString();
                this.designHandle = this.sessionHandle.openDesign(name);
            }
            catch (Exception e) {
                System.out.println("WIM - " + name);
                e.printStackTrace();
                throw e;
            }
        } else {
            this.designHandle = this.sessionHandle.openDesign((String)fileName);
        }
        this.design = (ReportDesign)this.designHandle.getModule();
    }

    protected void openDesign(String fileName, ULocale locale) throws DesignFileException {
        this.openDesign(fileName, locale, true);
    }

    protected void openLibrary(String fileName) throws DesignFileException {
        this.openLibrary(fileName, true);
    }

    protected void openLibrary(String fileName, boolean inSingleJarMode) throws DesignFileException {
        this.openLibrary(fileName, ULocale.getDefault(), inSingleJarMode);
    }

    protected void openLibrary(String fileName, ULocale locale) throws DesignFileException {
        this.openLibrary(fileName, locale, true);
    }

    protected void openLibrary(String fileName, ULocale locale, boolean inSingleJarMode) throws DesignFileException {
        if (inSingleJarMode) {
            fileName = INPUT_FOLDER + (String)fileName;
        }
        if (engine == null) {
            engine = new DesignEngine(new DesignConfig());
            this.resetMetadata();
        }
        this.sessionHandle = engine.newSessionHandle(locale);
        BaseTestCase.assertNotNull((Object)this.sessionHandle);
        this.libraryHandle = inSingleJarMode ? this.sessionHandle.openLibrary(this.getResource((String)fileName).toString(), this.getResourceAStream((String)fileName)) : this.sessionHandle.openLibrary((String)fileName);
    }

    protected void openModule(String fileName) throws DesignFileException {
        this.openModule(fileName, ULocale.getDefault());
    }

    protected void openModule(String fileName, ULocale locale) throws DesignFileException {
        if (engine == null) {
            engine = new DesignEngine(new DesignConfig());
            this.resetMetadata();
        }
        fileName = INPUT_FOLDER + (String)fileName;
        this.sessionHandle = engine.newSessionHandle(locale);
        BaseTestCase.assertNotNull((Object)this.sessionHandle);
        this.moduleHandle = this.sessionHandle.openModule(this.getResource((String)fileName).toString(), this.getResourceAStream((String)fileName));
    }

    protected void openDesign(String fileName, InputStream is) throws DesignFileException {
        this.openDesign(fileName, is, ULocale.getDefault());
    }

    protected void openDesign(String fileName, InputStream is, ULocale locale) throws DesignFileException {
        if (engine == null) {
            engine = new DesignEngine(new DesignConfig());
            this.resetMetadata();
        }
        this.sessionHandle = engine.newSessionHandle(locale);
        this.designHandle = this.sessionHandle.openDesign(fileName, is);
        this.design = (ReportDesign)this.designHandle.getModule();
    }

    protected boolean compareFile(String goldenFileName, String outputFileName) throws Exception {
        Reader readerA = null;
        InputStreamReader readerB = null;
        boolean same = true;
        StringBuilder errorText = new StringBuilder();
        try {
            try {
                goldenFileName = GOLDEN_FOLDER + (String)goldenFileName;
                outputFileName = this.getTempFolder() + OUTPUT_FOLDER + (String)outputFileName;
                readerA = new InputStreamReader(this.getResourceAStream((String)goldenFileName));
                readerB = new FileReader((String)outputFileName);
                same = this.compareFile(readerA, readerB);
            }
            catch (IOException e) {
                errorText.append(e.toString());
                errorText.append("\n");
                e.printStackTrace();
                try {
                    if (readerA != null) {
                        readerA.close();
                    }
                    if (readerB != null) {
                        readerB.close();
                    }
                }
                catch (Exception e2) {
                    readerA = null;
                    readerB = null;
                    errorText.append(e2.toString());
                    throw new Exception(errorText.toString());
                }
            }
        }
        finally {
            try {
                if (readerA != null) {
                    readerA.close();
                }
                if (readerB != null) {
                    readerB.close();
                }
            }
            catch (Exception e) {
                readerA = null;
                readerB = null;
                errorText.append(e.toString());
                throw new Exception(errorText.toString());
            }
        }
        return same;
    }

    protected boolean compareFile(String goldenFileName) throws Exception {
        String tmpGoldenFileName = GOLDEN_FOLDER + goldenFileName;
        InputStream streamA = this.getResourceAStream(tmpGoldenFileName);
        if (this.os == null) {
            return false;
        }
        String outContent = this.os.toString("utf-8");
        ByteArrayInputStream streamB = new ByteArrayInputStream(this.os.toByteArray());
        InputStreamReader readerA = new InputStreamReader(streamA);
        InputStreamReader readerB = new InputStreamReader(streamB);
        boolean ok = true;
        try {
            ok = this.compareFile(readerA, readerB);
        }
        catch (Exception e) {
            String outFileName = goldenFileName.replace("golden", "out");
            this.saveOutputFile(outFileName, outContent);
            throw e;
        }
        return ok;
    }

    private InputStream getGoldenFileAsStream(String goldenFileName) {
        InputStream streamA = this.getResourceAStream(goldenFileName);
        return streamA;
    }

    private InputStream getTestDesignFileAsStream(ByteArrayOutputStream byteOS) {
        ByteArrayInputStream streamB = new ByteArrayInputStream(byteOS.toByteArray());
        return streamB;
    }

    protected boolean compareDesignModel(String goldenFileName, String[] ignoredAttrs) throws Exception {
        InputStream goldenFileStream = this.getGoldenFileAsStream(GOLDEN_FOLDER + goldenFileName);
        InputStream designFileStream = this.getTestDesignFileAsStream(this.os);
        HashSet<String> ignoredSet = new HashSet<String>();
        String[] stringArray = ignoredAttrs;
        int n = ignoredAttrs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            ignoredSet.add(s);
            ++n2;
        }
        return new DesignFileCompareUtil(ignoredSet).compare(goldenFileStream, designFileStream);
    }

    private boolean compareLine(String line1, String line2) {
        if (line1 == line2) {
            return true;
        }
        if (line1 == null || line2 == null) {
            return false;
        }
        String l1 = line1.trim();
        String l2 = line2.trim();
        if (IGNORE_VERSION_ID) {
            l1 = l1.replaceAll(PATTERN_VERSION, "").replaceAll(PATTERN_ID, "");
            l2 = l2.replaceAll(PATTERN_VERSION, "").replaceAll(PATTERN_ID, "");
        }
        return l1.equals(l2);
    }

    private String[] readLines(Reader r1) throws IOException {
        BufferedReader br = new BufferedReader(r1);
        ArrayList<String> lines = new ArrayList<String>();
        String line = br.readLine();
        while (line != null) {
            lines.add(line.trim());
            line = br.readLine();
        }
        return lines.toArray(new String[lines.size()]);
    }

    private boolean compareFile(Reader r1, Reader r2) throws Exception {
        String[] lines1 = this.readLines(r1);
        String[] lines2 = this.readLines(r2);
        return this.compareFile(lines1, lines2);
    }

    private boolean compareFile(String[] goldens, String[] outputs) throws Exception {
        int lineCount = Math.min(goldens.length, outputs.length);
        int lineNo = 0;
        while (lineNo < lineCount) {
            String line1 = goldens[lineNo];
            String line2 = outputs[lineNo];
            if (!this.compareLine(line1, line2)) {
                this.raiseDiffAssert(goldens, outputs, lineNo);
            }
            ++lineNo;
        }
        if (goldens.length != outputs.length) {
            this.raiseDiffAssert(goldens, outputs, lineCount);
        }
        return true;
    }

    private String joinDiffLines(String[] lines, int lineNo) {
        StringBuilder sb = new StringBuilder();
        int start = Math.max(0, lineNo - 1);
        int end = Math.min(lines.length - 1, lineNo + 1);
        int i = start;
        while (i <= end) {
            sb.append(lines[i]);
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    private void raiseDiffAssert(String[] golden, String[] outputs, int lineNo) {
        Assert.assertSame((String)("lineNo:" + lineNo + " different"), (Object)this.joinDiffLines(golden, lineNo), (Object)this.joinDiffLines(outputs, lineNo));
    }

    protected boolean compareFileWithOS(String goldenFileName, ByteArrayOutputStream os) throws Exception {
        String tmpGoldenFileName = GOLDEN_FOLDER + goldenFileName;
        InputStream streamA = this.getResourceAStream(tmpGoldenFileName);
        if (os == null) {
            return false;
        }
        String outContent = os.toString("utf-8");
        ByteArrayInputStream streamB = new ByteArrayInputStream(os.toByteArray());
        InputStreamReader readerA = new InputStreamReader(streamA);
        InputStreamReader readerB = new InputStreamReader(streamB);
        boolean ok = true;
        try {
            ok = this.compareFile(readerA, readerB);
        }
        catch (Exception e) {
            String outFileName = goldenFileName.replace("golden", "out");
            this.saveOutputFile(outFileName, outContent);
            throw e;
        }
        return ok;
    }

    protected void printSemanticErrors() {
        this.printSemanticError(this.design);
    }

    protected void printSemanticError(ReportDesign design) {
        if (design != null) {
            this.printErrorList(design.getAllErrors());
        }
    }

    protected void printSyntaxError(DesignFileException e) {
        if (e != null) {
            this.printErrorList(e.getErrorList());
        }
    }

    private void printErrorList(List errors) {
        if (errors != null && !errors.isEmpty()) {
            for (ErrorDetail ex : errors) {
                System.out.println(ex);
            }
        }
    }

    protected void dumpErrors(String filename) throws Exception {
        String outputFolder = this.getTempFolder() + OUTPUT_FOLDER;
        File f = new File(outputFolder);
        if (!f.exists() && !f.mkdir()) {
            throw new Exception("Can not create the output folder!");
        }
        filename = outputFolder + (String)filename;
        if (this.design == null) {
            return;
        }
        PrintWriter writer = new PrintWriter(new FileOutputStream((String)filename));
        List errors = this.design.getAllErrors();
        ErrorDetail ex = null;
        int i = 0;
        while (i < errors.size()) {
            ex = (ErrorDetail)errors.get(i);
            writer.print(this.design.getFileName());
            writer.println(ex);
            ++i;
        }
        writer.close();
    }

    protected void save() throws IOException {
        this.save((ModuleHandle)this.designHandle);
    }

    protected void save(ModuleHandle moduleHandle) throws IOException {
        this.os = new ByteArrayOutputStream();
        if (moduleHandle != null) {
            moduleHandle.serialize((OutputStream)this.os);
        }
        this.os.close();
    }

    protected void saveLibrary() throws IOException {
        this.save((ModuleHandle)this.libraryHandle);
    }

    protected String getTempFolder() {
        Object tempDir = System.getProperty("java.io.tmpdir");
        if (!((String)tempDir).endsWith(File.separator)) {
            tempDir = (String)tempDir + File.separator;
        }
        String outputPath = (String)tempDir + "org.eclipse.birt.report.model" + this.getFullQualifiedClassName();
        return outputPath;
    }

    protected InputStream getResourceAStream(String name) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(name);
    }

    protected URL getResource(String name) {
        return ((Object)((Object)this)).getClass().getResource(name);
    }

    protected String getFullQualifiedClassName() {
        Object className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = ((String)className).lastIndexOf(".");
        className = ((String)className).substring(0, lastDotIndex);
        className = "/" + ((String)className).replace('.', '/');
        return className;
    }

    protected boolean isWindowsPlatform() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
    }

    protected String copyContentToFile(String resourceName) throws Exception {
        File tmpFolder;
        URL url = this.getResource(resourceName);
        InputStream is = url.openStream();
        Object folder = this.getTempFolder();
        int index = resourceName.lastIndexOf(INPUT_FOLDER);
        if (index > 0) {
            String relateDir = resourceName.substring(0, index - 1);
            folder = (String)folder + "/" + relateDir;
        }
        if (!(tmpFolder = new File((String)(folder = (String)folder + "/input/"))).exists()) {
            tmpFolder.mkdirs();
        }
        String filename = "";
        int lastSlash = resourceName.lastIndexOf("/");
        if (lastSlash != -1) {
            filename = resourceName.substring(lastSlash + 1);
        }
        FileOutputStream fos = new FileOutputStream((String)folder + filename);
        byte[] fileData = new byte[5120];
        int readCount = -1;
        while ((readCount = is.read(fileData)) != -1) {
            fos.write(fileData, 0, readCount);
        }
        fos.close();
        is.close();
        return (String)folder + filename;
    }

    protected void saveOutputFile(String fileName) throws Exception {
        String strDesign = this.os.toString();
        this.saveOutputFile(fileName, strDesign);
    }

    protected void saveOutputFile(String fileName, String content) throws Exception {
        String folder = this.getTempFolder() + OUTPUT_FOLDER;
        File tmpFolder = new File(folder);
        if (!tmpFolder.exists()) {
            tmpFolder.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(folder + fileName);
        fos.write(content.getBytes("UTF-8"));
        fos.close();
    }

    protected static String serializeStringList(List strs) {
        if (strs == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < strs.size()) {
            sb.append((String)strs.get(i));
            if (i != strs.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    protected void serializeDocument() throws Exception {
        this.serializeDocument(false);
    }

    protected void serializeDocument(boolean enableExternalDataMart) throws Exception {
        ReportDesignHandle beforeSerializedDesignHandle = this.designHandle;
        this.os = new ByteArrayOutputStream();
        ReportDesignSerializer visitor = new ReportDesignSerializer();
        this.designHandle.getModule().apply((ElementVisitor)visitor);
        this.design = visitor.getTarget();
        this.designHandle = (ReportDesignHandle)this.design.getHandle((Module)this.design);
        if (enableExternalDataMart) {
            this.design.prepareToSave();
            DesignWriter writer = (DesignWriter)this.design.getWriter();
            DesignWriterUtil.enableExternalDataMarts((DesignWriter)writer);
            writer.write((OutputStream)this.os);
            this.design.onSave();
        } else {
            this.designHandle.serialize((OutputStream)this.os);
        }
        this.beforeSerializedDesignHandle = beforeSerializedDesignHandle;
    }
}

