/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class Regression_120919
extends ChartTestCase {
    private static String GOLDEN = "Regression_120919.jpg";
    private static String OUTPUT = "Regression_120919.jpg";
    private Chart cm = null;
    private IDeviceRenderer dRenderer = null;
    private GeneratedChartState gcs = null;

    public static void main(String[] args) {
        new Regression_120919();
    }

    public Regression_120919() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dRenderer = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = this.createChart();
        this.bindGroupingData(this.cm);
        BufferedImage img = new BufferedImage(500, 500, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("device.file.identifier", (Object)this.genOutputFile(OUTPUT));
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)500.0, (double)500.0);
        bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.gcs = gr.build(this.dRenderer.getDisplayServer(), this.cm, bo, null, null, null);
            gr.render(this.dRenderer, this.gcs);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public void test_regression_120919() throws Exception {
        Regression_120919 st = new Regression_120919();
        Regression_120919.assertTrue((boolean)st.compareImages(GOLDEN, OUTPUT));
    }

    private void bindGroupingData(Chart chart) {
        final Object[][] data = new Object[][]{{new CDateTime(2005, 4, 1, 10, 12), new Double(143.26)}, {new CDateTime(2005, 4, 1, 11, 15), new Double(156.55)}, {new CDateTime(2005, 4, 1, 7, 15), new Double(95.25)}};
        try {
            Generator gr = Generator.instance();
            gr.bindData(new IDataRowExpressionEvaluator(){
                int idx = 0;

                public void close() {
                }

                public Object evaluate(String expression) {
                    if ("X".equals(expression)) {
                        return data[this.idx][0];
                    }
                    if ("Y".equals(expression)) {
                        return data[this.idx][1];
                    }
                    if ("G".equals(expression)) {
                        return data[this.idx][0];
                    }
                    return null;
                }

                public Object evaluateGlobal(String expression) {
                    return this.evaluate(expression);
                }

                public boolean first() {
                    this.idx = 0;
                    return true;
                }

                public boolean next() {
                    ++this.idx;
                    return this.idx < 2;
                }
            }, chart, new RunTimeContext());
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    private Chart createChart() {
        ChartWithAxes cwaBar = ChartWithAxesImpl.create();
        Axis xAxisPrimary = cwaBar.getPrimaryBaseAxes()[0];
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        Axis yAxisPrimary = cwaBar.getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        Series seCategory = SeriesImpl.create();
        Query xQ = QueryImpl.create((String)"G");
        seCategory.getDataDefinition().add((Object)xQ);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seCategory);
        sdX.getGrouping().setEnabled(true);
        sdX.getGrouping().setGroupType(DataType.DATE_TIME_LITERAL);
        sdX.getGrouping().setAggregateExpression("Sum");
        sdX.getGrouping().setGroupingUnit(GroupingUnitType.get((int)3));
        sdX.getGrouping().setGroupingInterval(1.0);
        BarSeries bs = (BarSeries)BarSeriesImpl.create();
        bs.getLabel().setVisible(false);
        Query yQ = QueryImpl.create((String)"Y");
        bs.getDataDefinition().add((Object)yQ);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeriesPalette().update(0);
        sdY.getSeries().add((Object)bs);
        return cwaBar;
    }
}

