/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class ModuleUtilTest
extends BaseTestCase {
    private final String reportName = "ModuleUtilTest_report.xml";
    private final String libraryName = "ModuleUtilTest_report.xml";
    private final String invalidreportName = "ModuleUtilTest_report_invalid.xml";
    private final String invalidlibraryName = "ModuleUtilTest_report_invalid.xml";

    public ModuleUtilTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ModuleUtilTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/ModuleUtilTest_report.xml");
        this.copyInputToFile("input/ModuleUtilTest_report.xml");
        this.copyInputToFile("input/ModuleUtilTest_report_invalid.xml");
        this.copyInputToFile("input/ModuleUtilTest_report_invalid.xml");
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public void testReportValidation() throws Exception {
        this.openDesign("ModuleUtilTest_report.xml");
        File file = new File(this.getTempFolder() + "/input/ModuleUtilTest_report.xml");
        FileInputStream is = new FileInputStream(file);
        SessionHandle session = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = session.openDesign(file.toString());
        ModuleUtilTest.assertTrue((boolean)ModuleUtil.isValidDesign((SessionHandle)session, (String)"ModuleUtilTest_report.xml", (InputStream)is));
        File file2 = new File(this.getTempFolder() + "/input/ModuleUtilTest_report_invalid.xml");
        FileInputStream is2 = new FileInputStream(file2);
        SessionHandle session2 = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        ModuleUtilTest.assertFalse((boolean)ModuleUtil.isValidDesign((SessionHandle)session2, (String)"ModuleUtilTest_report_invalid.xml", (InputStream)is2));
    }

    public void testLibraryValidation() throws Exception {
        this.openDesign("ModuleUtilTest_report.xml");
        File file = new File(this.getTempFolder() + "/input/ModuleUtilTest_report.xml");
        FileInputStream is = new FileInputStream(file);
        SessionHandle session = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = session.openDesign(file.toString());
        ModuleUtilTest.assertTrue((boolean)ModuleUtil.isValidDesign((SessionHandle)session, (String)"ModuleUtilTest_report.xml", (InputStream)is));
        File file2 = new File(this.getTempFolder() + "/input/ModuleUtilTest_report_invalid.xml");
        FileInputStream is2 = new FileInputStream(file2);
        SessionHandle session2 = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        ModuleUtilTest.assertFalse((boolean)ModuleUtil.isValidDesign((SessionHandle)session2, (String)"ModuleUtilTest_report_invalid.xml", (InputStream)is2));
    }
}

