/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;

public class SelectBuiltInTypesForFilteringDialog
extends CheckedTreeSelectionDialog {
    public static final String CUSTOM_LIST_SEPARATOR = "\n";

    public SelectBuiltInTypesForFilteringDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.init();
    }

    public CheckboxTreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    private void init() {
        this.setContainerMode(true);
        this.setTitle(Messages._UI_LABEL_SET_COMMON_BUILT_IN_TYPES);
        this.setMessage(Messages._UI_LABEL_SELECT_TYPES_FILTER_OUT);
    }

    public static String getTypesListInString(Object[] chosenTypes) {
        String returningList = "";
        int i = 0;
        while (i < chosenTypes.length) {
            if (chosenTypes[i] instanceof ComponentSpecification) {
                ComponentSpecification aType = (ComponentSpecification)chosenTypes[i];
                returningList = String.valueOf(returningList) + aType.getName() + CUSTOM_LIST_SEPARATOR;
            }
            ++i;
        }
        return returningList;
    }

    public static List getSelectedBuiltInTypesFromString(String listString, List aContainer) {
        ArrayList selectedTypes = new ArrayList();
        int i = 1;
        while (i < aContainer.size()) {
            Object o = aContainer.get(i);
            if (o instanceof ComponentSpecification) {
                ComponentSpecification aType = (ComponentSpecification)o;
                String typeName = aType.getName();
                if (listString.indexOf(String.valueOf(typeName) + CUSTOM_LIST_SEPARATOR) != -1) {
                    selectedTypes.add(o);
                }
            } else if (o instanceof List) {
                selectedTypes.addAll(SelectBuiltInTypesForFilteringDialog.getSelectedBuiltInTypesFromString(listString, (List)o));
            }
            ++i;
        }
        return selectedTypes;
    }
}

