/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.Messages;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextObjectEditor;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.validation.SyntaxCheckerUtils;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class NCNameObjectEditor
extends TextObjectEditor {
    public NCNameObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        super(parent, object, feature);
    }

    @Override
    protected Control createControl(Composite composite, String label, int style) {
        this.createLabel(composite, label);
        this.text = this.getToolkit().createText(composite, "");
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.text.setTextLimit(Bpmn2Preferences.getInstance(this.object).getTextLimit());
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (Character.isISOControl(e.character) && (e.text == null || e.text.isEmpty())) {
                    return;
                }
                String s = NCNameObjectEditor.this.getValue() + e.text;
                e.doit = SyntaxCheckerUtils.isNCName(s);
                if (!e.doit) {
                    if (SyntaxCheckerUtils.getInvalidChar() == '.') {
                        e.doit = true;
                    } else {
                        NCNameObjectEditor.this.showErrorMessage(NLS.bind((String)Messages.NCNameObjectEditor_Invalid_Character, (Object)e.text));
                    }
                }
            }
        });
        this.updateText();
        ISWTObservableValue textObserveTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.text);
        textObserveTextObserveWidget.addValueChangeListener((IValueChangeListener)new IValueChangeListener<String>(){

            public void handleValueChange(ValueChangeEvent<? extends String> event) {
                String s = NCNameObjectEditor.this.text.getText();
                if (!NCNameObjectEditor.this.getValue().equals(s)) {
                    NCNameObjectEditor.this.setValue(s);
                }
            }
        });
        return this.text;
    }

    @Override
    protected String getText() {
        Object value = this.getBusinessObjectDelegate().getValue(this.object, this.feature);
        return value == null ? "" : value.toString();
    }
}

