/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.events;

import java.util.ArrayList;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.BooleanObjectEditor;
import org.eclipse.bpmn2.modeler.ui.property.events.DataInputsListComposite;
import org.eclipse.bpmn2.modeler.ui.property.events.DataOutputsListComposite;
import org.eclipse.bpmn2.modeler.ui.property.events.EventDefinitionsListComposite;
import org.eclipse.bpmn2.modeler.ui.property.events.Messages;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.swt.widgets.Composite;

public class CommonEventDetailComposite
extends DefaultDetailComposite {
    protected AbstractListComposite inputTable;
    protected AbstractListComposite outputTable;
    protected EventDefinitionsListComposite eventsTable;

    public CommonEventDetailComposite(Composite parent, int style) {
        super(parent, style);
    }

    public CommonEventDetailComposite(AbstractBpmn2PropertySection section) {
        super(section);
    }

    public void cleanBindings() {
        super.cleanBindings();
        this.inputTable = null;
        this.outputTable = null;
        this.eventsTable = null;
    }

    protected void bindAttribute(Composite parent, EObject object, EAttribute attribute, String label) {
        if (this.isModelObjectEnabled(object.eClass(), (EStructuralFeature)attribute)) {
            if (object instanceof BoundaryEvent && attribute == Bpmn2Package.eINSTANCE.getBoundaryEvent_CancelActivity()) {
                final BoundaryEvent be = (BoundaryEvent)object;
                if (label == null) {
                    label = this.getBusinessObjectDelegate().getLabel((EObject)be, (EStructuralFeature)attribute);
                }
                BooleanObjectEditor editor = new BooleanObjectEditor((AbstractDetailComposite)this, (EObject)be, (EStructuralFeature)attribute){

                    public boolean setValue(Object result) {
                        if (CommonEventDetailComposite.this.hasEventDefinition(be, ErrorEventDefinition.class)) {
                            CommonEventDetailComposite.this.setCancel(be, true);
                            this.setVisible(true);
                        } else if (CommonEventDetailComposite.this.hasEventDefinition(be, CompensateEventDefinition.class)) {
                            CommonEventDetailComposite.this.setCancel(be, false);
                            this.setVisible(false);
                        } else if (result instanceof Boolean) {
                            CommonEventDetailComposite.this.setCancel(be, (Boolean)result);
                            this.setVisible(true);
                        }
                        return true;
                    }

                    public void notifyChanged(Notification notification) {
                        super.notifyChanged(notification);
                        if (notification.getEventType() == -1) {
                            boolean cancel = be.isCancelActivity();
                            if (CommonEventDetailComposite.this.hasEventDefinition(be, ErrorEventDefinition.class)) {
                                if (!cancel) {
                                    CommonEventDetailComposite.this.setCancel(be, true);
                                    this.setVisible(true);
                                }
                            } else if (CommonEventDetailComposite.this.hasEventDefinition(be, CompensateEventDefinition.class)) {
                                if (cancel) {
                                    CommonEventDetailComposite.this.setCancel(be, false);
                                    this.setVisible(false);
                                }
                            } else if (cancel != this.button.getSelection()) {
                                CommonEventDetailComposite.this.setCancel(be, this.button.getSelection());
                                this.setVisible(true);
                            }
                        }
                    }
                };
                editor.createControl(this.getAttributesParent(), label);
            } else {
                super.bindAttribute(parent, object, attribute, label);
            }
        }
    }

    private void setCancel(final BoundaryEvent be, final boolean cancel) {
        TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                be.setCancelActivity(cancel);
            }
        });
    }

    private boolean hasEventDefinition(BoundaryEvent be, Class clazz) {
        for (EventDefinition ed : be.getEventDefinitions()) {
            if (!clazz.isInstance(ed)) continue;
            return true;
        }
        return false;
    }

    public AbstractPropertiesProvider getPropertiesProvider(final EObject object) {
        if (this.propertiesProvider == null) {
            this.propertiesProvider = new AbstractPropertiesProvider(object){

                public String[] getProperties() {
                    CatchEvent ce;
                    SubProcess sp;
                    ArrayList<String> result = new ArrayList<String>();
                    if (object instanceof StartEvent && object.eContainer() instanceof SubProcess && (sp = (SubProcess)object.eContainer()).isTriggeredByEvent()) {
                        result.add("isInterrupting");
                    }
                    if (object instanceof CatchEvent && (ce = (CatchEvent)object).getEventDefinitions().size() > 1) {
                        result.add("parallelMultiple");
                    }
                    if (object instanceof BoundaryEvent) {
                        boolean add = true;
                        BoundaryEvent be = (BoundaryEvent)object;
                        for (EventDefinition ed : be.getEventDefinitions()) {
                            if (!(ed instanceof ErrorEventDefinition) && !(ed instanceof CompensateEventDefinition)) continue;
                            add = false;
                            break;
                        }
                        if (add) {
                            result.add("cancelActivity");
                        }
                    }
                    result.add("eventDefinitions");
                    result.add("dataInputs");
                    result.add("dataOutputs");
                    result.add("properties");
                    return result.toArray(new String[result.size()]);
                }
            };
        }
        return this.propertiesProvider;
    }

    protected AbstractListComposite bindList(EObject object, EStructuralFeature feature, EClass listItemClass) {
        if (object instanceof CatchEvent || object instanceof ThrowEvent) {
            if (this.isModelObjectEnabled(object.eClass(), feature)) {
                if ("eventDefinitions".equals(feature.getName())) {
                    this.eventsTable = new EventDefinitionsListComposite((Composite)this, (Event)object);
                    this.eventsTable.bindList(object, feature);
                    this.eventsTable.setTitle(Messages.CommonEventDetailComposite_Event_Definition_Title);
                    return this.eventsTable;
                }
                if ("dataInputs".equals(feature.getName()) && object instanceof ThrowEvent) {
                    ThrowEvent throwEvent = (ThrowEvent)object;
                    this.inputTable = new DataInputsListComposite((Composite)this, throwEvent);
                    this.inputTable.bindList(object, feature);
                    this.inputTable.setTitle(Messages.CommonEventDetailComposite_Input_Parameters_Title);
                    return this.inputTable;
                }
                if ("dataOutputs".equals(feature.getName()) && object instanceof CatchEvent) {
                    CatchEvent catchEvent = (CatchEvent)object;
                    this.outputTable = new DataOutputsListComposite((Composite)this, catchEvent);
                    this.outputTable.bindList((EObject)catchEvent, feature);
                    this.outputTable.setTitle(Messages.CommonEventDetailComposite_Output_Parameters_Title);
                    return this.outputTable;
                }
                if ("properties".equals(feature.getName())) {
                    return super.bindList(object, feature, listItemClass);
                }
            }
            return null;
        }
        return super.bindList(object, feature, listItemClass);
    }
}

