/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.gradleware.tooling.toolingclient.BuildActionRequest;
import com.gradleware.tooling.toolingclient.Consumer;
import com.gradleware.tooling.toolingclient.ModelRequest;
import com.gradleware.tooling.toolingclient.Request;
import com.gradleware.tooling.toolingclient.ToolingClient;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.OmniBuildInvocationsContainer;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniGradleBuildStructure;
import com.gradleware.tooling.toolingmodel.buildaction.BuildActionFactory;
import com.gradleware.tooling.toolingmodel.buildaction.ModelForAllProjectsBuildAction;
import com.gradleware.tooling.toolingmodel.repository.BuildEnvironmentUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.BuildInvocationsUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.EclipseGradleBuildUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.Environment;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.GradleBuildStructureUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.GradleBuildUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.ModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.internal.BaseConverter;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniBuildInvocationsContainer;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniGradleBuild;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniGradleBuildStructure;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.gradle.BuildInvocations;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.util.GradleVersion;

public final class DefaultModelRepository
implements ModelRepository {
    private final FixedRequestAttributes fixedRequestAttributes;
    private final ToolingClient toolingClient;
    private final EventBus eventBus;
    private final Cache<Class<?>, Object> cache;
    private final Environment environment;

    public DefaultModelRepository(FixedRequestAttributes fixedRequestAttributes, ToolingClient toolingClient, EventBus eventBus) {
        this(fixedRequestAttributes, toolingClient, eventBus, Environment.STANDALONE);
    }

    public DefaultModelRepository(FixedRequestAttributes fixedRequestAttributes, ToolingClient toolingClient, EventBus eventBus, Environment environment) {
        this.fixedRequestAttributes = (FixedRequestAttributes)Preconditions.checkNotNull((Object)fixedRequestAttributes);
        this.toolingClient = (ToolingClient)Preconditions.checkNotNull((Object)toolingClient);
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.cache = CacheBuilder.newBuilder().build();
        this.environment = environment;
    }

    @Override
    public void register(Object listener) {
        Preconditions.checkNotNull((Object)listener);
        this.eventBus.register(listener);
    }

    @Override
    public void unregister(Object listener) {
        Preconditions.checkNotNull((Object)listener);
        this.eventBus.unregister(listener);
    }

    @Override
    public OmniBuildEnvironment fetchBuildEnvironment(TransientRequestAttributes transientRequestAttributes, FetchStrategy fetchStrategy) {
        Preconditions.checkNotNull((Object)transientRequestAttributes);
        Preconditions.checkNotNull((Object)((Object)fetchStrategy));
        ModelRequest<BuildEnvironment> request = this.createModelRequestForBuildModel(BuildEnvironment.class, transientRequestAttributes);
        Consumer<OmniBuildEnvironment> successHandler = new Consumer<OmniBuildEnvironment>(){

            public void accept(OmniBuildEnvironment result) {
                DefaultModelRepository.this.eventBus.post((Object)new BuildEnvironmentUpdateEvent(result));
            }
        };
        BaseConverter<BuildEnvironment, OmniBuildEnvironment> converter = new BaseConverter<BuildEnvironment, OmniBuildEnvironment>(){

            @Override
            protected OmniBuildEnvironment doForward(BuildEnvironment buildEnvironment) {
                return DefaultOmniBuildEnvironment.from(buildEnvironment);
            }
        };
        return this.executeRequest((Request)request, (Consumer)successHandler, fetchStrategy, (Class)OmniBuildEnvironment.class, (Converter)converter);
    }

    @Override
    public OmniGradleBuildStructure fetchGradleBuildStructure(TransientRequestAttributes transientRequestAttributes, FetchStrategy fetchStrategy) {
        Preconditions.checkNotNull((Object)transientRequestAttributes);
        Preconditions.checkNotNull((Object)((Object)fetchStrategy));
        ModelRequest<GradleBuild> request = this.createModelRequestForBuildModel(GradleBuild.class, transientRequestAttributes);
        Consumer<OmniGradleBuildStructure> successHandler = new Consumer<OmniGradleBuildStructure>(){

            public void accept(OmniGradleBuildStructure result) {
                DefaultModelRepository.this.eventBus.post((Object)new GradleBuildStructureUpdateEvent(result));
            }
        };
        BaseConverter<GradleBuild, OmniGradleBuildStructure> converter = new BaseConverter<GradleBuild, OmniGradleBuildStructure>(){

            @Override
            protected OmniGradleBuildStructure doForward(GradleBuild gradleBuild) {
                return DefaultOmniGradleBuildStructure.from(gradleBuild);
            }
        };
        return this.executeRequest((Request)request, (Consumer)successHandler, fetchStrategy, (Class)OmniGradleBuildStructure.class, (Converter)converter);
    }

    @Override
    public OmniGradleBuild fetchGradleBuild(TransientRequestAttributes transientRequestAttributes, FetchStrategy fetchStrategy) {
        Preconditions.checkNotNull((Object)transientRequestAttributes);
        Preconditions.checkNotNull((Object)((Object)fetchStrategy));
        final boolean requiresIsPublicFix = this.targetGradleVersionIsBetween("2.1", "2.2.1", transientRequestAttributes);
        ModelRequest<GradleProject> request = this.createModelRequestForBuildModel(GradleProject.class, transientRequestAttributes);
        Consumer<OmniGradleBuild> successHandler = new Consumer<OmniGradleBuild>(){

            public void accept(OmniGradleBuild result) {
                DefaultModelRepository.this.eventBus.post((Object)new GradleBuildUpdateEvent(result));
            }
        };
        BaseConverter<GradleProject, OmniGradleBuild> converter = new BaseConverter<GradleProject, OmniGradleBuild>(){

            @Override
            protected OmniGradleBuild doForward(GradleProject gradleProject) {
                return DefaultOmniGradleBuild.from(gradleProject, requiresIsPublicFix);
            }
        };
        return this.executeRequest((Request)request, (Consumer)successHandler, fetchStrategy, (Class)OmniGradleBuild.class, (Converter)converter);
    }

    @Override
    public OmniEclipseGradleBuild fetchEclipseGradleBuild(TransientRequestAttributes transientRequestAttributes, FetchStrategy fetchStrategy) {
        Preconditions.checkNotNull((Object)transientRequestAttributes);
        Preconditions.checkNotNull((Object)((Object)fetchStrategy));
        final boolean requiresIsPublicFix = this.targetGradleVersionIsBetween("2.1", "2.2.1", transientRequestAttributes);
        ModelRequest<EclipseProject> request = this.createModelRequestForBuildModel(EclipseProject.class, transientRequestAttributes);
        Consumer<OmniEclipseGradleBuild> successHandler = new Consumer<OmniEclipseGradleBuild>(){

            public void accept(OmniEclipseGradleBuild result) {
                DefaultModelRepository.this.eventBus.post((Object)new EclipseGradleBuildUpdateEvent(result));
            }
        };
        BaseConverter<EclipseProject, OmniEclipseGradleBuild> converter = new BaseConverter<EclipseProject, OmniEclipseGradleBuild>(){

            @Override
            protected OmniEclipseGradleBuild doForward(EclipseProject eclipseProject) {
                return DefaultOmniEclipseGradleBuild.from(eclipseProject, requiresIsPublicFix);
            }
        };
        return this.executeRequest((Request)request, (Consumer)successHandler, fetchStrategy, (Class)OmniEclipseGradleBuild.class, (Converter)converter);
    }

    @Override
    public OmniBuildInvocationsContainer fetchBuildInvocations(final TransientRequestAttributes transientRequestAttributes, final FetchStrategy fetchStrategy) {
        Preconditions.checkNotNull((Object)transientRequestAttributes);
        Preconditions.checkNotNull((Object)((Object)fetchStrategy));
        if (!this.supportsBuildInvocations(transientRequestAttributes) || !this.supportsBuildActions(transientRequestAttributes)) {
            Supplier<OmniBuildInvocationsContainer> operation = new Supplier<OmniBuildInvocationsContainer>(){

                public OmniBuildInvocationsContainer get() {
                    return DefaultModelRepository.this.deriveBuildInvocationsFromOtherModel(transientRequestAttributes, fetchStrategy);
                }
            };
            Consumer<OmniBuildInvocationsContainer> successHandler = new Consumer<OmniBuildInvocationsContainer>(){

                public void accept(OmniBuildInvocationsContainer result) {
                    DefaultModelRepository.this.eventBus.post((Object)new BuildInvocationsUpdateEvent(result));
                }
            };
            Converter converter = Converter.identity();
            return this.executeRequest(operation, successHandler, fetchStrategy, OmniBuildInvocationsContainer.class, converter);
        }
        BuildActionRequest<Map<String, BuildInvocations>> request = this.createBuildActionRequestForProjectModel(BuildInvocations.class, transientRequestAttributes);
        Consumer<OmniBuildInvocationsContainer> successHandler = new Consumer<OmniBuildInvocationsContainer>(){

            public void accept(OmniBuildInvocationsContainer result) {
                DefaultModelRepository.this.eventBus.post((Object)new BuildInvocationsUpdateEvent(result));
            }
        };
        BaseConverter<Map<String, BuildInvocations>, OmniBuildInvocationsContainer> converter = new BaseConverter<Map<String, BuildInvocations>, OmniBuildInvocationsContainer>(){

            @Override
            protected OmniBuildInvocationsContainer doForward(Map<String, BuildInvocations> buildInvocations) {
                return DefaultOmniBuildInvocationsContainer.from(buildInvocations);
            }
        };
        return this.executeRequest((Request)request, (Consumer)successHandler, fetchStrategy, (Class)OmniBuildInvocationsContainer.class, (Converter)converter);
    }

    private OmniBuildInvocationsContainer deriveBuildInvocationsFromOtherModel(TransientRequestAttributes transientRequestAttributes, FetchStrategy fetchStrategy) {
        if (fetchStrategy == FetchStrategy.FORCE_RELOAD) {
            OmniGradleBuild gradleBuild = this.fetchGradleBuild(transientRequestAttributes, FetchStrategy.FORCE_RELOAD);
            return DefaultOmniBuildInvocationsContainer.from(gradleBuild.getRootProject());
        }
        OmniGradleBuild gradleBuild = this.fetchGradleBuild(transientRequestAttributes, FetchStrategy.FROM_CACHE_ONLY);
        if (gradleBuild != null) {
            return DefaultOmniBuildInvocationsContainer.from(gradleBuild.getRootProject());
        }
        OmniEclipseGradleBuild eclipseGradleBuild = this.fetchEclipseGradleBuild(transientRequestAttributes, FetchStrategy.FROM_CACHE_ONLY);
        if (eclipseGradleBuild != null) {
            return DefaultOmniBuildInvocationsContainer.from(eclipseGradleBuild.getRootProject());
        }
        gradleBuild = this.fetchGradleBuild(transientRequestAttributes, fetchStrategy);
        return DefaultOmniBuildInvocationsContainer.from(gradleBuild.getRootProject());
    }

    private boolean supportsBuildInvocations(TransientRequestAttributes transientRequestAttributes) {
        return this.targetGradleVersionIsEqualOrHigherThan("1.12", transientRequestAttributes);
    }

    private boolean supportsBuildActions(TransientRequestAttributes transientRequestAttributes) {
        if (this.environment == Environment.ECLIPSE) {
            return this.targetGradleVersionIsEqualOrHigherThan("2.3", transientRequestAttributes);
        }
        return this.targetGradleVersionIsEqualOrHigherThan("1.8", transientRequestAttributes);
    }

    private boolean targetGradleVersionIsBetween(String minVersion, String maxVersion, TransientRequestAttributes transientRequestAttributes) {
        OmniBuildEnvironment buildEnvironment = this.fetchBuildEnvironment(transientRequestAttributes, FetchStrategy.LOAD_IF_NOT_CACHED);
        GradleVersion gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        return gradleVersion.getBaseVersion().compareTo(GradleVersion.version((String)minVersion)) >= 0 && gradleVersion.getBaseVersion().compareTo(GradleVersion.version((String)maxVersion)) <= 0;
    }

    private boolean targetGradleVersionIsEqualOrHigherThan(String refVersion, TransientRequestAttributes transientRequestAttributes) {
        OmniBuildEnvironment buildEnvironment = this.fetchBuildEnvironment(transientRequestAttributes, FetchStrategy.LOAD_IF_NOT_CACHED);
        GradleVersion gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        return gradleVersion.getBaseVersion().compareTo(GradleVersion.version((String)refVersion)) >= 0;
    }

    private <T, U> U executeRequest(final Request<T> request, Consumer<U> newCacheEntryHandler, FetchStrategy fetchStrategy, Class<U> cacheKey, Converter<T, U> resultConverter) {
        return this.executeRequest(new Supplier<T>(){

            public T get() {
                return request.executeAndWait();
            }
        }, newCacheEntryHandler, fetchStrategy, cacheKey, resultConverter);
    }

    private <T, U> U executeRequest(final Supplier<T> operation, Consumer<U> newCacheEntryHandler, FetchStrategy fetchStrategy, Class<U> cacheKey, final Converter<T, U> resultConverter) {
        if (FetchStrategy.FROM_CACHE_ONLY == fetchStrategy) {
            Object result = this.cache.getIfPresent(cacheKey);
            return cacheKey.cast(result);
        }
        if (FetchStrategy.FORCE_RELOAD == fetchStrategy) {
            this.cache.invalidate(cacheKey);
        }
        final AtomicBoolean modelLoaded = new AtomicBoolean(false);
        U value = this.getFromCache(cacheKey, new Callable<U>(){

            @Override
            public U call() {
                Object model = DefaultModelRepository.this.executeAndWait(operation, resultConverter);
                modelLoaded.set(true);
                return model;
            }
        });
        if (modelLoaded.get()) {
            newCacheEntryHandler.accept(value);
        }
        return value;
    }

    private <U> U getFromCache(Class<U> cacheKey, Callable<U> cacheValueLoader) {
        try {
            Object result = this.cache.get(cacheKey, cacheValueLoader);
            return cacheKey.cast(result);
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private <T> ModelRequest<T> createModelRequestForBuildModel(Class<T> model, TransientRequestAttributes transientRequestAttributes) {
        ModelRequest request = this.toolingClient.newModelRequest(model);
        this.fixedRequestAttributes.apply((Request<?>)request);
        transientRequestAttributes.apply((Request<?>)request);
        return request;
    }

    private <T> BuildActionRequest<Map<String, T>> createBuildActionRequestForProjectModel(Class<T> model, TransientRequestAttributes transientRequestAttributes) {
        ModelForAllProjectsBuildAction<T> buildAction = BuildActionFactory.getModelForAllProjects(model);
        BuildActionRequest request = this.toolingClient.newBuildActionRequest(buildAction);
        this.fixedRequestAttributes.apply((Request<?>)request);
        transientRequestAttributes.apply((Request<?>)request);
        return request;
    }

    private <T> BuildActionRequest<T> createBuildActionRequestForBuildAction(BuildAction<T> buildAction, TransientRequestAttributes transientRequestAttributes) {
        BuildActionRequest request = this.toolingClient.newBuildActionRequest(buildAction);
        this.fixedRequestAttributes.apply((Request<?>)request);
        transientRequestAttributes.apply((Request<?>)request);
        return request;
    }

    private <T, U> U executeAndWait(Supplier<T> operation, Converter<T, U> resultConverter) {
        Object result = operation.get();
        return (U)resultConverter.convert(result);
    }
}

