/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.jarjar.com.google.common.collect.ImmutableList;
import org.gradle.jarjar.com.google.common.collect.ImmutableSet;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestExecutionException;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.events.test.TestOperationDescriptor;
import org.gradle.tooling.internal.consumer.AbstractLongRunningOperation;
import org.gradle.tooling.internal.consumer.BlockingResultHandler;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.DefaultInternalJvmTestRequest;
import org.gradle.tooling.internal.consumer.TestExecutionRequest;
import org.gradle.tooling.internal.consumer.async.AsyncConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ConsumerAction;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.protocol.test.InternalJvmTestRequest;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTestLauncher
extends AbstractLongRunningOperation<DefaultTestLauncher>
implements TestLauncher {
    private final AsyncConsumerActionExecutor connection;
    private final Set<TestOperationDescriptor> operationDescriptors = new LinkedHashSet<TestOperationDescriptor>();
    private final Set<String> testClassNames = new LinkedHashSet<String>();
    private final Set<InternalJvmTestRequest> internalJvmTestRequests = new LinkedHashSet<InternalJvmTestRequest>();

    public DefaultTestLauncher(AsyncConsumerActionExecutor connection, ConnectionParameters parameters) {
        super(parameters);
        this.operationParamsBuilder.setTasks(Collections.<String>emptyList());
        this.operationParamsBuilder.setEntryPoint("TestLauncher API");
        this.connection = connection;
    }

    @Override
    protected DefaultTestLauncher getThis() {
        return this;
    }

    @Override
    public TestLauncher withTests(TestOperationDescriptor ... testDescriptors) {
        this.withTests(Arrays.asList(testDescriptors));
        return this;
    }

    @Override
    public TestLauncher withTests(Iterable<? extends TestOperationDescriptor> descriptors) {
        this.operationDescriptors.addAll(CollectionUtils.toList(descriptors));
        return this;
    }

    @Override
    public TestLauncher withJvmTestClasses(String ... classNames) {
        this.withJvmTestClasses(Arrays.asList(classNames));
        return this;
    }

    @Override
    public TestLauncher withJvmTestClasses(Iterable<String> testClasses) {
        List<InternalJvmTestRequest> newRequests = CollectionUtils.collect(testClasses, new Transformer<InternalJvmTestRequest, String>(){

            @Override
            public InternalJvmTestRequest transform(String testClass) {
                return new DefaultInternalJvmTestRequest(testClass, null);
            }
        });
        this.internalJvmTestRequests.addAll(newRequests);
        this.testClassNames.addAll(CollectionUtils.toList(testClasses));
        return this;
    }

    @Override
    public TestLauncher withJvmTestMethods(String testClass, String ... methods) {
        this.withJvmTestMethods(testClass, Arrays.asList(methods));
        return this;
    }

    @Override
    public TestLauncher withJvmTestMethods(final String testClass, Iterable<String> methods) {
        List<InternalJvmTestRequest> newRequests = CollectionUtils.collect(methods, new Transformer<InternalJvmTestRequest, String>(){

            @Override
            public InternalJvmTestRequest transform(String methodName) {
                return new DefaultInternalJvmTestRequest(testClass, methodName);
            }
        });
        this.internalJvmTestRequests.addAll(newRequests);
        this.testClassNames.add(testClass);
        return this;
    }

    @Override
    public void run() {
        BlockingResultHandler<Void> handler = new BlockingResultHandler<Void>(Void.class);
        this.run(handler);
        handler.getResult();
    }

    @Override
    public void run(ResultHandler<? super Void> handler) {
        if (this.operationDescriptors.isEmpty() && this.internalJvmTestRequests.isEmpty()) {
            throw new TestExecutionException("No test declared for execution.");
        }
        final ConsumerOperationParameters operationParameters = this.getConsumerOperationParameters();
        final TestExecutionRequest testExecutionRequest = new TestExecutionRequest(this.operationDescriptors, ImmutableList.copyOf(this.testClassNames), ImmutableSet.copyOf(this.internalJvmTestRequests));
        this.connection.run(new ConsumerAction<Void>(){

            @Override
            public ConsumerOperationParameters getParameters() {
                return operationParameters;
            }

            @Override
            public Void run(ConsumerConnection connection) {
                connection.runTests(testExecutionRequest, this.getParameters());
                return null;
            }
        }, new ResultHandlerAdapter(handler));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultHandlerAdapter
    extends org.gradle.tooling.internal.consumer.ResultHandlerAdapter<Void> {
        public ResultHandlerAdapter(ResultHandler<? super Void> handler) {
            super(handler);
        }

        @Override
        protected String connectionFailureMessage(Throwable failure) {
            return String.format("Could not execute tests using %s.", DefaultTestLauncher.this.connection.getDisplayName());
        }
    }
}

