/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.gradle.Specs;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

final class ProjectNameUpdater {
    ProjectNameUpdater() {
    }

    static IProject updateProjectName(IProject workspaceProject, OmniEclipseProject project, OmniEclipseGradleBuild gradleBuild, IProgressMonitor monitor) {
        String newName = ProjectNameUpdater.normalizeProjectName(project);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (newName.equals(workspaceProject.getName())) {
            return workspaceProject;
        }
        ProjectNameUpdater.ensureProjectNameIsFree(newName, gradleBuild, (IProgressMonitor)progress.newChild(1));
        return CorePlugin.workspaceOperations().renameProject(workspaceProject, newName, (IProgressMonitor)progress.newChild(1));
    }

    static void ensureProjectNameIsFree(OmniEclipseProject project, OmniEclipseGradleBuild gradleBuild, IProgressMonitor monitor) {
        String name = ProjectNameUpdater.normalizeProjectName(project);
        ProjectNameUpdater.ensureProjectNameIsFree(name, gradleBuild, monitor);
    }

    private static void ensureProjectNameIsFree(String normalizedProjectName, OmniEclipseGradleBuild gradleBuild, IProgressMonitor monitor) {
        Optional<IProject> possibleDuplicate = CorePlugin.workspaceOperations().findProjectByName(normalizedProjectName);
        if (possibleDuplicate.isPresent()) {
            IProject duplicate = (IProject)possibleDuplicate.get();
            if (ProjectNameUpdater.isScheduledForRenaming(duplicate, gradleBuild)) {
                ProjectNameUpdater.renameTemporarily(duplicate, monitor);
            } else {
                String message = String.format("A project with the name %s already exists.", normalizedProjectName);
                throw new GradlePluginsRuntimeException(message);
            }
        }
    }

    private static boolean isScheduledForRenaming(IProject duplicate, OmniEclipseGradleBuild gradleBuild) {
        if (!duplicate.isOpen()) {
            return false;
        }
        Optional duplicateEclipseProject = gradleBuild.getRootEclipseProject().tryFind(Specs.eclipseProjectMatchesProjectDir(duplicate.getLocation().toFile()));
        if (!duplicateEclipseProject.isPresent()) {
            return false;
        }
        String newName = ProjectNameUpdater.normalizeProjectName((OmniEclipseProject)duplicateEclipseProject.get());
        return !newName.equals(duplicate.getName());
    }

    private static void renameTemporarily(IProject duplicate, IProgressMonitor monitor) {
        CorePlugin.workspaceOperations().renameProject(duplicate, duplicate.getName() + "-" + duplicate.getName().hashCode(), monitor);
    }

    private static String normalizeProjectName(OmniEclipseProject project) {
        return CorePlugin.workspaceOperations().normalizeProjectName(project.getName(), project.getProjectDirectory());
    }
}

