/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.workspace.internal.StringSetProjectProperty;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

final class DerivedResourcesUpdater {
    private final IProject project;
    private final ImmutableList<String> derivedResources;

    private DerivedResourcesUpdater(IProject project, List<String> derivedResources) {
        this.project = (IProject)Preconditions.checkNotNull((Object)project);
        this.derivedResources = ImmutableList.copyOf(derivedResources);
    }

    private void update(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            this.removePreviousMarkers(progress.newChild(1));
            this.addNewMarkers(progress.newChild(1));
        }
        catch (CoreException e) {
            String message = String.format("Could not update derived resources on project %s.", this.project.getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void removePreviousMarkers(SubMonitor progress) throws CoreException {
        StringSetProjectProperty knownDerivedResources = this.getKnownDerivedResources(this.project);
        Set<String> previouslyKnownDerivedResources = knownDerivedResources.get();
        progress.setWorkRemaining(previouslyKnownDerivedResources.size());
        for (String resourceName : previouslyKnownDerivedResources) {
            this.setDerived(resourceName, false, progress.newChild(1));
        }
    }

    private void addNewMarkers(SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(this.derivedResources.size());
        StringSetProjectProperty knownDerivedResources = this.getKnownDerivedResources(this.project);
        for (String resourceName : this.derivedResources) {
            this.setDerived(resourceName, true, progress.newChild(1));
        }
        knownDerivedResources.set(Sets.newLinkedHashSet(this.derivedResources));
    }

    private void setDerived(String resourceName, boolean derived, SubMonitor progress) throws CoreException {
        IResource derivedResource = this.project.findMember(resourceName);
        if (derivedResource != null) {
            derivedResource.setDerived(derived, (IProgressMonitor)progress);
        }
    }

    private StringSetProjectProperty getKnownDerivedResources(IProject project) {
        return StringSetProjectProperty.from(project, "derived.resources");
    }

    static void update(IProject project, List<String> derivedResources, IProgressMonitor monitor) {
        new DerivedResourcesUpdater(project, derivedResources).update(monitor);
    }

    static void clear(IProject project, IProgressMonitor monitor) {
        new DerivedResourcesUpdater(project, (List<String>)ImmutableList.of()).update(monitor);
    }
}

