/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

public final class ObservableMapCellWithIconLabelProvider
extends ObservableMapCellLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final ImmutableMap<String, ColorDescriptor> customTextColoringMapping;
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public ObservableMapCellWithIconLabelProvider(Map<String, ColorDescriptor> customTextColoringMapping, IObservableMap ... attributeMaps) {
        super(attributeMaps);
        this.customTextColoringMapping = ImmutableMap.copyOf(customTextColoringMapping);
    }

    public StyledString getStyledText(Object element) {
        Object label = this.attributeMaps[0].get(element);
        String rawLabel = label == null ? "" : label.toString();
        StyledString styledLabel = new StyledString(rawLabel);
        for (String text : this.customTextColoringMapping.keySet()) {
            this.assignColorToText(rawLabel, styledLabel, text);
        }
        return styledLabel;
    }

    private void assignColorToText(String rawLabel, StyledString styledLabel, final String text) {
        int index = rawLabel.indexOf(text);
        if (index >= 0) {
            StyledString.Styler styler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    ColorDescriptor substringColorDescriptor = (ColorDescriptor)ObservableMapCellWithIconLabelProvider.this.customTextColoringMapping.get((Object)text);
                    textStyle.foreground = ObservableMapCellWithIconLabelProvider.this.resourceManager.createColor(substringColorDescriptor);
                }
            };
            styledLabel.setStyle(index, text.length(), styler);
        }
    }

    public Image getImage(Object element) {
        Object imageDescriptor = this.attributeMaps[1].get(element);
        if (imageDescriptor instanceof ImageDescriptor) {
            return this.resourceManager.createImage((ImageDescriptor)imageDescriptor);
        }
        return null;
    }

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }
}

