/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core;

import com.gradleware.tooling.toolingclient.ToolingClient;
import com.gradleware.tooling.toolingmodel.repository.Environment;
import com.gradleware.tooling.toolingmodel.repository.ModelRepositoryProvider;
import com.gradleware.tooling.toolingmodel.repository.ModelRepositoryProviderFactory;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.buildship.core.Logger;
import org.eclipse.buildship.core.configuration.ProjectConfigurationManager;
import org.eclipse.buildship.core.configuration.internal.DefaultProjectConfigurationManager;
import org.eclipse.buildship.core.console.ProcessStreamsProvider;
import org.eclipse.buildship.core.console.internal.StdProcessStreamsProvider;
import org.eclipse.buildship.core.event.ListenerRegistry;
import org.eclipse.buildship.core.event.internal.DefaultListenerRegistry;
import org.eclipse.buildship.core.launch.GradleLaunchConfigurationManager;
import org.eclipse.buildship.core.launch.internal.DefaultGradleLaunchConfigurationManager;
import org.eclipse.buildship.core.notification.UserNotification;
import org.eclipse.buildship.core.notification.internal.ConsoleUserNotification;
import org.eclipse.buildship.core.util.gradle.PublishedGradleVersionsWrapper;
import org.eclipse.buildship.core.util.logging.EclipseLogger;
import org.eclipse.buildship.core.workspace.WorkspaceOperations;
import org.eclipse.buildship.core.workspace.internal.DefaultWorkspaceOperations;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public final class CorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.buildship.core";
    private static CorePlugin plugin;
    private ServiceRegistration loggerService;
    private ServiceRegistration publishedGradleVersionsService;
    private ServiceRegistration toolingClientService;
    private ServiceRegistration modelRepositoryProviderService;
    private ServiceRegistration workspaceOperationsService;
    private ServiceRegistration projectConfigurationManagerService;
    private ServiceRegistration processStreamsProviderService;
    private ServiceRegistration gradleLaunchConfigurationService;
    private ServiceRegistration listenerRegistryService;
    private ServiceRegistration userNotificationService;
    private ServiceTracker loggerServiceTracker;
    private ServiceTracker publishedGradleVersionsServiceTracker;
    private ServiceTracker toolingClientServiceTracker;
    private ServiceTracker modelRepositoryProviderServiceTracker;
    private ServiceTracker workspaceOperationsServiceTracker;
    private ServiceTracker projectConfigurationManagerServiceTracker;
    private ServiceTracker processStreamsProviderServiceTracker;
    private ServiceTracker gradleLaunchConfigurationServiceTracker;
    private ServiceTracker listenerRegistryServiceTracker;
    private ServiceTracker userNotificationServiceTracker;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.registerServices(bundleContext);
    }

    public void stop(BundleContext context) throws Exception {
        this.unregisterServices();
        plugin = null;
        super.stop(context);
    }

    private void registerServices(BundleContext context) {
        Hashtable<String, Object> preferences = new Hashtable<String, Object>();
        ((Dictionary)preferences).put("service.ranking", 1);
        this.loggerServiceTracker = this.createServiceTracker(context, Logger.class);
        this.publishedGradleVersionsServiceTracker = this.createServiceTracker(context, PublishedGradleVersionsWrapper.class);
        this.toolingClientServiceTracker = this.createServiceTracker(context, ToolingClient.class);
        this.modelRepositoryProviderServiceTracker = this.createServiceTracker(context, ModelRepositoryProvider.class);
        this.workspaceOperationsServiceTracker = this.createServiceTracker(context, WorkspaceOperations.class);
        this.projectConfigurationManagerServiceTracker = this.createServiceTracker(context, ProjectConfigurationManager.class);
        this.processStreamsProviderServiceTracker = this.createServiceTracker(context, ProcessStreamsProvider.class);
        this.gradleLaunchConfigurationServiceTracker = this.createServiceTracker(context, GradleLaunchConfigurationManager.class);
        this.listenerRegistryServiceTracker = this.createServiceTracker(context, ListenerRegistry.class);
        this.userNotificationServiceTracker = this.createServiceTracker(context, UserNotification.class);
        this.loggerService = this.registerService(context, Logger.class, this.createLogger(), preferences);
        this.publishedGradleVersionsService = this.registerService(context, PublishedGradleVersionsWrapper.class, this.createPublishedGradleVersions(), preferences);
        this.toolingClientService = this.registerService(context, ToolingClient.class, this.createToolingClient(), preferences);
        this.modelRepositoryProviderService = this.registerService(context, ModelRepositoryProvider.class, this.createModelRepositoryProvider(), preferences);
        this.workspaceOperationsService = this.registerService(context, WorkspaceOperations.class, this.createWorkspaceOperations(), preferences);
        this.projectConfigurationManagerService = this.registerService(context, ProjectConfigurationManager.class, this.createProjectConfigurationManager(), preferences);
        this.processStreamsProviderService = this.registerService(context, ProcessStreamsProvider.class, this.createProcessStreamsProvider(), preferences);
        this.gradleLaunchConfigurationService = this.registerService(context, GradleLaunchConfigurationManager.class, this.createGradleLaunchConfigurationManager(), preferences);
        this.listenerRegistryService = this.registerService(context, ListenerRegistry.class, this.createListenerRegistry(), preferences);
        this.userNotificationService = this.registerService(context, UserNotification.class, this.createUserNotification(), preferences);
    }

    private ServiceTracker createServiceTracker(BundleContext context, Class<?> clazz) {
        ServiceTracker serviceTracker = new ServiceTracker(context, clazz.getName(), null);
        serviceTracker.open();
        return serviceTracker;
    }

    private <T> ServiceRegistration registerService(BundleContext context, Class<T> clazz, T service, Dictionary<String, Object> properties) {
        return context.registerService(clazz.getName(), service, properties);
    }

    private EclipseLogger createLogger() {
        return new EclipseLogger(this.getLog(), PLUGIN_ID, this.isDebugging());
    }

    private PublishedGradleVersionsWrapper createPublishedGradleVersions() {
        return new PublishedGradleVersionsWrapper();
    }

    private ToolingClient createToolingClient() {
        return ToolingClient.newClient();
    }

    private ModelRepositoryProvider createModelRepositoryProvider() {
        ToolingClient toolingClient = (ToolingClient)this.toolingClientServiceTracker.getService();
        return ModelRepositoryProviderFactory.create((ToolingClient)toolingClient, (Environment)Environment.ECLIPSE);
    }

    private WorkspaceOperations createWorkspaceOperations() {
        return new DefaultWorkspaceOperations();
    }

    private ProjectConfigurationManager createProjectConfigurationManager() {
        WorkspaceOperations workspaceOperations = (WorkspaceOperations)this.workspaceOperationsServiceTracker.getService();
        return new DefaultProjectConfigurationManager(workspaceOperations);
    }

    private ProcessStreamsProvider createProcessStreamsProvider() {
        return new StdProcessStreamsProvider();
    }

    private GradleLaunchConfigurationManager createGradleLaunchConfigurationManager() {
        return new DefaultGradleLaunchConfigurationManager();
    }

    private ListenerRegistry createListenerRegistry() {
        return new DefaultListenerRegistry();
    }

    private UserNotification createUserNotification() {
        return new ConsoleUserNotification();
    }

    private void unregisterServices() {
        this.userNotificationService.unregister();
        this.listenerRegistryService.unregister();
        this.gradleLaunchConfigurationService.unregister();
        this.processStreamsProviderService.unregister();
        this.projectConfigurationManagerService.unregister();
        this.workspaceOperationsService.unregister();
        this.modelRepositoryProviderService.unregister();
        this.toolingClientService.unregister();
        this.publishedGradleVersionsService.unregister();
        this.loggerService.unregister();
        this.userNotificationServiceTracker.close();
        this.listenerRegistryServiceTracker.close();
        this.gradleLaunchConfigurationServiceTracker.close();
        this.processStreamsProviderServiceTracker.close();
        this.projectConfigurationManagerServiceTracker.close();
        this.workspaceOperationsServiceTracker.close();
        this.modelRepositoryProviderServiceTracker.close();
        this.toolingClientServiceTracker.close();
        this.publishedGradleVersionsServiceTracker.close();
        this.loggerServiceTracker.close();
    }

    public static CorePlugin getInstance() {
        return plugin;
    }

    public static Logger logger() {
        return (Logger)CorePlugin.getInstance().loggerServiceTracker.getService();
    }

    public static PublishedGradleVersionsWrapper publishedGradleVersions() {
        return (PublishedGradleVersionsWrapper)CorePlugin.getInstance().publishedGradleVersionsServiceTracker.getService();
    }

    public static ToolingClient toolingClient() {
        return (ToolingClient)CorePlugin.getInstance().toolingClientServiceTracker.getService();
    }

    public static ModelRepositoryProvider modelRepositoryProvider() {
        return (ModelRepositoryProvider)CorePlugin.getInstance().modelRepositoryProviderServiceTracker.getService();
    }

    public static WorkspaceOperations workspaceOperations() {
        return (WorkspaceOperations)CorePlugin.getInstance().workspaceOperationsServiceTracker.getService();
    }

    public static ProjectConfigurationManager projectConfigurationManager() {
        return (ProjectConfigurationManager)CorePlugin.getInstance().projectConfigurationManagerServiceTracker.getService();
    }

    public static ProcessStreamsProvider processStreamsProvider() {
        return (ProcessStreamsProvider)CorePlugin.getInstance().processStreamsProviderServiceTracker.getService();
    }

    public static GradleLaunchConfigurationManager gradleLaunchConfigurationManager() {
        return (GradleLaunchConfigurationManager)CorePlugin.getInstance().gradleLaunchConfigurationServiceTracker.getService();
    }

    public static ListenerRegistry listenerRegistry() {
        return (ListenerRegistry)CorePlugin.getInstance().listenerRegistryServiceTracker.getService();
    }

    public static UserNotification userNotification() {
        return (UserNotification)CorePlugin.getInstance().userNotificationServiceTracker.getService();
    }
}

