/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepositoryProvider;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.util.predicate.Predicates;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.core.workspace.GradleClasspathContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;

public final class RefreshGradleProjectJob
extends Job {
    private final FixedRequestAttributes rootRequestAttributes;
    private final CancellationTokenSource tokenSource;

    public RefreshGradleProjectJob(FixedRequestAttributes rootRequestAttributes) {
        super("Reload root project at " + ((FixedRequestAttributes)Preconditions.checkNotNull((Object)rootRequestAttributes)).getProjectDir().getAbsolutePath());
        this.rootRequestAttributes = rootRequestAttributes;
        this.tokenSource = GradleConnector.newCancellationTokenSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Reload projects and request project update", -1);
        try {
            OmniEclipseGradleBuild result = this.forceReloadEclipseGradleBuild(this.rootRequestAttributes, monitor);
            this.requestUpdateOnAllWorkspaceProject(result.getRootEclipseProject().getAll());
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(2, "org.eclipse.buildship.core", "refresh failed", (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    private OmniEclipseGradleBuild forceReloadEclipseGradleBuild(FixedRequestAttributes requestAttributes, IProgressMonitor monitor) {
        ProcessStreams streams = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
        ImmutableList listeners = ImmutableList.of((Object)new DelegatingProgressListener(monitor));
        TransientRequestAttributes transientAttributes = new TransientRequestAttributes(false, streams.getOutput(), streams.getError(), streams.getInput(), (List)listeners, (List)ImmutableList.of(), this.tokenSource.token());
        ModelRepositoryProvider repository = CorePlugin.modelRepositoryProvider();
        return repository.getModelRepository(requestAttributes).fetchEclipseGradleBuild(transientAttributes, FetchStrategy.FORCE_RELOAD);
    }

    private void requestUpdateOnAllWorkspaceProject(List<OmniEclipseProject> gradleProjects) {
        for (OmniEclipseProject gradleProject : gradleProjects) {
            this.requestUpdateOnWorkspaceProject(gradleProject);
        }
    }

    private void requestUpdateOnWorkspaceProject(OmniEclipseProject gradleProject) {
        Optional<IProject> workspaceProject = CorePlugin.workspaceOperations().findProjectByLocation(gradleProject.getProjectDirectory());
        if (workspaceProject.isPresent() && Predicates.accessibleGradleJavaProject().apply(workspaceProject.get())) {
            IJavaProject javaProject = JavaCore.create((IProject)((IProject)workspaceProject.get()));
            GradleClasspathContainer.requestUpdateOf(javaProject);
        }
    }

    public boolean belongsTo(Object family) {
        return RefreshGradleProjectJob.class.getName().equals(family);
    }

    protected void canceling() {
        this.tokenSource.cancel();
    }
}

